/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSRequest;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.KeyExchangeAlgorithm;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.NullOutputStream;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsFatalAlertReceived;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContextImpl;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean bl) {
        this.verifyRequests = bl;
    }

    public DTLSTransport accept(TlsServer tlsServer, DatagramTransport datagramTransport) throws IOException {
        return this.accept(tlsServer, datagramTransport, null);
    }

    public DTLSTransport accept(TlsServer tlsServer, DatagramTransport datagramTransport, DTLSRequest dTLSRequest) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        TlsServerContextImpl tlsServerContextImpl = new TlsServerContextImpl(tlsServer.getCrypto());
        tlsServer.init(tlsServerContextImpl);
        tlsServerContextImpl.handshakeBeginning(tlsServer);
        SecurityParameters securityParameters = tlsServerContextImpl.getSecurityParametersHandshake();
        securityParameters.extendedPadding = tlsServer.shouldUseExtendedPadding();
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(tlsServerContextImpl, tlsServer, datagramTransport);
        tlsServer.notifyCloseHandle(dTLSRecordLayer);
        ServerHandshakeState serverHandshakeState = new ServerHandshakeState();
        serverHandshakeState.server = tlsServer;
        serverHandshakeState.serverContext = tlsServerContextImpl;
        serverHandshakeState.recordLayer = dTLSRecordLayer;
        try {
            DTLSTransport dTLSTransport = this.serverHandshake(serverHandshakeState, dTLSRequest);
            return dTLSTransport;
        }
        catch (TlsFatalAlertReceived tlsFatalAlertReceived) {
            this.invalidateSession(serverHandshakeState);
            throw tlsFatalAlertReceived;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortServerHandshake(serverHandshakeState, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortServerHandshake(serverHandshakeState, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortServerHandshake(serverHandshakeState, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortServerHandshake(ServerHandshakeState serverHandshakeState, short s) {
        serverHandshakeState.recordLayer.fail(s);
        this.invalidateSession(serverHandshakeState);
    }

    protected DTLSTransport serverHandshake(ServerHandshakeState serverHandshakeState, DTLSRequest dTLSRequest) throws IOException {
        Object object;
        TlsServer tlsServer = serverHandshakeState.server;
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        DTLSRecordLayer dTLSRecordLayer = serverHandshakeState.recordLayer;
        SecurityParameters securityParameters = tlsServerContextImpl.getSecurityParametersHandshake();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake(tlsServerContextImpl, dTLSRecordLayer, tlsServer.getHandshakeTimeoutMillis(), tlsServer.getHandshakeResendTimeMillis(), dTLSRequest);
        DTLSReliableHandshake.Message message = null;
        if (null == dTLSRequest) {
            message = dTLSReliableHandshake.receiveMessage();
            if (message.getType() != 1) {
                throw new TlsFatalAlert(10);
            }
            this.processClientHello(serverHandshakeState, message.getBody());
            message = null;
        } else {
            this.processClientHello(serverHandshakeState, dTLSRequest.getClientHello());
            dTLSRequest = null;
        }
        Object object2 = this.generateServerHello(serverHandshakeState);
        dTLSReliableHandshake.sendMessage((short)2, (byte[])object2);
        dTLSReliableHandshake.getHandshakeHash().notifyPRFDetermined();
        if (securityParameters.isResumedSession()) {
            securityParameters.masterSecret = serverHandshakeState.sessionMasterSecret;
            dTLSRecordLayer.initPendingEpoch(TlsUtils.initCipher(tlsServerContextImpl));
            securityParameters.localVerifyData = TlsUtils.calculateVerifyData(tlsServerContextImpl, dTLSReliableHandshake.getHandshakeHash(), true);
            dTLSReliableHandshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
            securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(tlsServerContextImpl, dTLSReliableHandshake.getHandshakeHash(), false);
            this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
            dTLSReliableHandshake.finish();
            if (securityParameters.isExtendedMasterSecret() && ProtocolVersion.DTLSv12.isEqualOrLaterVersionOf(securityParameters.getNegotiatedVersion())) {
                securityParameters.tlsUnique = securityParameters.getLocalVerifyData();
            }
            securityParameters.localCertificate = serverHandshakeState.sessionParameters.getLocalCertificate();
            securityParameters.peerCertificate = serverHandshakeState.sessionParameters.getPeerCertificate();
            securityParameters.pskIdentity = serverHandshakeState.sessionParameters.getPSKIdentity();
            securityParameters.srpIdentity = serverHandshakeState.sessionParameters.getSRPIdentity();
            tlsServerContextImpl.handshakeComplete(tlsServer, serverHandshakeState.tlsSession);
            dTLSRecordLayer.initHeartbeat(serverHandshakeState.heartbeat, 1 == serverHandshakeState.heartbeatPolicy);
            return new DTLSTransport(dTLSRecordLayer);
        }
        object2 = tlsServer.getServerSupplementalData();
        if (object2 != null) {
            object = DTLSServerProtocol.generateSupplementalData((Vector)object2);
            dTLSReliableHandshake.sendMessage((short)23, (byte[])object);
        }
        serverHandshakeState.keyExchange = TlsUtils.initKeyExchangeServer(tlsServerContextImpl, tlsServer);
        object = null;
        if (!KeyExchangeAlgorithm.isAnonymous(securityParameters.getKeyExchangeAlgorithm())) {
            object = TlsUtils.establishServerCredentials(tlsServer);
        }
        Object object3 = null;
        Object object4 = new ByteArrayOutputStream();
        if (object == null) {
            serverHandshakeState.keyExchange.skipServerCredentials();
        } else {
            serverHandshakeState.keyExchange.processServerCredentials((TlsCredentials)object);
            object3 = object.getCertificate();
            DTLSServerProtocol.sendCertificateMessage(tlsServerContextImpl, dTLSReliableHandshake, (Certificate)object3, (OutputStream)object4);
        }
        securityParameters.tlsServerEndPoint = ((ByteArrayOutputStream)object4).toByteArray();
        if (object3 == null || ((Certificate)object3).isEmpty()) {
            securityParameters.statusRequestVersion = 0;
        }
        if (securityParameters.getStatusRequestVersion() > 0 && (object3 = tlsServer.getCertificateStatus()) != null) {
            object4 = this.generateCertificateStatus(serverHandshakeState, (CertificateStatus)object3);
            dTLSReliableHandshake.sendMessage((short)22, (byte[])object4);
        }
        if ((object3 = (Object)serverHandshakeState.keyExchange.generateServerKeyExchange()) != null) {
            dTLSReliableHandshake.sendMessage((short)12, (byte[])object3);
        }
        if (object != null) {
            serverHandshakeState.certificateRequest = tlsServer.getCertificateRequest();
            if (null == serverHandshakeState.certificateRequest) {
                if (!serverHandshakeState.keyExchange.requiresCertificateVerify()) {
                    throw new TlsFatalAlert(80);
                }
            } else {
                if (TlsUtils.isTLSv12(tlsServerContextImpl) != (serverHandshakeState.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                    throw new TlsFatalAlert(80);
                }
                serverHandshakeState.certificateRequest = TlsUtils.validateCertificateRequest(serverHandshakeState.certificateRequest, serverHandshakeState.keyExchange);
                TlsUtils.establishServerSigAlgs(securityParameters, serverHandshakeState.certificateRequest);
                if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion())) {
                    TlsUtils.trackHashAlgorithms(dTLSReliableHandshake.getHandshakeHash(), securityParameters.getServerSigAlgs());
                    if (tlsServerContextImpl.getCrypto().hasAnyStreamVerifiers(securityParameters.getServerSigAlgs())) {
                        dTLSReliableHandshake.getHandshakeHash().forceBuffering();
                    }
                } else if (tlsServerContextImpl.getCrypto().hasAnyStreamVerifiersLegacy(serverHandshakeState.certificateRequest.getCertificateTypes())) {
                    dTLSReliableHandshake.getHandshakeHash().forceBuffering();
                }
            }
        }
        dTLSReliableHandshake.getHandshakeHash().sealHashAlgorithms();
        if (null != serverHandshakeState.certificateRequest) {
            object4 = this.generateCertificateRequest(serverHandshakeState, serverHandshakeState.certificateRequest);
            dTLSReliableHandshake.sendMessage((short)13, (byte[])object4);
        }
        dTLSReliableHandshake.sendMessage((short)14, TlsUtils.EMPTY_BYTES);
        message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() == 23) {
            this.processClientSupplementalData(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            tlsServer.processClientSupplementalData(null);
        }
        if (serverHandshakeState.certificateRequest == null) {
            serverHandshakeState.keyExchange.skipClientCredentials();
        } else if (message.getType() == 11) {
            this.processClientCertificate(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            if (TlsUtils.isTLSv12(tlsServerContextImpl)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(serverHandshakeState, Certificate.EMPTY_CHAIN);
        }
        if (message.getType() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(serverHandshakeState, message.getBody());
        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(dTLSReliableHandshake.getHandshakeHash());
        TlsProtocol.establishMasterSecret(tlsServerContextImpl, serverHandshakeState.keyExchange);
        serverHandshakeState.keyExchange = null;
        dTLSRecordLayer.initPendingEpoch(TlsUtils.initCipher(tlsServerContextImpl));
        if (this.expectCertificateVerifyMessage(serverHandshakeState)) {
            message = dTLSReliableHandshake.receiveMessageDelayedDigest((short)15);
            object4 = message.getBody();
            this.processCertificateVerify(serverHandshakeState, (byte[])object4, dTLSReliableHandshake.getHandshakeHash());
            dTLSReliableHandshake.prepareToFinish();
            dTLSReliableHandshake.updateHandshakeMessagesDigest(message);
        } else {
            dTLSReliableHandshake.prepareToFinish();
        }
        message = null;
        securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(tlsServerContextImpl, dTLSReliableHandshake.getHandshakeHash(), false);
        this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
        if (serverHandshakeState.expectSessionTicket) {
            object4 = tlsServer.getNewSessionTicket();
            byte[] byArray = this.generateNewSessionTicket(serverHandshakeState, (NewSessionTicket)object4);
            dTLSReliableHandshake.sendMessage((short)4, byArray);
        }
        securityParameters.localVerifyData = TlsUtils.calculateVerifyData(tlsServerContextImpl, dTLSReliableHandshake.getHandshakeHash(), true);
        dTLSReliableHandshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
        dTLSReliableHandshake.finish();
        serverHandshakeState.sessionMasterSecret = securityParameters.getMasterSecret();
        serverHandshakeState.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(tlsServerContextImpl.getCrypto().adoptSecret(serverHandshakeState.sessionMasterSecret)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(serverHandshakeState.serverExtensions).build();
        serverHandshakeState.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), serverHandshakeState.sessionParameters);
        if (ProtocolVersion.DTLSv12.isEqualOrLaterVersionOf(securityParameters.getNegotiatedVersion())) {
            securityParameters.tlsUnique = securityParameters.getPeerVerifyData();
        }
        tlsServerContextImpl.handshakeComplete(tlsServer, serverHandshakeState.tlsSession);
        dTLSRecordLayer.initHeartbeat(serverHandshakeState.heartbeat, 1 == serverHandshakeState.heartbeatPolicy);
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState serverHandshakeState, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.encode(serverHandshakeState.serverContext, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateCertificateStatus(ServerHandshakeState serverHandshakeState, CertificateStatus certificateStatus) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatus.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState serverHandshakeState, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        newSessionTicket.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState serverHandshakeState) throws IOException {
        TlsServer tlsServer = serverHandshakeState.server;
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        SecurityParameters securityParameters = tlsServerContextImpl.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = tlsServer.getServerVersion();
        if (!ProtocolVersion.contains(tlsServerContextImpl.getClientSupportedVersions(), protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.negotiatedVersion = protocolVersion;
        serverHandshakeState.recordLayer.setReadVersion(protocolVersion);
        serverHandshakeState.recordLayer.setWriteVersion(protocolVersion);
        boolean bl = tlsServer.shouldUseGMTUnixTime();
        securityParameters.serverRandom = TlsProtocol.createRandomBlock(bl, tlsServerContextImpl);
        if (!protocolVersion.equals(ProtocolVersion.getLatestDTLS(tlsServer.getProtocolVersions()))) {
            TlsUtils.writeDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        Hashtable hashtable = serverHandshakeState.clientHello.getExtensions();
        TlsSession tlsSession = tlsServer.getSessionToResume(serverHandshakeState.clientHello.getSessionID());
        boolean bl2 = this.establishSession(serverHandshakeState, tlsSession);
        if (bl2 && !protocolVersion.equals(serverHandshakeState.sessionParameters.getNegotiatedVersion())) {
            bl2 = false;
        }
        boolean bl3 = false;
        if (TlsUtils.isExtendedMasterSecretOptional(protocolVersion) && tlsServer.shouldUseExtendedMasterSecret()) {
            if (TlsExtensionsUtils.hasExtendedMasterSecretExtension(hashtable)) {
                bl3 = true;
            } else {
                if (tlsServer.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40, "Extended Master Secret extension is required");
                }
                if (bl2) {
                    if (serverHandshakeState.sessionParameters.isExtendedMasterSecret()) {
                        throw new TlsFatalAlert(40, "Extended Master Secret extension is required for EMS session resumption");
                    }
                    if (!tlsServer.allowLegacyResumption()) {
                        throw new TlsFatalAlert(40, "Extended Master Secret extension is required for legacy session resumption");
                    }
                }
            }
        }
        if (bl2 && bl3 != serverHandshakeState.sessionParameters.isExtendedMasterSecret()) {
            bl2 = false;
        }
        securityParameters.extendedMasterSecret = bl3;
        if (!bl2) {
            this.cancelSession(serverHandshakeState);
            byte[] byArray = tlsServer.getNewSessionID();
            if (null == byArray) {
                byArray = TlsUtils.EMPTY_BYTES;
            }
            serverHandshakeState.tlsSession = TlsUtils.importSession(byArray, null);
        }
        securityParameters.resumedSession = bl2;
        securityParameters.sessionID = serverHandshakeState.tlsSession.getSessionID();
        tlsServer.notifySession(serverHandshakeState.tlsSession);
        TlsUtils.negotiatedVersionDTLSServer(tlsServerContextImpl);
        int n = DTLSServerProtocol.validateSelectedCipherSuite(tlsServer.getSelectedCipherSuite(), (short)80);
        if (!TlsUtils.isValidCipherSuiteSelection(serverHandshakeState.clientHello.getCipherSuites(), n) || !TlsUtils.isValidVersionForCipherSuite(n, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        Object object = bl2 ? serverHandshakeState.sessionParameters.readServerExtensions() : tlsServer.getServerExtensions();
        serverHandshakeState.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised((Hashtable)object);
        tlsServer.getServerExtensionsForConnection(serverHandshakeState.serverExtensions);
        if (securityParameters.isSecureRenegotiation()) {
            boolean bl4;
            object = TlsUtils.getExtensionData(serverHandshakeState.serverExtensions, TlsProtocol.EXT_RenegotiationInfo);
            boolean bl5 = bl4 = null == object;
            if (bl4) {
                serverHandshakeState.serverExtensions.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (securityParameters.isExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(serverHandshakeState.serverExtensions);
        } else {
            serverHandshakeState.serverExtensions.remove(TlsExtensionsUtils.EXT_extended_master_secret);
        }
        if (null != serverHandshakeState.heartbeat || 1 == serverHandshakeState.heartbeatPolicy) {
            TlsExtensionsUtils.addHeartbeatExtension(serverHandshakeState.serverExtensions, new HeartbeatExtension(serverHandshakeState.heartbeatPolicy));
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(serverHandshakeState.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion()) && (object = (Object)TlsExtensionsUtils.getConnectionIDExtension(serverHandshakeState.serverExtensions)) != null) {
            byte[] byArray = TlsExtensionsUtils.getConnectionIDExtension(hashtable);
            if (byArray == null) {
                throw new TlsFatalAlert(80);
            }
            securityParameters.connectionIDLocal = byArray;
            securityParameters.connectionIDPeer = (byte[])object;
        }
        if (!serverHandshakeState.serverExtensions.isEmpty()) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(serverHandshakeState.serverExtensions);
            securityParameters.maxFragmentLength = TlsUtils.processMaxFragmentLengthExtension(bl2 ? null : hashtable, serverHandshakeState.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(serverHandshakeState.serverExtensions);
            if (!bl2) {
                if (TlsUtils.hasExpectedEmptyExtensionData(serverHandshakeState.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)80)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(serverHandshakeState.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80)) {
                    securityParameters.statusRequestVersion = 1;
                }
                securityParameters.clientCertificateType = TlsUtils.processClientCertificateTypeExtension(hashtable, serverHandshakeState.serverExtensions, (short)80);
                securityParameters.serverCertificateType = TlsUtils.processServerCertificateTypeExtension(hashtable, serverHandshakeState.serverExtensions, (short)80);
                serverHandshakeState.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData(serverHandshakeState.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
            }
        }
        object = new ServerHello(protocolVersion, securityParameters.getServerRandom(), securityParameters.getSessionID(), securityParameters.getCipherSuite(), serverHandshakeState.serverExtensions);
        serverHandshakeState.clientHello = null;
        DTLSServerProtocol.applyMaxFragmentLengthExtension(serverHandshakeState.recordLayer, securityParameters.getMaxFragmentLength());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ServerHello)object).encode(tlsServerContextImpl, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void cancelSession(ServerHandshakeState serverHandshakeState) {
        if (serverHandshakeState.sessionMasterSecret != null) {
            serverHandshakeState.sessionMasterSecret.destroy();
            serverHandshakeState.sessionMasterSecret = null;
        }
        if (serverHandshakeState.sessionParameters != null) {
            serverHandshakeState.sessionParameters.clear();
            serverHandshakeState.sessionParameters = null;
        }
        serverHandshakeState.tlsSession = null;
    }

    protected boolean establishSession(ServerHandshakeState serverHandshakeState, TlsSession tlsSession) {
        serverHandshakeState.tlsSession = null;
        serverHandshakeState.sessionParameters = null;
        serverHandshakeState.sessionMasterSecret = null;
        if (null == tlsSession || !tlsSession.isResumable()) {
            return false;
        }
        SessionParameters sessionParameters = tlsSession.exportSessionParameters();
        if (null == sessionParameters) {
            return false;
        }
        ProtocolVersion protocolVersion = sessionParameters.getNegotiatedVersion();
        if (null == protocolVersion || !protocolVersion.isDTLS()) {
            return false;
        }
        if (!sessionParameters.isExtendedMasterSecret() && !TlsUtils.isExtendedMasterSecretOptional(protocolVersion)) {
            return false;
        }
        TlsCrypto tlsCrypto = serverHandshakeState.serverContext.getCrypto();
        TlsSecret tlsSecret = TlsUtils.getSessionMasterSecret(tlsCrypto, sessionParameters.getMasterSecret());
        if (null == tlsSecret) {
            return false;
        }
        serverHandshakeState.tlsSession = tlsSession;
        serverHandshakeState.sessionParameters = sessionParameters;
        serverHandshakeState.sessionMasterSecret = tlsSecret;
        return true;
    }

    protected void invalidateSession(ServerHandshakeState serverHandshakeState) {
        if (serverHandshakeState.tlsSession != null) {
            serverHandshakeState.tlsSession.invalidate();
        }
        this.cancelSession(serverHandshakeState);
    }

    protected void notifyClientCertificate(ServerHandshakeState serverHandshakeState, Certificate certificate) throws IOException {
        if (null == serverHandshakeState.certificateRequest) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.processClientCertificate(serverHandshakeState.serverContext, certificate, serverHandshakeState.keyExchange, serverHandshakeState.server);
    }

    protected void processClientCertificate(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate.ParseOptions parseOptions = new Certificate.ParseOptions().setCertificateType(serverHandshakeState.serverContext.getSecurityParametersHandshake().getClientCertificateType()).setMaxChainLength(serverHandshakeState.server.getMaxCertificateChainLength());
        Certificate certificate = Certificate.parse(parseOptions, serverHandshakeState.serverContext, byteArrayInputStream, null);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(serverHandshakeState, certificate);
    }

    protected void processCertificateVerify(ServerHandshakeState serverHandshakeState, byte[] byArray, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        if (serverHandshakeState.certificateRequest == null) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        DigitallySigned digitallySigned = DigitallySigned.parse(tlsServerContextImpl, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verifyCertificateVerifyClient(tlsServerContextImpl, serverHandshakeState.certificateRequest, digitallySigned, tlsHandshakeHash);
    }

    protected void processClientHello(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ClientHello clientHello = ClientHello.parse(byteArrayInputStream, NullOutputStream.INSTANCE);
        this.processClientHello(serverHandshakeState, clientHello);
    }

    protected void processClientHello(ServerHandshakeState serverHandshakeState, ClientHello clientHello) throws IOException {
        serverHandshakeState.recordLayer.setWriteVersion(ProtocolVersion.DTLSv10);
        serverHandshakeState.clientHello = clientHello;
        ProtocolVersion protocolVersion = clientHello.getVersion();
        int[] nArray = clientHello.getCipherSuites();
        Hashtable hashtable = clientHello.getExtensions();
        TlsServer tlsServer = serverHandshakeState.server;
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        SecurityParameters securityParameters = tlsServerContextImpl.getSecurityParametersHandshake();
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        tlsServerContextImpl.setRSAPreMasterSecretVersion(protocolVersion);
        tlsServerContextImpl.setClientSupportedVersions(TlsExtensionsUtils.getSupportedVersionsExtensionClient(hashtable));
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (null == tlsServerContextImpl.getClientSupportedVersions()) {
            if (protocolVersion2.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
                protocolVersion2 = ProtocolVersion.DTLSv12;
            }
            tlsServerContextImpl.setClientSupportedVersions(protocolVersion2.downTo(ProtocolVersion.DTLSv10));
        } else {
            protocolVersion2 = ProtocolVersion.getLatestDTLS(tlsServerContextImpl.getClientSupportedVersions());
        }
        if (!ProtocolVersion.SERVER_EARLIEST_SUPPORTED_DTLS.isEqualOrEarlierVersionOf(protocolVersion2)) {
            throw new TlsFatalAlert(70);
        }
        tlsServerContextImpl.setClientVersion(protocolVersion2);
        tlsServer.notifyClientVersion(tlsServerContextImpl.getClientVersion());
        securityParameters.clientRandom = clientHello.getRandom();
        tlsServer.notifyFallback(Arrays.contains((int[])nArray, (int)22016));
        tlsServer.notifyOfferedCipherSuites(nArray);
        byte[] byArray = TlsUtils.getExtensionData(hashtable, TlsProtocol.EXT_RenegotiationInfo);
        if (Arrays.contains((int[])nArray, (int)255)) {
            securityParameters.secureRenegotiation = true;
        }
        if (byArray != null) {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        tlsServer.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        if (hashtable != null) {
            TlsExtensionsUtils.getPaddingExtension(hashtable);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(hashtable);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion2)) {
                TlsUtils.establishClientSigAlgs(securityParameters, hashtable);
            }
            securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(hashtable);
            HeartbeatExtension heartbeatExtension = TlsExtensionsUtils.getHeartbeatExtension(hashtable);
            if (null != heartbeatExtension) {
                if (1 == heartbeatExtension.getMode()) {
                    serverHandshakeState.heartbeat = tlsServer.getHeartbeat();
                }
                serverHandshakeState.heartbeatPolicy = tlsServer.getHeartbeatPolicy();
            }
            tlsServer.processClientExtensions(hashtable);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        serverHandshakeState.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processClientSupplementalData(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        serverHandshakeState.server.processClientSupplementalData(vector);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState serverHandshakeState) {
        if (null == serverHandshakeState.certificateRequest) {
            return false;
        }
        Certificate certificate = serverHandshakeState.serverContext.getSecurityParametersHandshake().getPeerCertificate();
        return null != certificate && !certificate.isEmpty() && (null == serverHandshakeState.keyExchange || serverHandshakeState.keyExchange.requiresCertificateVerify());
    }

    protected static class ServerHandshakeState {
        TlsServer server = null;
        TlsServerContextImpl serverContext = null;
        DTLSRecordLayer recordLayer = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        TlsSecret sessionMasterSecret = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        ClientHello clientHello = null;
        Hashtable serverExtensions = null;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        CertificateRequest certificateRequest = null;
        TlsHeartbeat heartbeat = null;
        short heartbeatPolicy = (short)2;

        protected ServerHandshakeState() {
        }
    }
}

