/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

class Timeout {
    private long durationMillis;
    private long startMillis;

    Timeout(long l) {
        this(l, System.currentTimeMillis());
    }

    Timeout(long l, long l2) {
        this.durationMillis = Math.max(0L, l);
        this.startMillis = Math.max(0L, l2);
    }

    synchronized long remainingMillis(long l) {
        if (this.startMillis > l) {
            this.startMillis = l;
            return this.durationMillis;
        }
        long l2 = l - this.startMillis;
        long l3 = this.durationMillis - l2;
        if (l3 <= 0L) {
            this.durationMillis = 0L;
            return 0L;
        }
        return l3;
    }

    static int constrainWaitMillis(int n, Timeout timeout, long l) {
        if (n < 0) {
            return -1;
        }
        int n2 = Timeout.getWaitMillis(timeout, l);
        if (n2 < 0) {
            return -1;
        }
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        return Math.min(n, n2);
    }

    static Timeout forWaitMillis(int n, long l) {
        if (n < 0) {
            throw new IllegalArgumentException("'waitMillis' cannot be negative");
        }
        if (n > 0) {
            return new Timeout(n, l);
        }
        return null;
    }

    static int getWaitMillis(Timeout timeout, long l) {
        if (null == timeout) {
            return 0;
        }
        long l2 = timeout.remainingMillis(l);
        if (l2 < 1L) {
            return -1;
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    static boolean hasExpired(Timeout timeout, long l) {
        return null != timeout && timeout.remainingMillis(l) < 1L;
    }
}

