/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAParameters;

public class PQCUtil {
    public static ASN1ObjectIdentifier getMLDSAObjectidentifier(int n) {
        switch (n) {
            case 2308: {
                return NISTObjectIdentifiers.id_ml_dsa_44;
            }
            case 2309: {
                return NISTObjectIdentifiers.id_ml_dsa_65;
            }
            case 2310: {
                return NISTObjectIdentifiers.id_ml_dsa_87;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getMLDSASignatureScheme(MLDSAParameters mLDSAParameters) {
        if (MLDSAParameters.ml_dsa_44 == mLDSAParameters) {
            return 2308;
        }
        if (MLDSAParameters.ml_dsa_65 == mLDSAParameters) {
            return 2309;
        }
        if (MLDSAParameters.ml_dsa_87 == mLDSAParameters) {
            return 2310;
        }
        throw new IllegalArgumentException();
    }

    public static ASN1ObjectIdentifier getSLHDSAObjectidentifier(int n) {
        switch (n) {
            case 2321: {
                return NISTObjectIdentifiers.id_slh_dsa_sha2_128s;
            }
            case 2322: {
                return NISTObjectIdentifiers.id_slh_dsa_sha2_128f;
            }
            case 2323: {
                return NISTObjectIdentifiers.id_slh_dsa_sha2_192s;
            }
            case 2324: {
                return NISTObjectIdentifiers.id_slh_dsa_sha2_192f;
            }
            case 2325: {
                return NISTObjectIdentifiers.id_slh_dsa_sha2_256s;
            }
            case 2326: {
                return NISTObjectIdentifiers.id_slh_dsa_sha2_256f;
            }
            case 2327: {
                return NISTObjectIdentifiers.id_slh_dsa_shake_128s;
            }
            case 2328: {
                return NISTObjectIdentifiers.id_slh_dsa_shake_128f;
            }
            case 2329: {
                return NISTObjectIdentifiers.id_slh_dsa_shake_192s;
            }
            case 2330: {
                return NISTObjectIdentifiers.id_slh_dsa_shake_192f;
            }
            case 2331: {
                return NISTObjectIdentifiers.id_slh_dsa_shake_256s;
            }
            case 2332: {
                return NISTObjectIdentifiers.id_slh_dsa_shake_256f;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getSLHDSASignatureScheme(SLHDSAParameters sLHDSAParameters) {
        if (SLHDSAParameters.sha2_128s == sLHDSAParameters) {
            return 2321;
        }
        if (SLHDSAParameters.sha2_128f == sLHDSAParameters) {
            return 2322;
        }
        if (SLHDSAParameters.sha2_192s == sLHDSAParameters) {
            return 2323;
        }
        if (SLHDSAParameters.sha2_192f == sLHDSAParameters) {
            return 2324;
        }
        if (SLHDSAParameters.sha2_256s == sLHDSAParameters) {
            return 2325;
        }
        if (SLHDSAParameters.sha2_256f == sLHDSAParameters) {
            return 2326;
        }
        if (SLHDSAParameters.shake_128s == sLHDSAParameters) {
            return 2327;
        }
        if (SLHDSAParameters.shake_128f == sLHDSAParameters) {
            return 2328;
        }
        if (SLHDSAParameters.shake_192s == sLHDSAParameters) {
            return 2329;
        }
        if (SLHDSAParameters.shake_192f == sLHDSAParameters) {
            return 2330;
        }
        if (SLHDSAParameters.shake_256s == sLHDSAParameters) {
            return 2331;
        }
        if (SLHDSAParameters.shake_256f == sLHDSAParameters) {
            return 2332;
        }
        throw new IllegalArgumentException();
    }

    public static boolean supportsMLDSA(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return PQCUtil.hasOidWithNullParameters(algorithmIdentifier, aSN1ObjectIdentifier);
    }

    public static boolean supportsSLHDSA(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return PQCUtil.hasOidWithNullParameters(algorithmIdentifier, aSN1ObjectIdentifier);
    }

    private static boolean hasOidWithNullParameters(AlgorithmIdentifier algorithmIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)aSN1ObjectIdentifier) && algorithmIdentifier.getParameters() == null;
    }
}

