/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.tls.TlsRsaKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

public class BcDefaultTlsCredentialedDecryptor
implements TlsCredentialedDecryptor {
    protected BcTlsCrypto crypto;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public BcDefaultTlsCredentialedDecryptor(BcTlsCrypto bcTlsCrypto, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (bcTlsCrypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(asymmetricKeyParameter instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.crypto = bcTlsCrypto;
        this.certificate = certificate;
        this.privateKey = asymmetricKeyParameter;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public TlsSecret decrypt(TlsCryptoParameters tlsCryptoParameters, byte[] byArray) throws IOException {
        return this.safeDecryptPreMasterSecret(tlsCryptoParameters, (RSAKeyParameters)this.privateKey, byArray);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters tlsCryptoParameters, RSAKeyParameters rSAKeyParameters, byte[] byArray) {
        ProtocolVersion protocolVersion = tlsCryptoParameters.getRSAPreMasterSecretVersion();
        byte[] byArray2 = TlsRsaKeyExchange.decryptPreMasterSecret((byte[])byArray, (int)0, (int)byArray.length, (RSAKeyParameters)rSAKeyParameters, (int)protocolVersion.getFullVersion(), (SecureRandom)this.crypto.getSecureRandom());
        return this.crypto.createSecret(byArray2);
    }
}

