/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsKemConfig;
import org.bouncycastle.tls.crypto.TlsKemDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsMLKem;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;

public class BcTlsMLKemDomain
implements TlsKemDomain {
    protected final BcTlsCrypto crypto;
    protected final MLKEMParameters domainParameters;
    protected final boolean isServer;

    public static MLKEMParameters getDomainParameters(TlsKemConfig tlsKemConfig) {
        switch (tlsKemConfig.getNamedGroup()) {
            case 512: 
            case 583: {
                return MLKEMParameters.ml_kem_512;
            }
            case 513: 
            case 584: {
                return MLKEMParameters.ml_kem_768;
            }
            case 514: 
            case 585: {
                return MLKEMParameters.ml_kem_1024;
            }
        }
        throw new IllegalArgumentException("No ML-KEM configuration provided");
    }

    public BcTlsMLKemDomain(BcTlsCrypto bcTlsCrypto, TlsKemConfig tlsKemConfig) {
        this.crypto = bcTlsCrypto;
        this.domainParameters = BcTlsMLKemDomain.getDomainParameters(tlsKemConfig);
        this.isServer = tlsKemConfig.isServer();
    }

    public BcTlsSecret adoptLocalSecret(byte[] byArray) {
        return this.crypto.adoptLocalSecret(byArray);
    }

    public TlsAgreement createKem() {
        return new BcTlsMLKem(this);
    }

    public BcTlsSecret decapsulate(MLKEMPrivateKeyParameters mLKEMPrivateKeyParameters, byte[] byArray) {
        MLKEMExtractor mLKEMExtractor = new MLKEMExtractor(mLKEMPrivateKeyParameters);
        byte[] byArray2 = mLKEMExtractor.extractSecret(byArray);
        return this.adoptLocalSecret(byArray2);
    }

    public MLKEMPublicKeyParameters decodePublicKey(byte[] byArray) {
        return new MLKEMPublicKeyParameters(this.domainParameters, byArray);
    }

    public SecretWithEncapsulation encapsulate(MLKEMPublicKeyParameters mLKEMPublicKeyParameters) {
        MLKEMGenerator mLKEMGenerator = new MLKEMGenerator(this.crypto.getSecureRandom());
        return mLKEMGenerator.generateEncapsulated((AsymmetricKeyParameter)mLKEMPublicKeyParameters);
    }

    public byte[] encodePublicKey(MLKEMPublicKeyParameters mLKEMPublicKeyParameters) {
        return mLKEMPublicKeyParameters.getEncoded();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        MLKEMKeyPairGenerator mLKEMKeyPairGenerator = new MLKEMKeyPairGenerator();
        mLKEMKeyPairGenerator.init((KeyGenerationParameters)new MLKEMKeyGenerationParameters(this.crypto.getSecureRandom(), this.domainParameters));
        return mLKEMKeyPairGenerator.generateKeyPair();
    }

    public boolean isServer() {
        return this.isServer;
    }
}

