/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.MessageSignerAdapter;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSASigner;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSASigner;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.Tls13Verifier;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.LegacyTls13Verifier;
import org.bouncycastle.tls.crypto.impl.PQCUtil;
import org.bouncycastle.tls.crypto.impl.RSAUtil;
import org.bouncycastle.tls.crypto.impl.bc.BcTls13Verifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAEncryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAVerifier;

public class BcTlsRawKeyCertificate
implements TlsCertificate {
    protected final BcTlsCrypto crypto;
    protected final SubjectPublicKeyInfo keyInfo;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected Ed25519PublicKeyParameters pubKeyEd25519 = null;
    protected Ed448PublicKeyParameters pubKeyEd448 = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public BcTlsRawKeyCertificate(BcTlsCrypto bcTlsCrypto, byte[] byArray) {
        this(bcTlsCrypto, SubjectPublicKeyInfo.getInstance((Object)byArray));
    }

    public BcTlsRawKeyCertificate(BcTlsCrypto bcTlsCrypto, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.crypto = bcTlsCrypto;
        this.keyInfo = subjectPublicKeyInfo;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.keyInfo;
    }

    public TlsEncryptor createEncryptor(int n) throws IOException {
        this.validateKeyUsage(32);
        switch (n) {
            case 3: {
                this.pubKeyRSA = this.getPubKeyRSA();
                return new BcTlsRSAEncryptor(this.crypto, this.pubKeyRSA);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsVerifier createVerifier(short s) throws IOException {
        switch (s) {
            case 7: 
            case 8: {
                int n = SignatureScheme.from((short)8, s);
                Tls13Verifier tls13Verifier = this.createVerifier(n);
                return new LegacyTls13Verifier(n, tls13Verifier);
            }
        }
        this.validateKeyUsage(128);
        switch (s) {
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 1: {
                this.validateRSA_PKCS1();
                return new BcTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 9: 
            case 10: 
            case 11: {
                this.validateRSA_PSS_PSS(s);
                int n = SignatureScheme.from((short)8, s);
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), n);
            }
            case 4: 
            case 5: 
            case 6: {
                this.validateRSA_PSS_RSAE();
                int n = SignatureScheme.from((short)8, s);
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), n);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public Tls13Verifier createVerifier(int n) throws IOException {
        this.validateKeyUsage(128);
        switch (n) {
            case 515: 
            case 1027: 
            case 1283: 
            case 1539: 
            case 2074: 
            case 2075: 
            case 2076: {
                int n2 = SignatureScheme.getCryptoHashAlgorithm(n);
                Digest digest = this.crypto.createDigest(n2);
                DSADigestSigner dSADigestSigner = new DSADigestSigner((DSA)new ECDSASigner(), digest);
                dSADigestSigner.init(false, (CipherParameters)this.getPubKeyEC());
                return new BcTls13Verifier((Signer)dSADigestSigner);
            }
            case 2055: {
                Ed25519Signer ed25519Signer = new Ed25519Signer();
                ed25519Signer.init(false, (CipherParameters)this.getPubKeyEd25519());
                return new BcTls13Verifier((Signer)ed25519Signer);
            }
            case 2056: {
                Ed448Signer ed448Signer = new Ed448Signer(TlsUtils.EMPTY_BYTES);
                ed448Signer.init(false, (CipherParameters)this.getPubKeyEd448());
                return new BcTls13Verifier((Signer)ed448Signer);
            }
            case 513: 
            case 1025: 
            case 1281: 
            case 1537: {
                this.validateRSA_PKCS1();
                int n3 = SignatureScheme.getCryptoHashAlgorithm(n);
                Digest digest = this.crypto.createDigest(n3);
                RSADigestSigner rSADigestSigner = new RSADigestSigner(digest, TlsCryptoUtils.getOIDForHash(n3));
                rSADigestSigner.init(false, (CipherParameters)this.getPubKeyRSA());
                return new BcTls13Verifier((Signer)rSADigestSigner);
            }
            case 2057: 
            case 2058: 
            case 2059: {
                this.validateRSA_PSS_PSS(SignatureScheme.getSignatureAlgorithm(n));
                int n4 = SignatureScheme.getCryptoHashAlgorithm(n);
                Digest digest = this.crypto.createDigest(n4);
                PSSSigner pSSSigner = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), digest, digest.getDigestSize());
                pSSSigner.init(false, (CipherParameters)this.getPubKeyRSA());
                return new BcTls13Verifier((Signer)pSSSigner);
            }
            case 2052: 
            case 2053: 
            case 2054: {
                this.validateRSA_PSS_RSAE();
                int n5 = SignatureScheme.getCryptoHashAlgorithm(n);
                Digest digest = this.crypto.createDigest(n5);
                PSSSigner pSSSigner = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), digest, digest.getDigestSize());
                pSSSigner.init(false, (CipherParameters)this.getPubKeyRSA());
                return new BcTls13Verifier((Signer)pSSSigner);
            }
            case 2308: 
            case 2309: 
            case 2310: {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = PQCUtil.getMLDSAObjectidentifier(n);
                this.validateMLDSA(aSN1ObjectIdentifier);
                MLDSAPublicKeyParameters mLDSAPublicKeyParameters = this.getPubKeyMLDSA();
                MLDSASigner mLDSASigner = new MLDSASigner();
                mLDSASigner.init(false, (CipherParameters)mLDSAPublicKeyParameters);
                return new BcTls13Verifier((Signer)mLDSASigner);
            }
            case 2321: 
            case 2322: 
            case 2323: 
            case 2324: 
            case 2325: 
            case 2326: 
            case 2327: 
            case 2328: 
            case 2329: 
            case 2330: 
            case 2331: 
            case 2332: {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = PQCUtil.getSLHDSAObjectidentifier(n);
                this.validateSLHDSA(aSN1ObjectIdentifier);
                SLHDSAPublicKeyParameters sLHDSAPublicKeyParameters = this.getPubKeySLHDSA();
                SLHDSASigner sLHDSASigner = new SLHDSASigner();
                sLHDSASigner.init(false, (CipherParameters)sLHDSAPublicKeyParameters);
                return new BcTls13Verifier((Signer)new MessageSignerAdapter((MessageSigner)sLHDSASigner));
            }
        }
        throw new TlsFatalAlert(80);
    }

    public byte[] getEncoded() throws IOException {
        return this.keyInfo.getEncoded("DER");
    }

    public byte[] getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        return null;
    }

    public BigInteger getSerialNumber() {
        return null;
    }

    public String getSigAlgOID() {
        return null;
    }

    public ASN1Encodable getSigAlgParams() {
        return null;
    }

    public short getLegacySignatureAlgorithm() throws IOException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.getPublicKey();
        if (asymmetricKeyParameter.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        if (!this.supportsKeyUsage(128)) {
            return -1;
        }
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            return 1;
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            return 2;
        }
        if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            return 3;
        }
        return -1;
    }

    public DHPublicKeyParameters getPubKeyDH() throws IOException {
        try {
            return (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not DH", classCastException);
        }
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        try {
            return (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not DSS", classCastException);
        }
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        try {
            return (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not EC", classCastException);
        }
    }

    public Ed25519PublicKeyParameters getPubKeyEd25519() throws IOException {
        try {
            return (Ed25519PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not Ed25519", classCastException);
        }
    }

    public Ed448PublicKeyParameters getPubKeyEd448() throws IOException {
        try {
            return (Ed448PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not Ed448", classCastException);
        }
    }

    public MLDSAPublicKeyParameters getPubKeyMLDSA() throws IOException {
        try {
            return (MLDSAPublicKeyParameters)this.getPQCPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not ML-DSA", classCastException);
        }
    }

    public SLHDSAPublicKeyParameters getPubKeySLHDSA() throws IOException {
        try {
            return (SLHDSAPublicKeyParameters)this.getPQCPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not SLH-DSA", classCastException);
        }
    }

    protected AsymmetricKeyParameter getPQCPublicKey() throws IOException {
        try {
            return PublicKeyFactory.createKey((SubjectPublicKeyInfo)this.keyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43, (Throwable)runtimeException);
        }
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        try {
            return (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, "Public key not RSA", classCastException);
        }
    }

    public boolean supportsSignatureAlgorithm(short s) throws IOException {
        return this.supportsSignatureAlgorithm(s, 128);
    }

    public boolean supportsSignatureAlgorithmCA(short s) throws IOException {
        return this.supportsSignatureAlgorithm(s, 4);
    }

    public TlsCertificate checkUsageInRole(int n) throws IOException {
        switch (n) {
            case 1: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 2: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        try {
            return org.bouncycastle.crypto.util.PublicKeyFactory.createKey((SubjectPublicKeyInfo)this.keyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43, (Throwable)runtimeException);
        }
    }

    protected boolean supportsKeyUsage(int n) {
        return true;
    }

    protected boolean supportsMLDSA(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        AlgorithmIdentifier algorithmIdentifier = this.keyInfo.getAlgorithm();
        return PQCUtil.supportsMLDSA(algorithmIdentifier, aSN1ObjectIdentifier);
    }

    protected boolean supportsRSA_PKCS1() {
        AlgorithmIdentifier algorithmIdentifier = this.keyInfo.getAlgorithm();
        return RSAUtil.supportsPKCS1(algorithmIdentifier);
    }

    protected boolean supportsRSA_PSS_PSS(short s) {
        AlgorithmIdentifier algorithmIdentifier = this.keyInfo.getAlgorithm();
        return RSAUtil.supportsPSS_PSS(s, algorithmIdentifier);
    }

    protected boolean supportsRSA_PSS_RSAE() {
        AlgorithmIdentifier algorithmIdentifier = this.keyInfo.getAlgorithm();
        return RSAUtil.supportsPSS_RSAE(algorithmIdentifier);
    }

    protected boolean supportsSLHDSA(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        AlgorithmIdentifier algorithmIdentifier = this.keyInfo.getAlgorithm();
        return PQCUtil.supportsSLHDSA(algorithmIdentifier, aSN1ObjectIdentifier);
    }

    protected boolean supportsSignatureAlgorithm(short s, int n) throws IOException {
        if (!this.supportsKeyUsage(n)) {
            return false;
        }
        AsymmetricKeyParameter asymmetricKeyParameter = this.getPublicKey();
        switch (s) {
            case 1: {
                return this.supportsRSA_PKCS1() && asymmetricKeyParameter instanceof RSAKeyParameters;
            }
            case 2: {
                return asymmetricKeyParameter instanceof DSAPublicKeyParameters;
            }
            case 3: 
            case 26: 
            case 27: 
            case 28: {
                return asymmetricKeyParameter instanceof ECPublicKeyParameters;
            }
            case 7: {
                return asymmetricKeyParameter instanceof Ed25519PublicKeyParameters;
            }
            case 8: {
                return asymmetricKeyParameter instanceof Ed448PublicKeyParameters;
            }
            case 4: 
            case 5: 
            case 6: {
                return this.supportsRSA_PSS_RSAE() && asymmetricKeyParameter instanceof RSAKeyParameters;
            }
            case 9: 
            case 10: 
            case 11: {
                return this.supportsRSA_PSS_PSS(s) && asymmetricKeyParameter instanceof RSAKeyParameters;
            }
        }
        return false;
    }

    public void validateKeyUsage(int n) throws IOException {
        if (!this.supportsKeyUsage(n)) {
            switch (n) {
                case 128: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow digital signatures");
                }
                case 8: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow key agreement");
                }
                case 32: {
                    throw new TlsFatalAlert(46, "KeyUsage does not allow key encipherment");
                }
            }
            throw new TlsFatalAlert(80);
        }
    }

    protected void validateMLDSA(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        if (!this.supportsMLDSA(aSN1ObjectIdentifier)) {
            throw new TlsFatalAlert(46, "No support for ML-DSA signature scheme");
        }
    }

    protected void validateRSA_PKCS1() throws IOException {
        if (!this.supportsRSA_PKCS1()) {
            throw new TlsFatalAlert(46, "No support for rsa_pkcs1 signature schemes");
        }
    }

    protected void validateRSA_PSS_PSS(short s) throws IOException {
        if (!this.supportsRSA_PSS_PSS(s)) {
            throw new TlsFatalAlert(46, "No support for rsa_pss_pss signature schemes");
        }
    }

    protected void validateRSA_PSS_RSAE() throws IOException {
        if (!this.supportsRSA_PSS_RSAE()) {
            throw new TlsFatalAlert(46, "No support for rsa_pss_rsae signature schemes");
        }
    }

    protected void validateSLHDSA(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        if (!this.supportsSLHDSA(aSN1ObjectIdentifier)) {
            throw new TlsFatalAlert(46, "No support for SLH-DSA signature scheme");
        }
    }
}

