/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.MessageSignerAdapter;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSASigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.PQCUtil;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamSigner;

public class BcTlsSLHDSASigner
extends BcTlsSigner {
    private final int signatureScheme;

    public static BcTlsSLHDSASigner create(BcTlsCrypto bcTlsCrypto, SLHDSAPrivateKeyParameters sLHDSAPrivateKeyParameters, int n) {
        if (n != PQCUtil.getSLHDSASignatureScheme(sLHDSAPrivateKeyParameters.getParameters())) {
            return null;
        }
        return new BcTlsSLHDSASigner(bcTlsCrypto, sLHDSAPrivateKeyParameters, n);
    }

    private BcTlsSLHDSASigner(BcTlsCrypto bcTlsCrypto, SLHDSAPrivateKeyParameters sLHDSAPrivateKeyParameters, int n) {
        super(bcTlsCrypto, (AsymmetricKeyParameter)sLHDSAPrivateKeyParameters);
        if (!SignatureScheme.isSLHDSA(n)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = n;
    }

    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        SLHDSASigner sLHDSASigner = new SLHDSASigner();
        sLHDSASigner.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.privateKey, this.crypto.getSecureRandom()));
        return new BcTlsStreamSigner((Signer)new MessageSignerAdapter((MessageSigner)sLHDSASigner));
    }
}

