/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.Tls13Verifier;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsKemConfig;
import org.bouncycastle.tls.crypto.TlsKemDomain;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.AEADNonceGeneratorFactory;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.Tls13NullCipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.bouncycastle.tls.crypto.impl.jcajce.DHUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.GCMFipsUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaNonceGenerator;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaSSL3HMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTls13Verifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsHash;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JceAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherWithCBCImplicitIVImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceChaCha20Poly1305;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsHMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKemDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX25519Domain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceX448Domain;
import org.bouncycastle.tls.crypto.impl.jcajce.KemUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Client;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Server;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6VerifierGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Strings;

public class JcaTlsCrypto
extends AbstractTlsCrypto {
    private final JcaJceHelper helper;
    private final JcaJceHelper altHelper;
    private final SecureRandom entropySource;
    private final SecureRandom nonceEntropySource;
    private final Hashtable supportedEncryptionAlgorithms = new Hashtable();
    private final Hashtable supportedNamedGroups = new Hashtable();
    private final Hashtable supportedOther = new Hashtable();
    private final Hashtable supportedSignatureSchemes = new Hashtable();

    protected JcaTlsCrypto(JcaJceHelper jcaJceHelper, SecureRandom secureRandom, SecureRandom secureRandom2) {
        this(jcaJceHelper, null, secureRandom, secureRandom2);
    }

    protected JcaTlsCrypto(JcaJceHelper jcaJceHelper, JcaJceHelper jcaJceHelper2, SecureRandom secureRandom, SecureRandom secureRandom2) {
        this.helper = jcaJceHelper;
        this.altHelper = jcaJceHelper2;
        this.entropySource = secureRandom;
        this.nonceEntropySource = secureRandom2;
    }

    JceTlsSecret adoptLocalSecret(byte[] byArray) {
        return new JceTlsSecret(this, byArray);
    }

    Cipher createRSAEncryptionCipher() throws GeneralSecurityException {
        try {
            return this.getHelper().createCipher("RSA/NONE/PKCS1Padding");
        }
        catch (GeneralSecurityException generalSecurityException) {
            return this.getHelper().createCipher("RSA/ECB/PKCS1Padding");
        }
    }

    public TlsNonceGenerator createNonceGenerator(byte[] byArray) {
        return new JcaNonceGenerator(this.nonceEntropySource, byArray);
    }

    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public byte[] calculateKeyAgreement(String string, PrivateKey privateKey, PublicKey publicKey, String string2) throws GeneralSecurityException {
        KeyAgreement keyAgreement = this.helper.createKeyAgreement(string);
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        try {
            return keyAgreement.generateSecret(string2).getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if ("X25519".equals(string) || "X448".equals(string)) {
                return keyAgreement.generateSecret();
            }
            throw noSuchAlgorithmException;
        }
    }

    public TlsCertificate createCertificate(byte[] byArray) throws IOException {
        return this.createCertificate((short)0, byArray);
    }

    public TlsCertificate createCertificate(short s, byte[] byArray) throws IOException {
        if (s != 0) {
            throw new TlsFatalAlert(43);
        }
        return new JcaTlsCertificate(this, byArray);
    }

    public TlsCipher createCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        try {
            switch (n) {
                case 7: {
                    return this.createCipher_CBC(tlsCryptoParameters, "DESede", 24, n2);
                }
                case 8: {
                    return this.createCipher_CBC(tlsCryptoParameters, "AES", 16, n2);
                }
                case 15: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 16);
                }
                case 16: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 8);
                }
                case 10: {
                    return this.createCipher_AES_GCM(tlsCryptoParameters, 16, 16);
                }
                case 9: {
                    return this.createCipher_CBC(tlsCryptoParameters, "AES", 32, n2);
                }
                case 17: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 16);
                }
                case 18: {
                    return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 8);
                }
                case 11: {
                    return this.createCipher_AES_GCM(tlsCryptoParameters, 32, 16);
                }
                case 22: {
                    return this.createCipher_CBC(tlsCryptoParameters, "ARIA", 16, n2);
                }
                case 24: {
                    return this.createCipher_ARIA_GCM(tlsCryptoParameters, 16, 16);
                }
                case 23: {
                    return this.createCipher_CBC(tlsCryptoParameters, "ARIA", 32, n2);
                }
                case 25: {
                    return this.createCipher_ARIA_GCM(tlsCryptoParameters, 32, 16);
                }
                case 12: {
                    return this.createCipher_CBC(tlsCryptoParameters, "Camellia", 16, n2);
                }
                case 19: {
                    return this.createCipher_Camellia_GCM(tlsCryptoParameters, 16, 16);
                }
                case 13: {
                    return this.createCipher_CBC(tlsCryptoParameters, "Camellia", 32, n2);
                }
                case 20: {
                    return this.createCipher_Camellia_GCM(tlsCryptoParameters, 32, 16);
                }
                case 21: {
                    return this.createChaCha20Poly1305(tlsCryptoParameters);
                }
                case 0: {
                    return this.createNullCipher(tlsCryptoParameters, n2);
                }
                case 32: {
                    return this.create13NullCipher(tlsCryptoParameters, 3);
                }
                case 33: {
                    return this.create13NullCipher(tlsCryptoParameters, 4);
                }
                case 14: {
                    return this.createCipher_CBC(tlsCryptoParameters, "SEED", 16, n2);
                }
                case 28: {
                    return this.createCipher_CBC(tlsCryptoParameters, "SM4", 16, n2);
                }
                case 26: {
                    return this.createCipher_SM4_CCM(tlsCryptoParameters);
                }
                case 27: {
                    return this.createCipher_SM4_GCM(tlsCryptoParameters);
                }
            }
            throw new TlsFatalAlert(80);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public TlsHMAC createHMAC(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.createHMACForHash(TlsCryptoUtils.getHashForHMAC(n));
            }
        }
        throw new IllegalArgumentException("invalid MACAlgorithm: " + n);
    }

    public TlsHMAC createHMACForHash(int n) {
        String string = this.getHMACAlgorithmName(n);
        try {
            return new JceTlsHMAC(n, this.helper.createMac(string), string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("cannot create HMAC: " + string, generalSecurityException);
        }
    }

    protected TlsHMAC createHMAC_SSL(int n) throws GeneralSecurityException, IOException {
        switch (n) {
            case 1: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(1)), 16, 64);
            }
            case 2: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(2)), 20, 64);
            }
            case 3: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(4)), 32, 64);
            }
            case 4: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(5)), 48, 128);
            }
            case 5: {
                return new JcaSSL3HMAC(this.createHash(this.getDigestName(6)), 64, 128);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsHMAC createMAC(TlsCryptoParameters tlsCryptoParameters, int n) throws GeneralSecurityException, IOException {
        if (TlsImplUtils.isSSL(tlsCryptoParameters)) {
            return this.createHMAC_SSL(n);
        }
        return this.createHMAC(n);
    }

    public TlsSRP6Client createSRP6Client(TlsSRPConfig tlsSRPConfig) {
        final SRP6Client sRP6Client = new SRP6Client();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6Group sRP6Group = new SRP6Group(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Client.init(sRP6Group, this.createHash(2), this.getSecureRandom());
        return new TlsSRP6Client(){

            public BigInteger calculateSecret(BigInteger bigInteger) throws TlsFatalAlert {
                try {
                    return sRP6Client.calculateSecret(bigInteger);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TlsFatalAlert(47, (Throwable)illegalArgumentException);
                }
            }

            public BigInteger generateClientCredentials(byte[] byArray, byte[] byArray2, byte[] byArray3) {
                return sRP6Client.generateClientCredentials(byArray, byArray2, byArray3);
            }
        };
    }

    public TlsSRP6Server createSRP6Server(TlsSRPConfig tlsSRPConfig, BigInteger bigInteger) {
        final SRP6Server sRP6Server = new SRP6Server();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6Group sRP6Group = new SRP6Group(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Server.init(sRP6Group, bigInteger, this.createHash(2), this.getSecureRandom());
        return new TlsSRP6Server(){

            public BigInteger generateServerCredentials() {
                return sRP6Server.generateServerCredentials();
            }

            public BigInteger calculateSecret(BigInteger bigInteger) throws IOException {
                try {
                    return sRP6Server.calculateSecret(bigInteger);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new TlsFatalAlert(47, (Throwable)illegalArgumentException);
                }
            }
        };
    }

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig tlsSRPConfig) {
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        final SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigIntegerArray[0], bigIntegerArray[1], this.createHash(2));
        return new TlsSRP6VerifierGenerator(){

            public BigInteger generateVerifier(byte[] byArray, byte[] byArray2, byte[] byArray3) {
                return sRP6VerifierGenerator.generateVerifier(byArray, byArray2, byArray3);
            }
        };
    }

    String getHMACAlgorithmName(int n) {
        switch (n) {
            case 1: {
                return "HmacMD5";
            }
            case 2: {
                return "HmacSHA1";
            }
            case 3: {
                return "HmacSHA224";
            }
            case 4: {
                return "HmacSHA256";
            }
            case 5: {
                return "HmacSHA384";
            }
            case 6: {
                return "HmacSHA512";
            }
            case 7: {
                return "HmacSM3";
            }
            case 8: {
                return "HmacGOST3411-2012-256";
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + n);
    }

    public AlgorithmParameters getNamedGroupAlgorithmParameters(int n) throws GeneralSecurityException {
        if (NamedGroup.refersToAnXDHCurve(n)) {
            return null;
        }
        if (NamedGroup.refersToAnECDSACurve(n)) {
            return ECUtil.getAlgorithmParameters(this, NamedGroup.getCurveName(n));
        }
        if (NamedGroup.refersToASpecificFiniteField(n)) {
            return DHUtil.getAlgorithmParameters(this, TlsDHUtils.getNamedDHGroup(n));
        }
        if (NamedGroup.refersToASpecificKem(n)) {
            return null;
        }
        throw new IllegalArgumentException("NamedGroup not supported: " + NamedGroup.getText(n));
    }

    public AlgorithmParameters getSignatureSchemeAlgorithmParameters(int n) throws GeneralSecurityException {
        if (!SignatureScheme.isRSAPSS(n)) {
            return null;
        }
        int n2 = SignatureScheme.getCryptoHashAlgorithm(n);
        if (n2 < 0) {
            return null;
        }
        String string = this.getDigestName(n2);
        String string2 = RSAUtil.getDigestSigAlgName(string) + "WITHRSAANDMGF1";
        AlgorithmParameterSpec algorithmParameterSpec = RSAUtil.getPSSParameterSpec(n2, string, this.getHelper());
        Signature signature = this.getHelper().createSignature(string2);
        signature.setParameter(algorithmParameterSpec);
        return signature.getParameters();
    }

    public boolean hasAnyStreamVerifiers(Vector vector) {
        boolean bl = JcaUtils.isSunMSCAPIProviderActive();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i);
            switch (signatureAndHashAlgorithm.getSignature()) {
                case 1: {
                    if (!bl) break;
                    return true;
                }
                case 2: {
                    if (HashAlgorithm.getOutputSize(signatureAndHashAlgorithm.getHash()) == 20) break;
                    return true;
                }
            }
            switch (SignatureScheme.from(signatureAndHashAlgorithm)) {
                case 2052: 
                case 2053: 
                case 2054: 
                case 2055: 
                case 2056: 
                case 2057: 
                case 2058: 
                case 2059: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasAnyStreamVerifiersLegacy(short[] sArray) {
        return false;
    }

    public boolean hasCryptoHashAlgorithm(int n) {
        return true;
    }

    public boolean hasCryptoSignatureAlgorithm(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean hasDHAgreement() {
        return true;
    }

    public boolean hasECDHAgreement() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEncryptionAlgorithm(int n) {
        Serializable serializable;
        Integer n2 = Integers.valueOf((int)n);
        Serializable serializable2 = this.supportedEncryptionAlgorithms;
        synchronized (serializable2) {
            serializable = (Boolean)this.supportedEncryptionAlgorithms.get(n2);
            if (serializable != null) {
                return serializable;
            }
        }
        serializable2 = this.isSupportedEncryptionAlgorithm(n);
        if (null == serializable2) {
            return false;
        }
        serializable = this.supportedEncryptionAlgorithms;
        synchronized (serializable) {
            Boolean bl = (Boolean)((Object)this.supportedEncryptionAlgorithms.put(n2, serializable2));
            if (null != bl && serializable2 != bl) {
                this.supportedEncryptionAlgorithms.put(n2, bl);
                serializable2 = bl;
            }
        }
        return (Boolean)serializable2;
    }

    public boolean hasHKDFAlgorithm(int n) {
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean hasKemAgreement() {
        return true;
    }

    public boolean hasMacAlgorithm(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNamedGroup(int n) {
        Serializable serializable;
        Integer n2 = Integers.valueOf((int)n);
        Serializable serializable2 = this.supportedNamedGroups;
        synchronized (serializable2) {
            serializable = (Boolean)this.supportedNamedGroups.get(n2);
            if (null != serializable) {
                return serializable;
            }
        }
        serializable2 = this.isSupportedNamedGroup(n);
        if (null == serializable2) {
            return false;
        }
        serializable = this.supportedNamedGroups;
        synchronized (serializable) {
            Boolean bl = (Boolean)((Object)this.supportedNamedGroups.put(n2, serializable2));
            if (null != bl && serializable2 != bl) {
                this.supportedNamedGroups.put(n2, bl);
                serializable2 = bl;
            }
        }
        return (Boolean)serializable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRSAEncryption() {
        Serializable serializable;
        Serializable serializable2 = this.supportedOther;
        synchronized (serializable2) {
            serializable = (Boolean)this.supportedOther.get("KE_RSA");
            if (serializable != null) {
                return serializable;
            }
        }
        try {
            this.createRSAEncryptionCipher();
            serializable2 = Boolean.TRUE;
        }
        catch (GeneralSecurityException generalSecurityException) {
            serializable2 = Boolean.FALSE;
        }
        serializable = this.supportedOther;
        synchronized (serializable) {
            Boolean bl = (Boolean)((Object)this.supportedOther.put("KE_RSA", serializable2));
            if (null != bl && serializable2 != bl) {
                this.supportedOther.put("KE_RSA", bl);
                serializable2 = bl;
            }
        }
        return (Boolean)serializable2;
    }

    public boolean hasSignatureAlgorithm(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        int n = SignatureScheme.from(signatureAndHashAlgorithm);
        if (SignatureScheme.isMLDSA(n) || SignatureScheme.isSLHDSA(n)) {
            return this.hasSignatureScheme(n);
        }
        short s = signatureAndHashAlgorithm.getSignature();
        switch (signatureAndHashAlgorithm.getHash()) {
            case 1: {
                return 1 == s && this.hasSignatureAlgorithm(s);
            }
            case 3: {
                return !JcaUtils.isSunMSCAPIProviderActive() && this.hasSignatureAlgorithm(s);
            }
        }
        return this.hasSignatureAlgorithm(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSignatureScheme(int n) {
        Serializable serializable;
        Integer n2 = Integers.valueOf((int)n);
        Serializable serializable2 = this.supportedSignatureSchemes;
        synchronized (serializable2) {
            serializable = (Boolean)this.supportedSignatureSchemes.get(n2);
            if (serializable != null) {
                return serializable;
            }
        }
        serializable2 = this.isSupportedSignatureScheme(n);
        if (null == serializable2) {
            return false;
        }
        serializable = this.supportedSignatureSchemes;
        synchronized (serializable) {
            Boolean bl = (Boolean)((Object)this.supportedSignatureSchemes.put(n2, serializable2));
            if (null != bl && serializable2 != bl) {
                this.supportedSignatureSchemes.put(n2, bl);
                serializable2 = bl;
            }
        }
        return (Boolean)serializable2;
    }

    public boolean hasSRPAuthentication() {
        return true;
    }

    public TlsSecret createHybridSecret(TlsSecret tlsSecret, TlsSecret tlsSecret2) {
        return this.adoptLocalSecret(Arrays.concatenate((byte[])tlsSecret.extract(), (byte[])tlsSecret2.extract()));
    }

    public TlsSecret createSecret(byte[] byArray) {
        return this.adoptLocalSecret(Arrays.clone((byte[])byArray));
    }

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion protocolVersion) {
        byte[] byArray = new byte[48];
        this.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(protocolVersion, byArray, 0);
        return this.adoptLocalSecret(byArray);
    }

    public TlsHash createHash(int n) {
        try {
            return this.createHash(this.getDigestName(n));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalArgumentException("unable to create message digest:" + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public TlsDHDomain createDHDomain(TlsDHConfig tlsDHConfig) {
        return new JceTlsDHDomain(this, tlsDHConfig);
    }

    public TlsECDomain createECDomain(TlsECConfig tlsECConfig) {
        switch (tlsECConfig.getNamedGroup()) {
            case 29: {
                return new JceX25519Domain(this);
            }
            case 30: {
                return new JceX448Domain(this);
            }
        }
        return new JceTlsECDomain(this, tlsECConfig);
    }

    public TlsKemDomain createKemDomain(TlsKemConfig tlsKemConfig) {
        return new JceTlsMLKemDomain(this, tlsKemConfig);
    }

    public TlsSecret hkdfInit(int n) {
        return this.adoptLocalSecret(new byte[TlsCryptoUtils.getHashOutputSize(n)]);
    }

    protected TlsAEADCipherImpl createAEADCipher(String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        return new JceAEADCipherImpl(this, this.helper, string, string2, n, bl);
    }

    protected TlsBlockCipherImpl createBlockCipher(String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        return new JceBlockCipherImpl(this, this.helper.createCipher(string), string2, n, bl);
    }

    protected TlsBlockCipherImpl createBlockCipherWithCBCImplicitIV(String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        return new JceBlockCipherWithCBCImplicitIVImpl(this, this.helper.createCipher(string), string2, bl);
    }

    protected TlsHash createHash(String string) throws GeneralSecurityException {
        return new JcaTlsHash(this.helper.createDigest(string));
    }

    protected Tls13NullCipher create13NullCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException {
        return new Tls13NullCipher(tlsCryptoParameters, this.createHMAC(n), this.createHMAC(n));
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException, GeneralSecurityException {
        return new TlsNullCipher(tlsCryptoParameters, this.createMAC(tlsCryptoParameters, n), this.createMAC(tlsCryptoParameters, n));
    }

    protected TlsStreamSigner createStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, PrivateKey privateKey, boolean bl) throws IOException {
        String string = JcaUtils.getJcaAlgorithmName(signatureAndHashAlgorithm);
        return this.createStreamSigner(string, null, privateKey, bl);
    }

    protected TlsStreamSigner createStreamSigner(String string, AlgorithmParameterSpec algorithmParameterSpec, PrivateKey privateKey, boolean bl) throws IOException {
        SecureRandom secureRandom = bl ? this.getSecureRandom() : null;
        try {
            try {
                return this.createStreamSigner(this.getHelper(), string, algorithmParameterSpec, privateKey, secureRandom);
            }
            catch (InvalidKeyException invalidKeyException) {
                JcaJceHelper jcaJceHelper = this.getAltHelper();
                if (jcaJceHelper == null) {
                    throw invalidKeyException;
                }
                return this.createStreamSigner(jcaJceHelper, string, algorithmParameterSpec, privateKey, secureRandom);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }

    protected TlsStreamSigner createStreamSigner(JcaJceHelper jcaJceHelper, String string, AlgorithmParameterSpec algorithmParameterSpec, PrivateKey privateKey, SecureRandom secureRandom) throws GeneralSecurityException {
        try {
            Signature signature;
            if (null != algorithmParameterSpec) {
                try {
                    signature = jcaJceHelper.createSignature(string);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    String string2 = Strings.toUpperCase((String)string);
                    if (string2.endsWith("ANDMGF1")) {
                        string = string2.replace("ANDMGF1", "SSA-PSS");
                        signature = jcaJceHelper.createSignature(string);
                    }
                    throw noSuchAlgorithmException;
                }
                signature.initSign(privateKey, secureRandom);
                jcaJceHelper = new ProviderJcaJceHelper(signature.getProvider());
            }
            signature = jcaJceHelper.createSignature(string);
            if (null != algorithmParameterSpec) {
                signature.setParameter(algorithmParameterSpec);
            }
            signature.initSign(privateKey, secureRandom);
            return new JcaTlsStreamSigner(signature);
        }
        catch (InvalidKeyException invalidKeyException) {
            String string3 = Strings.toUpperCase((String)string);
            if (string3.endsWith("ANDMGF1")) {
                string = string3.replace("ANDMGF1", "SSA-PSS");
                return this.createStreamSigner(jcaJceHelper, string, algorithmParameterSpec, privateKey, secureRandom);
            }
            throw invalidKeyException;
        }
    }

    protected TlsStreamVerifier createStreamVerifier(DigitallySigned digitallySigned, PublicKey publicKey) throws IOException {
        String string = JcaUtils.getJcaAlgorithmName(digitallySigned.getAlgorithm());
        return this.createStreamVerifier(string, null, digitallySigned.getSignature(), publicKey);
    }

    protected TlsStreamVerifier createStreamVerifier(String string, AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray, PublicKey publicKey) throws IOException {
        try {
            Signature signature;
            JcaJceHelper jcaJceHelper = this.getHelper();
            if (null != algorithmParameterSpec) {
                signature = jcaJceHelper.createSignature(string);
                signature.initVerify(publicKey);
                jcaJceHelper = new ProviderJcaJceHelper(signature.getProvider());
            }
            signature = jcaJceHelper.createSignature(string);
            if (null != algorithmParameterSpec) {
                signature.setParameter(algorithmParameterSpec);
            }
            signature.initVerify(publicKey);
            return new JcaTlsStreamVerifier(signature, byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }

    protected Tls13Verifier createTls13Verifier(String string, AlgorithmParameterSpec algorithmParameterSpec, PublicKey publicKey) throws IOException {
        try {
            Signature signature;
            JcaJceHelper jcaJceHelper = this.getHelper();
            if (null != algorithmParameterSpec) {
                signature = jcaJceHelper.createSignature(string);
                signature.initVerify(publicKey);
                jcaJceHelper = new ProviderJcaJceHelper(signature.getProvider());
            }
            signature = jcaJceHelper.createSignature(string);
            if (null != algorithmParameterSpec) {
                signature.setParameter(algorithmParameterSpec);
            }
            signature.initVerify(publicKey);
            return new JcaTls13Verifier(signature);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }

    protected Boolean isSupportedEncryptionAlgorithm(int n) {
        switch (n) {
            case 7: {
                return this.isUsableCipher("DESede/CBC/NoPadding", 192);
            }
            case 8: {
                return this.isUsableCipher("AES/CBC/NoPadding", 128);
            }
            case 15: 
            case 16: {
                return this.isUsableCipher("AES/CCM/NoPadding", 128);
            }
            case 10: {
                return this.isUsableCipher("AES/GCM/NoPadding", 128);
            }
            case 9: {
                return this.isUsableCipher("AES/CBC/NoPadding", 256);
            }
            case 17: 
            case 18: {
                return this.isUsableCipher("AES/CCM/NoPadding", 256);
            }
            case 11: {
                return this.isUsableCipher("AES/GCM/NoPadding", 256);
            }
            case 22: {
                return this.isUsableCipher("ARIA/CBC/NoPadding", 128);
            }
            case 24: {
                return this.isUsableCipher("ARIA/GCM/NoPadding", 128);
            }
            case 23: {
                return this.isUsableCipher("ARIA/CBC/NoPadding", 256);
            }
            case 25: {
                return this.isUsableCipher("ARIA/GCM/NoPadding", 256);
            }
            case 12: {
                return this.isUsableCipher("Camellia/CBC/NoPadding", 128);
            }
            case 19: {
                return this.isUsableCipher("Camellia/GCM/NoPadding", 128);
            }
            case 13: {
                return this.isUsableCipher("Camellia/CBC/NoPadding", 256);
            }
            case 20: {
                return this.isUsableCipher("Camellia/GCM/NoPadding", 256);
            }
            case 21: {
                return this.isUsableCipher("ChaCha7539", 256) && this.isUsableMAC("Poly1305");
            }
            case 0: {
                return Boolean.TRUE;
            }
            case 14: {
                return this.isUsableCipher("SEED/CBC/NoPadding", 128);
            }
            case 28: {
                return this.isUsableCipher("SM4/CBC/NoPadding", 128);
            }
            case 26: {
                return this.isUsableCipher("SM4/CCM/NoPadding", 128);
            }
            case 27: {
                return this.isUsableCipher("SM4/GCM/NoPadding", 128);
            }
            case 32: {
                return this.hasMacAlgorithm(3);
            }
            case 33: {
                return this.hasMacAlgorithm(4);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 29: 
            case 30: 
            case 31: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Boolean isSupportedNamedGroup(int n) {
        try {
            if (NamedGroup.refersToAnXDHCurve(n)) {
                switch (n) {
                    case 29: {
                        this.helper.createKeyAgreement("X25519");
                        return Boolean.TRUE;
                    }
                    case 30: {
                        this.helper.createKeyAgreement("X448");
                        return Boolean.TRUE;
                    }
                }
            } else {
                if (NamedGroup.refersToASpecificKem(n)) {
                    return KemUtil.isKemSupported(this, NamedGroup.getKemName(n));
                }
                if (NamedGroup.refersToAnECDSACurve(n)) {
                    return ECUtil.isCurveSupported(this, NamedGroup.getCurveName(n));
                }
                if (NamedGroup.refersToASpecificFiniteField(n)) {
                    return DHUtil.isGroupSupported(this, TlsDHUtils.getNamedDHGroup(n));
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected Boolean isSupportedSignatureScheme(int n) {
        try {
            if (SignatureScheme.isMLDSA(n)) {
                this.helper.createSignature("ML-DSA");
                return Boolean.TRUE;
            }
            if (SignatureScheme.isSLHDSA(n)) {
                this.helper.createSignature("SLH-DSA");
                return Boolean.TRUE;
            }
            switch (n) {
                case 1800: {
                    return Boolean.FALSE;
                }
            }
            short s = SignatureScheme.getSignatureAlgorithm(n);
            switch (SignatureScheme.getCryptoHashAlgorithm(n)) {
                case 1: {
                    return 1 == s && this.hasSignatureAlgorithm(s);
                }
                case 3: {
                    return !JcaUtils.isSunMSCAPIProviderActive() && this.hasSignatureAlgorithm(s);
                }
            }
            return this.hasSignatureAlgorithm(s);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return Boolean.FALSE;
        }
    }

    protected boolean isUsableCipher(String string, int n) {
        try {
            this.helper.createCipher(string);
            return Cipher.getMaxAllowedKeyLength(string) >= n;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    protected boolean isUsableMAC(String string) {
        try {
            this.helper.createMac(string);
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    public JcaJceHelper getHelper() {
        return this.helper;
    }

    public JcaJceHelper getAltHelper() {
        return this.altHelper;
    }

    protected TlsBlockCipherImpl createCBCBlockCipherImpl(TlsCryptoParameters tlsCryptoParameters, String string, int n, boolean bl) throws GeneralSecurityException {
        String string2 = string + "/CBC/NoPadding";
        if (TlsImplUtils.isTLSv11(tlsCryptoParameters)) {
            return this.createBlockCipher(string2, string, n, bl);
        }
        return this.createBlockCipherWithCBCImplicitIV(string2, string, n, bl);
    }

    private TlsCipher createChaCha20Poly1305(TlsCryptoParameters tlsCryptoParameters) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, new JceChaCha20Poly1305(this, this.helper, true), new JceChaCha20Poly1305(this, this.helper, false), 32, 16, 2, null);
    }

    private TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("AES/CCM/NoPadding", "AES", n, true), this.createAEADCipher("AES/CCM/NoPadding", "AES", n, false), n, n2, 1, null);
    }

    private TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("AES/GCM/NoPadding", "AES", n, true), this.createAEADCipher("AES/GCM/NoPadding", "AES", n, false), n, n2, 3, this.getFipsGCMNonceGeneratorFactory());
    }

    private TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", n, true), this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", n, false), n, n2, 3, this.getFipsGCMNonceGeneratorFactory());
    }

    private TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", n, true), this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", n, false), n, n2, 3, this.getFipsGCMNonceGeneratorFactory());
    }

    protected TlsCipher createCipher_CBC(TlsCryptoParameters tlsCryptoParameters, String string, int n, int n2) throws GeneralSecurityException, IOException {
        TlsBlockCipherImpl tlsBlockCipherImpl = this.createCBCBlockCipherImpl(tlsCryptoParameters, string, n, true);
        TlsBlockCipherImpl tlsBlockCipherImpl2 = this.createCBCBlockCipherImpl(tlsCryptoParameters, string, n, false);
        TlsHMAC tlsHMAC = this.createMAC(tlsCryptoParameters, n2);
        TlsHMAC tlsHMAC2 = this.createMAC(tlsCryptoParameters, n2);
        return new TlsBlockCipher(tlsCryptoParameters, tlsBlockCipherImpl, tlsBlockCipherImpl2, tlsHMAC, tlsHMAC2, n);
    }

    private TlsAEADCipher createCipher_SM4_CCM(TlsCryptoParameters tlsCryptoParameters) throws IOException, GeneralSecurityException {
        int n = 16;
        int n2 = 16;
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("SM4/CCM/NoPadding", "SM4", n, true), this.createAEADCipher("SM4/CCM/NoPadding", "SM4", n, false), n, n2, 1, null);
    }

    private TlsAEADCipher createCipher_SM4_GCM(TlsCryptoParameters tlsCryptoParameters) throws IOException, GeneralSecurityException {
        int n = 16;
        int n2 = 16;
        return new TlsAEADCipher(tlsCryptoParameters, this.createAEADCipher("SM4/GCM/NoPadding", "SM4", n, true), this.createAEADCipher("SM4/GCM/NoPadding", "SM4", n, false), n, n2, 3, this.getFipsGCMNonceGeneratorFactory());
    }

    public AEADNonceGeneratorFactory getFipsGCMNonceGeneratorFactory() {
        return GCMFipsUtil.getDefaultFipsGCMNonceGeneratorFactory();
    }

    String getDigestName(int n) {
        switch (n) {
            case 1: {
                return "MD5";
            }
            case 2: {
                return "SHA-1";
            }
            case 3: {
                return "SHA-224";
            }
            case 4: {
                return "SHA-256";
            }
            case 5: {
                return "SHA-384";
            }
            case 6: {
                return "SHA-512";
            }
            case 7: {
                return "SM3";
            }
            case 8: {
                return "GOST3411-2012-256";
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + n);
    }
}

