/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.container;

import java.awt.Dialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcollector.LinkOriginDetails;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.plugins.ContainerStatus;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginsC;
import org.appwork.uio.ComboBoxDialogInterface;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.dialog.ComboBoxDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class JD2Import
extends PluginsC {
    public JD2Import() {
        super("JD2 Import", "file:/.+((downloadList|linkcollector)(\\d+)?(\\.zip|\\.zip\\.backup))$", "$Revision: 49093 $");
    }

    public JD2Import newPluginInstance() {
        return new JD2Import();
    }

    public ArrayList<CrawledLink> decryptContainer(CrawledLink source) {
        LinkOriginDetails origin = source.getOrigin();
        if (origin != null && LinkOrigin.CLIPBOARD.equals((Object)origin.getOrigin())) {
            return null;
        }
        return super.decryptContainer(source);
    }

    protected boolean showConfimDialog() {
        CrawledLink link = this.getCurrentLink();
        if (link != null) {
            LinkOriginDetails origin = link.getOrigin();
            return origin == null || !LinkOrigin.EXTENSION.equals((Object)origin.getOrigin());
        }
        return true;
    }

    public ContainerStatus callDecryption(File importFile) {
        ContainerStatus cs = new ContainerStatus(importFile);
        this.cls = new ArrayList();
        try {
            if (importFile.getName().matches("downloadList(\\d+)?\\.zip(\\.backup)?")) {
                final LinkedList filePackages = DownloadController.getInstance().loadFile(importFile, true);
                int linksCounter = 0;
                for (FilePackage filePackage : filePackages) {
                    filePackage.getUniqueID().refresh();
                    for (DownloadLink downloadLink : filePackage.getChildren()) {
                        downloadLink.getUniqueID().refresh();
                    }
                    linksCounter += filePackage.size();
                }
                boolean importToDownloadList = true;
                if (this.showConfimDialog()) {
                    ComboBoxDialog d = new ComboBoxDialog(4, _GUI.T.jd2_import_title(), _GUI.T.jd2_import_message(filePackages.size(), linksCounter, ""), new String[]{_GUI.T.jd_gui_swing_jdgui_views_downloadview_tab_title(), _GUI.T.jd_gui_swing_jdgui_views_linkgrabberview_tab_title()}, 0, (Icon)new AbstractIcon("question", 16), null, null, null){

                        public Dialog.ModalityType getModalityType() {
                            return Dialog.ModalityType.MODELESS;
                        }
                    };
                    ComboBoxDialogInterface cd = (ComboBoxDialogInterface)UIOManager.I().show(ComboBoxDialogInterface.class, (UserIODefinition)d);
                    cd.throwCloseExceptions();
                    switch (cd.getSelectedIndex()) {
                        case 0: {
                            importToDownloadList = true;
                            break;
                        }
                        case 1: {
                            importToDownloadList = false;
                            break;
                        }
                        default: {
                            throw new Exception("Unexpected selectionIndex:" + cd.getSelectedIndex());
                        }
                    }
                }
                if (importToDownloadList) {
                    DownloadController.getInstance().getQueue().add((QueueAction)new QueueAction<Void, Throwable>(){

                        protected Void run() throws Throwable {
                            DownloadController.getInstance().importList(filePackages);
                            return null;
                        }
                    });
                } else {
                    final LinkedList<CrawledPackage> crawledPackages = new LinkedList<CrawledPackage>();
                    for (FilePackage filePackage : filePackages) {
                        CrawledPackage crawledPackage = new CrawledPackage();
                        crawledPackage.setDownloadFolder(filePackage.getDownloadDirectory());
                        crawledPackage.setName(filePackage.getName());
                        crawledPackage.setComment(filePackage.getComment());
                        crawledPackage.setEnabled(filePackage.isEnabled());
                        crawledPackage.setExpanded(filePackage.isExpanded());
                        for (DownloadLink downloadLink : filePackage.getChildren()) {
                            DownloadLink.AvailableStatus status = downloadLink.getAvailableStatus();
                            downloadLink.reset(null);
                            downloadLink.setAvailableStatus(status);
                            CrawledLink crawledLink = new CrawledLink(downloadLink);
                            crawledLink.setEnabled(downloadLink.isEnabled());
                            crawledPackage.getChildren().add(crawledLink);
                            crawledLink.setParentNode(crawledPackage);
                        }
                        crawledPackages.add(crawledPackage);
                    }
                    LinkCollector.getInstance().getQueue().addWait((QueueAction)new QueueAction<Void, Throwable>(){

                        protected Void run() throws Throwable {
                            LinkCollector.getInstance().importList(crawledPackages, null);
                            return null;
                        }
                    });
                }
                cs.setStatus(2);
                return cs;
            }
            if (importFile.getName().matches("linkcollector(\\d+)?\\.zip(\\.backup)?")) {
                final HashMap restoreMap = new HashMap();
                final LinkedList packages = LinkCollector.getInstance().loadFile(importFile, restoreMap, true);
                int links = 0;
                for (CrawledPackage p : packages) {
                    p.getUniqueID().refresh();
                    for (CrawledLink downloadLink : p.getChildren()) {
                        downloadLink.getUniqueID().refresh();
                    }
                    links += p.getChildren().size();
                }
                if (this.showConfimDialog()) {
                    ConfirmDialog d = new ConfirmDialog(4, _GUI.T.jd2_import_title(), _GUI.T.jd2_import_message(packages.size(), links, _GUI.T.jd_gui_swing_jdgui_views_linkgrabberview_tab_title()), (Icon)new AbstractIcon("question", 16), null, null){

                        public Dialog.ModalityType getModalityType() {
                            return Dialog.ModalityType.MODELESS;
                        }
                    };
                    ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
                }
                LinkCollector.getInstance().getQueue().addWait((QueueAction)new QueueAction<Void, Throwable>(){

                    protected Void run() throws Throwable {
                        LinkCollector.getInstance().importList(packages, (Map)restoreMap);
                        return null;
                    }
                });
                cs.setStatus(2);
                return cs;
            }
            cs.setStatus(4);
            return cs;
        }
        catch (DialogNoAnswerException e) {
            cs.setStatus(8);
            return cs;
        }
        catch (Throwable e) {
            this.logger.log(e);
            cs.setStatus(4);
            return cs;
        }
    }

    public String[] encrypt(String plain) {
        return null;
    }
}

