/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.container.sft;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.container.sft.sftContainer;

public class FileInfoDialog
extends AbstractDialog<String>
implements ActionListener,
DocumentListener {
    protected final JButton dynamicOkButton = new JButton(_AWU.T.ABSTRACTDIALOG_BUTTON_OK());
    protected final JPasswordField passwordField = new JPasswordField();
    protected final JTextPane textPane = new JTextPane();
    protected final boolean needPassword;
    protected final sftContainer container;
    protected boolean lastCryptState;

    public FileInfoDialog(sftContainer container) {
        super(8, "Downloaddetails", null, null, null);
        this.needPassword = container.needPassword();
        this.lastCryptState = !container.isDecrypted();
        this.container = container;
    }

    protected void setInfo() {
        if (this.lastCryptState != this.container.isDecrypted()) {
            String Comment2;
            String unknown = "??";
            String na = "N/A";
            String Description = this.container.isDecrypted() ? this.container.getDescription() : unknown;
            String Uploader = this.container.isDecrypted() ? this.container.getUploader() : unknown;
            String string = Comment2 = this.container.isDecrypted() ? this.container.getComment() : unknown;
            if (Description == null) {
                Description = na;
            }
            if (Uploader == null) {
                Uploader = na;
            }
            if (Comment2 == null) {
                Comment2 = na;
            }
            StringBuilder info_builder = new StringBuilder();
            info_builder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td width=\"1%\"><strong>");
            info_builder.append("Beschreibung:");
            info_builder.append("  </strong></td><td>");
            info_builder.append(Description);
            info_builder.append("</tr><tr><td><strong>");
            info_builder.append("Upper:");
            info_builder.append("  </strong></td><td>");
            info_builder.append(Uploader);
            info_builder.append("</td></tr><tr><td><strong>");
            info_builder.append("Kommentar:");
            info_builder.append("  </strong></td><td>");
            info_builder.append(Comment2);
            info_builder.append("</td></tr></table>");
            this.textPane.setText(info_builder.toString());
            this.lastCryptState = this.container.isDecrypted();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        boolean passwordOk = this.container.setPassword(this.passwordField.getPassword());
        this.dynamicOkButton.setEnabled(passwordOk);
        this.setInfo();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dynamicOkButton) {
            LoggerFactory.getDefaultLogger().fine("Answer: Button<OK:" + this.dynamicOkButton.getText() + ">");
            this.setReturnmask(true);
        } else if (e.getActionCommand().equals("enterPushed")) {
            if (this.container.isDecrypted()) {
                LoggerFactory.getDefaultLogger().fine("Answer: Button<OK:" + this.okButton.getText() + ">");
                this.setReturnmask(true);
            } else {
                return;
            }
        }
        super.actionPerformed(e);
    }

    protected String createReturnValue() {
        return null;
    }

    protected void addButtons(JPanel buttonBar) {
        this.dynamicOkButton.addActionListener(this);
        this.dynamicOkButton.setEnabled(!this.needPassword);
        this.dynamicOkButton.addActionListener(this);
        this.dynamicOkButton.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                JButton defaultButton;
                JRootPane root;
                if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(defaultButton = (JButton)e.getComponent())) != null) {
                    root.setDefaultButton(defaultButton);
                }
            }
        });
        this.dynamicOkButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JRootPane root = SwingUtilities.getRootPane(e.getComponent());
                if (root != null && e.getComponent() instanceof JButton) {
                    root.setDefaultButton((JButton)e.getComponent());
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                JRootPane root = SwingUtilities.getRootPane(e.getComponent());
                if (root != null) {
                    root.setDefaultButton(null);
                }
            }
        });
        buttonBar.add((Component)this.dynamicOkButton, "alignx right,tag ok,sizegroup confirms");
    }

    public JComponent layoutDialogContent() {
        JPanel centerPanel = new JPanel();
        JSeparator separator = new JSeparator();
        JLabel labelPassword = new JLabel("Passwort:");
        String Layout = new String("[][][]");
        if (!this.needPassword) {
            this.passwordField.setVisible(false);
            labelPassword.setVisible(false);
            Layout = new String("[][::0px][]");
        }
        labelPassword.setLabelFor(this.passwordField);
        this.passwordField.getDocument().addDocumentListener(this);
        this.passwordField.setActionCommand("enterPushed");
        this.passwordField.addActionListener(this);
        Font font = this.textPane.getFont();
        this.textPane.setContentType("text/html");
        this.textPane.setFont(font);
        this.textPane.setEditable(false);
        this.textPane.setBackground(null);
        this.textPane.setOpaque(false);
        this.textPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.textPane.setCaretPosition(0);
        this.textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    CrossSystem.openURL((URL)e.getURL());
                }
            }
        });
        centerPanel.setLayout((LayoutManager)new MigLayout("", "[320px:n]", Layout));
        centerPanel.add((Component)separator, "cell 0 2,grow");
        centerPanel.add((Component)labelPassword, "flowx,cell 0 1,alignx left,aligny center");
        centerPanel.add((Component)this.textPane, "cell 0 0,growx,aligny top");
        centerPanel.add((Component)this.passwordField, "cell 0 1,growx,aligny top");
        this.setInfo();
        return centerPanel;
    }
}

