/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.contentdirectory.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.fourthline.cling.model.action.ActionException;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.types.ErrorCode;
import org.fourthline.cling.support.contentdirectory.callback.Browse;
import org.fourthline.cling.support.model.BrowseFlag;
import org.fourthline.cling.support.model.DIDLContent;
import org.fourthline.cling.support.model.SortCriterion;
import org.fourthline.cling.support.model.container.Container;
import org.fourthline.cling.support.model.item.Item;

public abstract class ContentBrowseActionCallback
extends Browse {
    private static Logger log = Logger.getLogger(ContentBrowseActionCallback.class.getName());
    protected final DefaultTreeModel treeModel;
    protected final DefaultMutableTreeNode treeNode;

    public ContentBrowseActionCallback(Service service, DefaultTreeModel treeModel, DefaultMutableTreeNode treeNode) {
        super(service, ((Container)treeNode.getUserObject()).getId(), BrowseFlag.DIRECT_CHILDREN, "*", 0L, null, new SortCriterion(true, "dc:title"));
        this.treeModel = treeModel;
        this.treeNode = treeNode;
    }

    public ContentBrowseActionCallback(Service service, DefaultTreeModel treeModel, DefaultMutableTreeNode treeNode, String filter, long firstResult, long maxResults, SortCriterion ... orderBy) {
        super(service, ((Container)treeNode.getUserObject()).getId(), BrowseFlag.DIRECT_CHILDREN, filter, firstResult, maxResults, orderBy);
        this.treeModel = treeModel;
        this.treeNode = treeNode;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    @Override
    public void received(ActionInvocation actionInvocation, DIDLContent didl) {
        log.fine("Received browse action DIDL descriptor, creating tree nodes");
        final ArrayList<1> childNodes = new ArrayList<1>();
        try {
            DefaultMutableTreeNode childNode;
            for (Container childContainer : didl.getContainers()) {
                childNode = new DefaultMutableTreeNode(childContainer){

                    @Override
                    public boolean isLeaf() {
                        return false;
                    }
                };
                childNodes.add(childNode);
            }
            for (Item childItem : didl.getItems()) {
                childNode = new DefaultMutableTreeNode(childItem){

                    @Override
                    public boolean isLeaf() {
                        return true;
                    }
                };
                childNodes.add(childNode);
            }
        }
        catch (Exception ex) {
            log.fine("Creating DIDL tree nodes failed: " + ex);
            actionInvocation.setFailure(new ActionException(ErrorCode.ACTION_FAILED, "Can't create tree child nodes: " + ex, (Throwable)ex));
            this.failure(actionInvocation, null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentBrowseActionCallback.this.updateTreeModel(childNodes);
            }
        });
    }

    @Override
    public void updateStatus(final Browse.Status status) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentBrowseActionCallback.this.updateStatusUI(status, ContentBrowseActionCallback.this.treeNode, ContentBrowseActionCallback.this.treeModel);
            }
        });
    }

    public void failure(ActionInvocation invocation, UpnpResponse operation, final String defaultMsg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentBrowseActionCallback.this.failureUI(defaultMsg);
            }
        });
    }

    protected void updateTreeModel(List<DefaultMutableTreeNode> childNodes) {
        log.fine("Adding nodes to tree: " + childNodes.size());
        this.removeChildren();
        for (DefaultMutableTreeNode childNode : childNodes) {
            this.insertChild(childNode);
        }
    }

    protected void removeChildren() {
        this.treeNode.removeAllChildren();
        this.treeModel.nodeStructureChanged(this.treeNode);
    }

    protected void insertChild(MutableTreeNode childNode) {
        int index = this.treeNode.getChildCount() <= 0 ? 0 : this.treeNode.getChildCount();
        this.treeModel.insertNodeInto(childNode, this.treeNode, index);
    }

    public abstract void updateStatusUI(Browse.Status var1, DefaultMutableTreeNode var2, DefaultTreeModel var3);

    public abstract void failureUI(String var1);
}

