/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model;

import java.util.logging.Logger;

public enum Protocol {
    ALL("*"),
    HTTP_GET("http-get"),
    RTSP_RTP_UDP("rtsp-rtp-udp"),
    INTERNAL("internal"),
    IEC61883("iec61883"),
    XBMC_GET("xbmc-get"),
    OTHER("other");

    private static final Logger LOG;
    private String protocolString;

    private Protocol(String protocolString) {
        this.protocolString = protocolString;
    }

    public String toString() {
        return this.protocolString;
    }

    public static Protocol value(String s) {
        for (Protocol protocol : Protocol.values()) {
            if (!protocol.toString().equals(s)) continue;
            return protocol;
        }
        LOG.info("Unsupported OTHER protocol string: " + s);
        return OTHER;
    }

    static {
        LOG = Logger.getLogger(Protocol.class.getName());
    }
}

