/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.controlling;

import java.util.ArrayList;
import java.util.List;

public class State {
    public static final int INIT_STATE = -1;
    private final String label;
    private final List<State> parents;
    private final List<State> children;
    private final int id;

    public static void link(State ... stateList) {
        State prev = null;
        for (State s : stateList) {
            if (prev == null) {
                prev = s;
                continue;
            }
            prev.addChildren(s);
            prev = s;
        }
    }

    public State(int stateID, String label) {
        this.id = stateID;
        this.label = label;
        this.parents = new ArrayList<State>();
        this.children = new ArrayList<State>();
    }

    public State(String label) {
        this(-1, label);
    }

    public void addChildren(State ... states) {
        for (State s : states) {
            this.children.add(s);
        }
    }

    public List<State> getChildren() {
        return this.children;
    }

    public int getID() {
        return this.id;
    }

    public List<State> getParents() {
        return this.parents;
    }

    public String toString() {
        return this.label + "-" + this.id + "(" + this.hashCode() + ")";
    }

    public String getLabel() {
        return this.label;
    }
}

