/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.loggingv3.simple.sink;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.StandardCopyOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.appwork.loggingv3.LogV3;
import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.loggingv3.simple.sink.AbstractSink;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files;
import org.appwork.utils.IO;

public class LogToFileSink
extends AbstractSink {
    private static final String REGEX_DATE_LOGS = "^logs_(.*)_\\d+(\\.zip)?$";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss.SSS");
    private final String filepattern;
    private final File logRoot;
    protected volatile File logFolder;
    private final String timeTag;
    private volatile boolean shutdown;
    private volatile boolean enabled = true;
    private volatile FileLock logFolderLock = null;
    private File currentFile = null;
    private volatile BufferedWriter fos = null;
    private int zipLevel = 3;
    int files = 0;
    private CountingOutputStream counter;
    private final Map<FileLock, File> lockFiles = new HashMap<FileLock, File>();
    private AtomicInteger compressionThreadsRunning = new AtomicInteger(0);
    private int maxFileSize = 0x3200000;
    private final Object WORK_ON_FOLDERS_AND_FILES_LOCK = new Object();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public LogToFileSink(File root, String filepattern, int zipLevel) {
        this.logRoot = root;
        this.logRoot.mkdirs();
        this.timeTag = this.createTimeTag();
        if (!filepattern.contains("\\d")) {
            filepattern = filepattern + ".\\d";
        }
        this.filepattern = filepattern;
        this.zipLevel = zipLevel;
        Runtime.getRuntime().addShutdownHook(new Thread("ShutdownHook: Logger"){

            @Override
            public void run() {
                LogToFileSink.this.onShutdown();
            }
        });
        this.initPostCleanupAndCompressionThread();
    }

    protected void initPostCleanupAndCompressionThread() {
        new Thread("Cleanup & compress Logs:" + this.logRoot + "|" + this.filepattern){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(120000L);
                    LogToFileSink.this.runPostCleanupAndCompressionThread();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void keepOnlyLatestByBytes(long bytes) {
        ArrayList<LogFolder> logFolders = this.getLogFilesOrFolders(true);
        Collections.sort(logFolders, new Comparator<LogFolder>(){

            @Override
            public int compare(LogFolder o1, LogFolder o2) {
                return CompareUtils.compare(o2.time, o1.time);
            }
        });
        long sizeSoFar = 0L;
        for (LogFolder f : logFolders) {
            if ((sizeSoFar += f.getSize()) <= bytes) continue;
            LogV3.info("Cleanup Logs: " + f.path);
            try {
                Files.deleteRecursive(f.path, false);
            }
            catch (IOException e) {
                LogV3.defaultLogger().exception("Could not delete Logfolder: " + f.path, e);
            }
        }
    }

    public ArrayList<LogFolder> getLogFilesOrFolders(boolean excludeFoldersInUse) {
        File[] folders = this.logRoot.listFiles(this.createFileFilter());
        ArrayList<LogFolder> files = new ArrayList<LogFolder>();
        if (folders != null) {
            File currentLogFolder = this.logFolder;
            for (File f : folders) {
                Matcher matcher;
                if (excludeFoldersInUse) {
                    if (currentLogFolder != null && currentLogFolder.equals(f)) continue;
                    if (f.isDirectory()) {
                        FileLock lock = this.tryLock(f);
                        if (lock == null) continue;
                        this.releaseLock(lock);
                    }
                }
                if (!(matcher = Pattern.compile(REGEX_DATE_LOGS).matcher(f.getName())).find()) continue;
                try {
                    Date date = SIMPLE_DATE_FORMAT.parse(matcher.group(1));
                    if (date == null) continue;
                    files.add(new LogFolder(f, date.getTime()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return files;
    }

    protected FilenameFilter createFileFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = Pattern.compile(LogToFileSink.REGEX_DATE_LOGS).matcher(name);
                if (matcher.find()) {
                    Date date = null;
                    try {
                        date = SIMPLE_DATE_FORMAT.parse(matcher.group(1));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (date != null) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPostCleanupAndCompressionThread() {
        Object object = this.WORK_ON_FOLDERS_AND_FILES_LOCK;
        synchronized (object) {
            for (LogFolder f : this.getLogFilesOrFolders(true)) {
                if (f.path.isFile()) continue;
                try {
                    File tmp = null;
                    while (tmp == null || tmp.exists()) {
                        tmp = new File(f.path.getAbsoluteFile() + "." + System.currentTimeMillis());
                    }
                    if (!f.path.renameTo(tmp)) continue;
                    tmp.renameTo(f.path);
                    this.packToSingleZip(f.path);
                }
                catch (Throwable e) {
                    LogV3.logger(LogToFileSink.class).exception("Failed to compress old logfolder " + f, e);
                }
            }
        }
    }

    public File getLogRoot() {
        return this.logRoot;
    }

    public File getLogFolder() {
        return this.logFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseLock(FileLock lock) {
        boolean ret;
        block6: {
            ret = false;
            try {
                File lockFile;
                if (lock == null) break block6;
                lock.release();
                ret = true;
                lock.channel().close();
                ret = true;
                Map<FileLock, File> map = this.lockFiles;
                synchronized (map) {
                    lockFile = this.lockFiles.remove(lock);
                }
                if (lockFile != null) {
                    lockFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onShutdown() {
        LogToFileSink logToFileSink = this;
        synchronized (logToFileSink) {
            this.shutdown = true;
            this.closeOldFile();
            this.releaseLock(this.logFolderLock);
            while (this.compressionThreadsRunning.get() > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            this.runPackToSingleFileOnShutdown();
        }
    }

    protected void runPackToSingleFileOnShutdown() {
        File logFolder = this.logFolder;
        if (logFolder != null) {
            this.packToSingleZip(logFolder, new File(logFolder.getAbsolutePath() + ".zip"), true);
        }
    }

    private void packToSingleZip(File logFolder) {
        this.packToSingleZip(logFolder, new File(logFolder.getAbsolutePath() + ".zip"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packToSingleZip(File logFolder, File zip, boolean delete) {
        try {
            if (!logFolder.exists() || !logFolder.isDirectory()) {
                return;
            }
            if (zip.isFile()) {
                for (File f : logFolder.listFiles()) {
                    if (!f.getName().endsWith(".deleteMe")) continue;
                    f.delete();
                }
                if (logFolder.listFiles().length == 0) {
                    logFolder.delete();
                }
                return;
            }
            File tmp = new File(zip.getAbsolutePath() + ".tmp");
            java.nio.file.Files.deleteIfExists(tmp.toPath());
            ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(tmp));
            try {
                zipout.setLevel(this.zipLevel);
                this.writeFolderToZip(logFolder, delete, zipout, false);
                zipout.close();
                java.nio.file.Files.move(tmp.toPath(), zip.toPath(), StandardCopyOption.ATOMIC_MOVE);
                for (File f : logFolder.listFiles()) {
                    if (!f.getName().endsWith(".deleteMe")) continue;
                    f.delete();
                }
                if (logFolder.listFiles().length == 0) {
                    logFolder.delete();
                }
            }
            finally {
                zipout.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFolderToZip(File logFolder, boolean delete, ZipOutputStream zipout, boolean addSubfolder) throws FileNotFoundException, IOException, Error, InterruptedException {
        try {
            for (File f : logFolder.listFiles()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!f.isFile()) continue;
                if (f.getName().endsWith(".zip")) {
                    ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(f)));
                    try {
                        ZipEntry entry;
                        while ((entry = zis.getNextEntry()) != null) {
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (addSubfolder) {
                                zipout.putNextEntry(new ZipEntry(logFolder.getName() + "/" + entry.getName()));
                            } else {
                                zipout.putNextEntry(new ZipEntry(entry.getName()));
                            }
                            try {
                                IO.readStreamToOutputStream(-1, zis, zipout, false);
                            }
                            finally {
                                zipout.closeEntry();
                                zipout.flush();
                            }
                        }
                    }
                    finally {
                        zis.close();
                    }
                    if (!delete) continue;
                    java.nio.file.Files.move(f.toPath(), new File(f.getAbsolutePath() + ".deleteMe").toPath(), StandardCopyOption.ATOMIC_MOVE);
                    continue;
                }
                if (!f.getName().endsWith(".txt")) continue;
                if (addSubfolder) {
                    zipout.putNextEntry(new ZipEntry(logFolder.getName() + "/" + f.getName()));
                } else {
                    zipout.putNextEntry(new ZipEntry(f.getName()));
                }
                try {
                    IO.readStreamToOutputStream(-1, new BufferedInputStream(new FileInputStream(f)), zipout, true);
                }
                finally {
                    zipout.closeEntry();
                    zipout.flush();
                }
                if (!delete) continue;
                java.nio.file.Files.move(f.toPath(), new File(f.getAbsolutePath() + ".deleteMe").toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
        }
        catch (IOException e) {
            if (Thread.interrupted()) {
                throw Exceptions.addSuppressed(new InterruptedException(), e);
            }
            throw e;
        }
    }

    protected String createTimeTag() {
        return SIMPLE_DATE_FORMAT.format(new Date());
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord2 record) {
        LogToFileSink logToFileSink = this;
        synchronized (logToFileSink) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.shutdown) {
                return;
            }
            if (this.counter == null || this.counter.written >= (long)this.getMaxFileSize()) {
                this.nextFile();
            }
            try {
                BufferedWriter fos = this.fos;
                if (fos != null) {
                    fos.write(this.format(record) + "\r\n");
                    fos.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void nextFile() {
        try {
            this.closeOldFile();
            if (this.logFolder == null) {
                this.initLogFolder();
            }
            ++this.files;
            File file = null;
            while (file == null || file.exists()) {
                file = new File(this.logFolder, this.filepattern.replace("\\d", this.createFileIndexTag(this.files) + "-" + this.createTimeTag()));
                if (!file.exists()) continue;
                ++this.files;
            }
            file.getParentFile().mkdirs();
            this.counter = new CountingOutputStream(new FileOutputStream(file));
            this.fos = new BufferedWriter(new OutputStreamWriter((OutputStream)this.counter, "UTF-8"));
            this.currentFile = file;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileLock tryLock(File folder) {
        AbstractInterruptibleChannel channel = null;
        try {
            if (folder.isFile()) {
                return null;
            }
            if (!folder.exists()) {
                folder.mkdirs();
            }
            File lockFile = new File(folder, "lock.lck");
            channel = new FileOutputStream(lockFile).getChannel();
            FileLock ret = ((FileChannel)channel).tryLock();
            Map<FileLock, File> map = this.lockFiles;
            synchronized (map) {
                this.lockFiles.put(ret, lockFile);
            }
            return ret;
        }
        catch (Exception ignore) {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    protected void initLogFolder() {
        int i = 1;
        while (this.logFolder == null || this.logFolder.exists()) {
            this.logFolder = new File(this.logRoot, "logs_" + this.timeTag + "_" + i++);
            this.logFolderLock = this.tryLock(this.logFolder);
            if (this.logFolderLock != null) break;
            this.logFolder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeOldFile() {
        LogToFileSink logToFileSink = this;
        synchronized (logToFileSink) {
            try {
                BufferedWriter fos = this.fos;
                this.fos = null;
                if (fos != null) {
                    fos.close();
                    this.startAsyncCompressionAfterLogRotation();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void startAsyncCompressionAfterLogRotation() {
        final File cf = this.currentFile;
        Thread th = new Thread("compress log"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LogToFileSink.this.WORK_ON_FOLDERS_AND_FILES_LOCK;
                synchronized (object) {
                    try {
                        LogToFileSink.this.compress(cf, new File(cf.getAbsolutePath() + ".zip"));
                    }
                    finally {
                        LogToFileSink.this.compressionThreadsRunning.decrementAndGet();
                    }
                }
            }
        };
        this.compressionThreadsRunning.incrementAndGet();
        th.start();
    }

    protected void compress(File file, File zip) {
        try {
            zip.delete();
            File tmp = new File(zip.getAbsolutePath() + ".tmp");
            tmp.delete();
            ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(tmp));
            zipout.setLevel(this.zipLevel);
            zipout.putNextEntry(new ZipEntry(file.getName()));
            IO.readStreamToOutputStream(-1, new BufferedInputStream(new FileInputStream(file)), zipout, true);
            zipout.closeEntry();
            zipout.close();
            java.nio.file.Files.move(tmp.toPath(), zip.toPath(), StandardCopyOption.ATOMIC_MOVE);
            file.delete();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected String createFileIndexTag(int files2) {
        String ret = String.valueOf(files2);
        while (ret.length() < 3) {
            ret = "0" + ret;
        }
        return ret;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportFull(long days) throws IOException, Error, InterruptedException {
        Object object = this.WORK_ON_FOLDERS_AND_FILES_LOCK;
        synchronized (object) {
            ArrayList<LogFolder> logFolders = this.getLogFilesOrFolders(false);
            Collections.sort(logFolders, new Comparator<LogFolder>(){

                @Override
                public int compare(LogFolder o1, LogFolder o2) {
                    return CompareUtils.compare(o1.time, o2.time);
                }
            });
            String name = logFolders.size() > 1 ? SIMPLE_DATE_FORMAT.format(new Date(logFolders.get((int)0).time)) + " - " + SIMPLE_DATE_FORMAT.format(new Date(logFolders.get((int)(logFolders.size() - 1)).time)) : SIMPLE_DATE_FORMAT.format(new Date(logFolders.get((int)0).time));
            File zip = new File(this.logRoot, "packages/" + name + ".zip");
            zip.getParentFile().mkdirs();
            File tmp = new File(zip.getAbsolutePath() + ".tmp");
            ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(tmp));
            IOException ioException = null;
            try {
                zipout.setLevel(4);
                this.extendExport(zipout);
                for (LogFolder f : logFolders) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (f.time < days) continue;
                    if (f.path.isFile()) {
                        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(f.path)));
                        try {
                            ZipEntry entry;
                            while ((entry = zis.getNextEntry()) != null) {
                                if (Thread.interrupted()) {
                                    throw new InterruptedException();
                                }
                                zipout.putNextEntry(new ZipEntry(Files.getFileNameWithoutExtension(f.path.getName()) + "/" + entry.getName()));
                                IO.readStreamToOutputStream(-1, zis, zipout, false);
                                zipout.closeEntry();
                            }
                            continue;
                        }
                        finally {
                            zis.close();
                            continue;
                        }
                    }
                    if (this.logFolder != null && f.path.equals(this.logFolder)) {
                        LogToFileSink logToFileSink = this;
                        synchronized (logToFileSink) {
                            boolean restoreFos = false;
                            if (this.fos != null) {
                                restoreFos = true;
                                this.fos.close();
                            }
                            try {
                                this.writeFolderToZip(f.path, false, zipout, true);
                            }
                            finally {
                                if (restoreFos) {
                                    CountingOutputStream oldCounter = this.counter;
                                    this.counter = new CountingOutputStream(new FileOutputStream(this.currentFile, true));
                                    this.fos = new BufferedWriter(new OutputStreamWriter((OutputStream)this.counter, "UTF-8"));
                                    this.counter.written = oldCounter.written;
                                }
                            }
                            continue;
                        }
                    }
                    this.writeFolderToZip(f.path, false, zipout, true);
                }
            }
            catch (IOException e) {
                ioException = e;
            }
            finally {
                zipout.close();
            }
            if (ioException != null) {
                tmp.delete();
                if (Thread.interrupted()) {
                    throw Exceptions.addSuppressed(new InterruptedException(), ioException);
                }
                throw ioException;
            }
            java.nio.file.Files.move(tmp.toPath(), zip.toPath(), StandardCopyOption.ATOMIC_MOVE);
            return zip;
        }
    }

    protected void extendExport(ZipOutputStream zipout) throws IOException {
    }

    class CountingOutputStream
    extends OutputStream {
        private final OutputStream os;
        private volatile long written = 0L;

        public CountingOutputStream(OutputStream os) {
            this.os = os;
        }

        @Override
        public void close() throws IOException {
            this.os.close();
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.os.write(b);
            this.written += (long)b.length;
        }

        public void setTransferedBytes(long written) {
            if (written >= 0L) {
                this.written = written;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
            this.written += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
            ++this.written;
        }
    }

    public static class LogFolder {
        public final File path;
        public final long time;

        public LogFolder(File f, long time) {
            this.path = f;
            this.time = time;
        }

        public long getSize() {
            if (this.path.isFile()) {
                return this.path.length();
            }
            return Files.getDirectorySize(this.path);
        }
    }
}

