/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.loggingv3.simple.sink;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.appwork.loggingv3.simple.Formatter;
import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;

public class SimpleFormatter
implements Formatter {
    protected final LocalTimeFormat longTimestamp = new LocalTimeFormat("dd.MM.yy HH:mm:ss.SSS");
    protected int maxThreadNameLength = 30;
    protected int maxSourceStringLength = 90;
    protected IntByReference offsetForthreadID = new IntByReference(3);
    protected IntByReference offsetForThreadName = new IntByReference(this.maxThreadNameLength + 3);
    protected IntByReference offsetForTimestamp = new IntByReference(5);
    protected IntByReference offsetForThrownAt = new IntByReference(this.maxSourceStringLength + 3);

    @Override
    public String format(LogRecord2 record) {
        String message = record.message == null ? "" : record.message;
        StackTraceElement source = record.getThrownAt();
        String sourceString = Exceptions.stacktraceElementToThrownAtString(source);
        String pre = this.createPre(record, sourceString);
        int line = 0;
        int preLength = pre.length();
        String[] lines = message.split("[\r\n]+");
        StringBuilder sb = new StringBuilder(message.length() + lines.length * preLength);
        sb.append(pre);
        for (String s : lines) {
            if (s.trim().length() <= 0) continue;
            if (line == 0) {
                sb.append(s);
            } else {
                sb.append("\r\n").append(SimpleFormatter.fillPre("", " ", preLength)).append(s);
            }
            ++line;
        }
        return sb.toString();
    }

    protected String createPre(LogRecord2 record, String sourceString) {
        return "--" + SimpleFormatter.fillPre(String.valueOf(record.threadID), " ", this.offsetForthreadID) + SimpleFormatter.fillPost("(" + this.abbr(record.threadName, this.maxThreadNameLength) + ")", " ", this.offsetForThreadName) + " " + SimpleFormatter.fillPre(((SimpleDateFormat)this.longTimestamp.get()).format(new Date(record.timestamp)), " ", this.offsetForTimestamp) + " - " + SimpleFormatter.fillPost("" + this.abbr(String.valueOf(sourceString) + "", this.maxSourceStringLength), " ", this.offsetForThrownAt) + " > ";
    }

    public String abbr(String name, int i) {
        if (name.length() <= i + 3) {
            return name;
        }
        return "..." + name.substring(name.length() - i);
    }

    public static String fillPre(String string, String filler, IntByReference max) {
        string = string == null ? "null" : string;
        max.i = Math.max(max.i, string.length());
        return SimpleFormatter.fillPre(string, filler, max.i);
    }

    private static String fillPre(String string, String filler, int minCount) {
        string = string == null ? "null" : string;
        return StringUtils.fillPre(string, filler, minCount);
    }

    public static String fillPost(String string, String filler, IntByReference max) {
        string = string == null ? "null" : string;
        max.i = Math.max(max.i, string.length());
        if (string.length() == max.i) {
            return string;
        }
        return StringUtils.fillPost(string, filler, max.i);
    }

    public class IntByReference {
        private int i;

        public IntByReference(int i) {
            this.i = i;
        }
    }

    public static class LocalTimeFormat
    extends ThreadLocal<SimpleDateFormat> {
        private final String format;

        public LocalTimeFormat(String format) {
            this.format = format;
        }

        public String toString() {
            return this.format;
        }

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat ret = new SimpleDateFormat(this.format, Locale.US);
            ret.setLenient(false);
            return ret;
        }
    }
}

