/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.moncompare;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.appwork.storage.flexijson.JSPath;

public class Scope {
    private final LinkedList<Object> scope;
    private JSPath path;

    public String toString() {
        return "{ROOT}" + this.path.toPathString(true) + " = " + this.getLast();
    }

    public List<Object> getScope() {
        return this.scope;
    }

    public JSPath getPath() {
        return this.path;
    }

    public Scope(List<Object> scope, JSPath path) {
        this.scope = new LinkedList<Object>(scope);
        this.path = path;
    }

    public Scope(Object matcher) {
        this(new LinkedList<Object>(Arrays.asList(matcher)), new JSPath());
    }

    public Object getLast() {
        return this.scope.getLast();
    }

    public Object getFirst() {
        return this.scope.getFirst();
    }

    public Scope copy() {
        return new Scope(new LinkedList<Object>(this.scope), this.path);
    }

    public void add(Object value, Object key) {
        this.scope.add(value);
        this.path = this.path.derive(key);
    }

    public Scope getParent() {
        Scope ret = this.copy();
        Object last = ret.scope.removeLast();
        ret.path = ret.path.getParent();
        while (ret.scope.size() > 0 && ret.getLast() == last) {
            ret.scope.removeLast();
            ret.path = ret.path.getParent();
        }
        if (ret.scope.size() == 0) {
            return null;
        }
        return ret;
    }

    public void removeLast() {
        this.scope.removeLast();
        this.path = this.path.getParent();
    }
}

