/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.appwork.loggingv3.LogV3;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSONMapper;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.JSonFactory;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.Clazz;

public class JSonStorage {
    private static final HashMap<String, Storage> MAP = new HashMap();
    private static final WeakHashMap<String, WeakReference<String>> DEDUPEMAP = new WeakHashMap();
    private static JSONMapper JSON_MAPPER = new SimpleMapper(){

        @Override
        protected JSonFactory newJsonFactory(String jsonString) {
            return new JSonFactory(jsonString){

                @Override
                protected String dedupeString(String string) {
                    return JSonStorage.dedupeString(string);
                }
            };
        }
    };
    public static byte[] KEY = new byte[]{1, 2, 17, 1, 1, 84, 1, 1, 1, 1, 18, 1, 1, 1, 34, 1};
    private static final HashMap<File, AtomicInteger> LOCKS = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dedupeString(String string) {
        if (string != null) {
            WeakHashMap<String, WeakReference<String>> weakHashMap = DEDUPEMAP;
            synchronized (weakHashMap) {
                String ret = null;
                WeakReference<String> ref = DEDUPEMAP.get(string);
                if (ref != null && (ret = (String)ref.get()) != null) {
                    return ret;
                }
                ref = new WeakReference<String>(string);
                DEDUPEMAP.put(string, ref);
                return string;
            }
        }
        return string;
    }

    public static boolean canStorePrimitive(Class<?> type) {
        return Clazz.isPrimitive(type) || type == String.class || type.isEnum();
    }

    public static JSONMapper getMapper() {
        return JSON_MAPPER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getPlainStorage(String name) throws StorageException {
        String id = name + "_plain";
        Storage ret = null;
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            ret = MAP.get(id);
            if (ret != null) {
                return ret;
            }
        }
        ret = new JsonKeyValueStorage(name, true);
        hashMap = MAP;
        synchronized (hashMap) {
            Storage ret2 = MAP.get(id);
            if (ret2 != null) {
                return ret2;
            }
            MAP.put(id, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getStorage(String name) throws StorageException {
        String id = name + "_crypted";
        Storage ret = null;
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            ret = MAP.get(id);
            if (ret != null) {
                return ret;
            }
        }
        ret = new JsonKeyValueStorage(name);
        hashMap = MAP;
        synchronized (hashMap) {
            Storage ret2 = MAP.get(id);
            if (ret2 != null) {
                return ret2;
            }
            MAP.put(id, ret);
        }
        return ret;
    }

    public static synchronized Object requestLock(File file) {
        AtomicInteger lock = LOCKS.get(file);
        if (lock == null) {
            lock = new AtomicInteger(0);
            LOCKS.put(file, lock);
        }
        lock.incrementAndGet();
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static <E> E restoreFrom(File file, boolean plain, byte[] key, TypeRef<E> type, E def) {
        Object lock;
        Object object = lock = JSonStorage.requestLock(file);
        synchronized (object) {
            File res;
            FileInputStream fis;
            block19: {
                fis = null;
                res = file;
                if (res.isFile() && res.length() != 0L) break block19;
                E e = def;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                JSonStorage.unLock(file);
                return e;
            }
            fis = new FileInputStream(res);
            InputStream is = plain ? fis : JSonStorage.createCipherInputStream(fis, key, key);
            E e = JSonStorage.restoreFromInputStream(is, type);
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JSonStorage.unLock(file);
            return e;
            catch (Throwable e2) {
                E e3;
                try {
                    LogV3.log(new Exception("Failed to restore JSON Object from " + file + ". Fallback to default value. ", e2));
                    e3 = def;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                    JSonStorage.unLock(file);
                }
                return e3;
            }
        }
    }

    @Deprecated
    public static <E> E restoreFromFile(File file, E def) {
        E ret = JSonStorage.restoreFrom(file, true, null, null, def);
        if (ret == null) {
            return def;
        }
        return ret;
    }

    public static <E> E restoreFromByteArray(byte[] jsonByteArray, boolean plain, byte[] key, TypeRef<E> type, E def) {
        if (jsonByteArray != null) {
            try {
                byte[] byteArray = !plain ? JSonStorage.decryptByteArray(jsonByteArray, key, key) : jsonByteArray;
                return JSonStorage.restoreFromByteArray(byteArray, type, def);
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        return def;
    }

    private static byte[] decryptByteArray(byte[] b, byte[] key, byte[] iv) {
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)skeySpec, ivSpec);
            return cipher.doFinal(b);
        }
        catch (Exception e) {
            LogV3.log(e);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            try {
                Cipher cipher = Cipher.getInstance("AES/CBC/nopadding");
                cipher.init(2, (Key)skeySpec, ivSpec);
                cipher.doFinal(b);
            }
            catch (Exception e1) {
                LogV3.log(e1);
            }
            return null;
        }
    }

    public static CipherInputStream createCipherInputStream(InputStream inputStream, byte[] key, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)skeySpec, ivSpec);
        return new CipherInputStream(inputStream, cipher);
    }

    public static CipherOutputStream createCipherOutputStream(OutputStream outputStream, byte[] key, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)skeySpec, ivSpec);
        return new CipherOutputStream(outputStream, cipher);
    }

    @Deprecated
    public static <T> T restoreFromString(String string, Class<T> class1) throws StorageException {
        try {
            return JSON_MAPPER.stringToObject(string, class1);
        }
        catch (Exception e) {
            throw new StorageException(string, e);
        }
    }

    public static <E> E restoreFromString(String string, TypeRef<E> type) {
        if (string == null || "".equals(string)) {
            return null;
        }
        return JSON_MAPPER.stringToObject(string, type);
    }

    public static <E> E restoreFromByteArray(byte[] bytes, TypeRef<E> type) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return JSON_MAPPER.byteArrayToObject(bytes, type);
    }

    public static <E> E restoreFromInputStream(InputStream is, TypeRef<E> type) {
        if (is == null) {
            throw new IllegalArgumentException("Inputstream is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        return JSON_MAPPER.inputStreamToObject(is, type);
    }

    public static <E> E restoreFromString(String string, TypeRef<E> type, E def) {
        if (string != null && string.length() > 0) {
            try {
                return JSonStorage.restoreFromByteArray(string.getBytes("UTF-8"), type, def);
            }
            catch (UnsupportedEncodingException e) {
                LogV3.log(e);
            }
        }
        return def;
    }

    public static <E> E restoreFromByteArray(byte[] byteArray, TypeRef<E> type, E def) {
        if (byteArray != null && byteArray.length > 0) {
            try {
                if (type != null) {
                    return JSON_MAPPER.byteArrayToObject(byteArray, type);
                }
                return (E)JSON_MAPPER.byteArrayToObject(byteArray, def.getClass());
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        return def;
    }

    public static <E> E restoreFromInputStream(InputStream is, TypeRef<E> type, E def) {
        if (is != null) {
            try {
                if (type != null) {
                    return JSON_MAPPER.inputStreamToObject(is, type);
                }
                return (E)JSON_MAPPER.inputStreamToObject(is, def.getClass());
            }
            catch (Exception e) {
                LogV3.log(new Exception());
            }
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close() {
        ArrayList<Storage> storages;
        LogV3.finer("Start Saving Storage");
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            storages = new ArrayList<Storage>(MAP.values());
        }
        for (Storage storage : storages) {
            try {
                storage.save();
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
            finally {
                try {
                    storage.close();
                }
                catch (Throwable e2) {
                    LogV3.log(e2);
                }
            }
        }
        LogV3.finer("ENDED Saving Storage");
    }

    @Deprecated
    public static void saveTo(File file, boolean plain, byte[] key, String json) throws StorageException {
        try {
            JSonStorage.saveTo(file, plain, key, json.getBytes("UTF-8"), IO.SYNC.META_AND_DATA);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void saveTo(File file, final boolean plain, final byte[] key, final byte[] data, IO.SYNC syncMode) throws StorageException {
        Object lock;
        Object object = lock = JSonStorage.requestLock(file);
        synchronized (object) {
            try {
                file.getParentFile().mkdirs();
                IO.WriteToFileCallback writeToFileCallback = new IO.WriteToFileCallback(){

                    @Override
                    public void writeTo(OutputStream os) throws IOException {
                        if (plain) {
                            os.write(data);
                        } else {
                            try {
                                CipherOutputStream cos = JSonStorage.createCipherOutputStream(os, key, key);
                                cos.write(data);
                                cos.close();
                            }
                            catch (IOException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new IOException(e);
                            }
                        }
                    }

                    @Override
                    public void onIOException(IOException e) throws IOException {
                    }

                    @Override
                    public void onClosed() {
                    }
                };
                IO.secureWrite(file, writeToFileCallback, syncMode);
            }
            catch (Exception e) {
                throw new StorageException("Can not write to " + file.getAbsolutePath(), e);
            }
            finally {
                JSonStorage.unLock(file);
            }
        }
    }

    public static void saveTo(File file, boolean plain, byte[] key, byte[] data) throws StorageException {
        JSonStorage.saveTo(file, plain, key, data, IO.SYNC.NONE);
    }

    public static String serializeToJson(Object list) throws StorageException {
        try {
            return JSON_MAPPER.objectToString(list);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public static byte[] serializeToJsonByteArray(Object list) throws StorageException {
        try {
            return JSON_MAPPER.objectToByteArray(list);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public static void setMapper(JSONMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("mapper is null");
        }
        JSON_MAPPER = mapper;
    }

    @Deprecated
    public static <E> E stringToObject(String string, TypeRef<E> type, E def) {
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("cannot stringToObject from empty string");
        }
        if (type != null) {
            return JSON_MAPPER.stringToObject(string, type);
        }
        return (E)JSON_MAPPER.stringToObject(string, def.getClass());
    }

    @Deprecated
    public static String toString(Object list) {
        try {
            return JSON_MAPPER.objectToString(list);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return list.toString();
        }
    }

    public static synchronized void unLock(File file) {
        AtomicInteger lock = LOCKS.get(file);
        if (lock != null && lock.decrementAndGet() == 0) {
            LOCKS.remove(file);
        }
    }

    public static <E> E convert(Object o, TypeRef<E> typeRef) {
        return JSON_MAPPER.convert(o, typeRef);
    }

    static {
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public long getMaxDuration() {
                return 0L;
            }

            @Override
            public int getHookPriority() {
                return 0;
            }

            @Override
            public void onShutdown(ShutdownRequest shutdownRequest) {
                JSonStorage.close();
            }

            @Override
            public String toString() {
                return "ShutdownEvent: Save JSonStorages";
            }
        });
    }
}

