/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import org.appwork.storage.Storage;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DefaultByteValue;
import org.appwork.storage.config.annotations.LookUpKeys;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.StringUtils;

public class ByteKeyHandler
extends KeyHandler<Byte> {
    private SpinnerValidator validator;

    public ByteKeyHandler(StorageHandler<?> storageHandler, String key) {
        super(storageHandler, key);
    }

    @Override
    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        return new Class[]{LookUpKeys.class, SpinnerValidator.class};
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultByteValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue((byte)0);
    }

    @Override
    protected Byte getValueStorage() {
        Object rawValue = this.getRawValueStorage();
        if (rawValue instanceof Number) {
            return ((Number)rawValue).byteValue();
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            if (StringUtils.equalsIgnoreCase("null", stringValue)) {
                if (this.isRealPrimitive()) {
                    return (byte)0;
                }
                return null;
            }
            return Byte.valueOf(stringValue);
        }
        return (Byte)rawValue;
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x instanceof Byte && y instanceof Byte) {
            return x.equals(y);
        }
        return false;
    }

    @Override
    protected void initHandler() {
        this.validator = this.getAnnotation(SpinnerValidator.class);
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
    }

    @Override
    protected void putValue(Byte object) {
        Storage storage = this.storageHandler.getPrimitiveStorage(this);
        if (storage != null) {
            storage.put(this.getKey(), object);
        }
    }

    @Override
    protected void validateValue(Byte object) throws Throwable {
        if (this.validator != null) {
            byte v = object;
            long min = this.validator.min();
            long max = this.validator.max();
            if ((long)v < min) {
                throw new ValidationException("value=" + v + " < min=" + min);
            }
            if ((long)v > max) {
                throw new ValidationException("value=" + v + " > max=" + max);
            }
        }
    }
}

