/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.InterfaceParseException;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.AbstractCustomValueGetter;
import org.appwork.storage.config.annotations.AbstractValidator;
import org.appwork.storage.config.annotations.ConfigEntryKeywords;
import org.appwork.storage.config.annotations.CryptedStorage;
import org.appwork.storage.config.annotations.CustomValueGetter;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DefaultStorageSyncMode;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.DevConfig;
import org.appwork.storage.config.annotations.HexColorString;
import org.appwork.storage.config.annotations.LookUpKeys;
import org.appwork.storage.config.annotations.MultiLineString;
import org.appwork.storage.config.annotations.NoHeadless;
import org.appwork.storage.config.annotations.PlainStorage;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.ValidatorFactory;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.events.ConfigEvent;
import org.appwork.storage.config.events.ConfigEventSender;
import org.appwork.storage.config.handler.ListHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.utils.DebugMode;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.reflection.Clazz;

public abstract class KeyHandler<RawClass> {
    private static final Class<?>[] OK_FOR_ALL = new Class[]{DefaultOnNull.class, HexColorString.class, MultiLineString.class, DefaultStorageSyncMode.class, CustomValueGetter.class, ValidatorFactory.class, DefaultJsonObject.class, DefaultFactory.class, AboutConfig.class, NoHeadless.class, DevConfig.class, RequiresRestart.class, AllowNonStorableObjects.class, DescriptionForConfigEntry.class, ConfigEntryKeywords.class, CryptedStorage.class, PlainStorage.class};
    private static final String ANNOTATION_PACKAGE_NAME = CryptedStorage.class.getPackage().getName();
    private static final String PACKAGE_NAME = PlainStorage.class.getPackage().getName();
    private final String key;
    protected Method getMethod = null;
    protected Method setMethod = null;
    protected final StorageHandler<?> storageHandler;
    protected RawClass defaultValue;
    protected boolean factoryDefaultValueSet = false;
    private ConfigEventSender<RawClass> eventSender;
    private AbstractValidator<RawClass> validatorFactory;
    protected AbstractCustomValueGetter<RawClass> customValueGetter;
    protected String[] backwardsCompatibilityLookupKeys;
    private boolean defaultOnNull = false;
    private IO.SYNC storageSyncMode = IO.SYNC.NONE;
    protected Boolean hasDefaultFactoryAnnotation = null;
    private boolean allowWriteDefaultObjects = true;

    public String[] getBackwardsCompatibilityLookupKeys() {
        return this.backwardsCompatibilityLookupKeys;
    }

    public IO.SYNC getStorageSyncMode() {
        return this.storageSyncMode;
    }

    public void setStorageSyncMode(IO.SYNC storageSyncMode) {
        this.storageSyncMode = storageSyncMode == null ? IO.SYNC.NONE : storageSyncMode;
        this.updateStorageSyncMode();
    }

    protected KeyHandler(StorageHandler<?> storageHandler, String key) {
        this.storageHandler = storageHandler;
        this.key = key;
    }

    protected void updateStorageSyncMode() {
        IO.SYNC wish;
        Storage storage;
        StorageHandler<?> storageHandler = this.getStorageHandler();
        if (storageHandler != null && (storage = storageHandler.getPrimitiveStorage(this)) != null && (wish = this.getStorageSyncMode()) != null) {
            IO.SYNC is = storage.getStorageSyncMode();
            if (is == null) {
                is = IO.SYNC.NONE;
            }
            if (wish.ordinal() > is.ordinal()) {
                storage.setStorageSyncMode(wish);
            }
        }
    }

    public byte[] getCryptKey() {
        Storage storage = this.getStorageHandler().getPrimitiveStorage(this);
        return storage != null ? storage.getCryptKey() : null;
    }

    protected boolean isDefaultOnNull() {
        return this.defaultOnNull || this.getRawClass().isPrimitive();
    }

    public File getPath() {
        return null;
    }

    protected void checkBadAnnotations(Class<? extends Annotation> ... class1) {
        int checker = 0;
        if (this.getAnnotation(this.getDefaultAnnotation()) != null) {
            ++checker;
        }
        if (this.getAnnotation(DefaultJsonObject.class) != null) {
            ++checker;
        }
        if (this.getAnnotation(DefaultFactory.class) != null) {
            ++checker;
        }
        if (checker > 1 && !DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            throw new InterfaceParseException("Make sure that you use only one of getDefaultAnnotation, DefaultObjectValue, DefaultValue or a DefaultFactory");
        }
        if (this.getMethod != null) {
            this.checkBadAnnotations(this.getMethod, class1);
        }
        if (this.setMethod != null) {
            this.checkBadAnnotations(this.setMethod, class1);
        }
    }

    private void checkBadAnnotations(Method m, Class<? extends Annotation> ... classes) {
        block0: for (Annotation a : m.getAnnotations()) {
            if (a == null || !a.annotationType().getName().startsWith(PACKAGE_NAME) || this.getDefaultAnnotation() != null && this.getDefaultAnnotation().isAssignableFrom(a.getClass())) continue;
            int index = 0;
            for (index = 0; index < OK_FOR_ALL.length; ++index) {
                if (OK_FOR_ALL[index].isAssignableFrom(a.getClass())) continue block0;
            }
            for (index = 0; index < classes.length; ++index) {
                if (classes[index].isAssignableFrom(a.getClass())) continue block0;
            }
            throw new InterfaceParseException("Bad Annotation: " + a + " for " + m);
        }
    }

    protected void fireEvent(ConfigEvent.Types type, KeyHandler<?> keyHandler, Object parameter) {
        this.storageHandler.fireEvent(type, keyHandler, parameter);
        if (this.hasEventListener()) {
            this.getEventSender().fireEvent(new ConfigEvent(type, this, parameter));
        }
    }

    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        return new Class[]{LookUpKeys.class};
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        if (annotation == null) {
            return null;
        }
        Object ret = this.getMethod.getAnnotation(annotation);
        if (ret == null && this.setMethod != null) {
            ret = this.setMethod.getAnnotation(annotation);
        }
        if (ret == null) {
            try {
                List<T> annotations = ClassCache.getClassCache(this.getDeclaringClass()).getMethodAnnotations(this.getMethod, annotation);
                if (annotations.size() <= 0) {
                    return null;
                }
                ret = (Annotation)annotations.get(0);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public Class<?> getDeclaringClass() {
        if (this.getMethod != null) {
            return this.getMethod.getDeclaringClass();
        }
        return this.setMethod.getDeclaringClass();
    }

    protected Class<? extends Annotation> getDefaultAnnotation() {
        return null;
    }

    public boolean hasDefaultValue() {
        try {
            DefaultFactory df = this.getDefaultFactoryAnnotation();
            if (df != null) {
                return true;
            }
            DefaultJsonObject defaultJson = this.getAnnotation(DefaultJsonObject.class);
            if (defaultJson != null && defaultJson.value() != null) {
                return true;
            }
            Annotation ann = this.getAnnotation(this.getDefaultAnnotation());
            return ann != null;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public IO.SYNC getDefaultStorageSyncMode() {
        try {
            DefaultStorageSyncMode df = this.getAnnotation(DefaultStorageSyncMode.class);
            if (df != null) {
                return df.value();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return IO.SYNC.NONE;
    }

    protected DefaultFactory getDefaultFactoryAnnotation() {
        DefaultFactory df = !Boolean.FALSE.equals(this.hasDefaultFactoryAnnotation) ? this.getAnnotation(DefaultFactory.class) : null;
        this.hasDefaultFactoryAnnotation = df != null;
        return df;
    }

    public RawClass getDefaultValue() {
        try {
            DefaultFactory df = this.getDefaultFactoryAnnotation();
            if (df != null) {
                AbstractDefaultFactory<?> defaultFactory = df.value().newInstance();
                Object defaultValue = defaultFactory.getDefaultValue(this);
                defaultValue = this.storageHandler.runDefaultValueFactory(this, defaultValue);
                defaultValue = this.applyCustomValueGetter(defaultValue);
                return (RawClass)defaultValue;
            }
            if (this.isFactoryDefaultValueSet()) {
                RawClass defaultValue = this.accessDefaultValue();
                return defaultValue;
            }
            DefaultJsonObject defaultJson = this.getAnnotation(DefaultJsonObject.class);
            if (defaultJson != null) {
                Object defaultValue = JSonStorage.restoreFromString(defaultJson.value(), this.getTypeRef(), null);
                defaultValue = this.storageHandler.runDefaultValueFactory(this, defaultValue);
                defaultValue = this.applyCustomValueGetter(defaultValue);
                this.setFactoryDefaultValue(defaultValue);
                return (RawClass)defaultValue;
            }
            Annotation ann = this.getAnnotation(this.getDefaultAnnotation());
            if (ann != null) {
                Object defaultValueObject = ann.annotationType().getMethod("value", new Class[0]).invoke((Object)ann, new Object[0]);
                Object defaultValue = this.fixValueType(defaultValueObject);
                defaultValue = this.storageHandler.runDefaultValueFactory(this, defaultValue);
                defaultValue = this.applyCustomValueGetter(defaultValue);
                this.setFactoryDefaultValue(defaultValue);
                return defaultValue;
            }
            Object defaultValue = this.accessDefaultValue();
            defaultValue = this.storageHandler.runDefaultValueFactory(this, defaultValue);
            defaultValue = this.applyCustomValueGetter(defaultValue);
            this.setFactoryDefaultValue(defaultValue);
            return defaultValue;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public TypeRef<RawClass> getTypeRef() {
        return new TypeRef<RawClass>(this.getRawType()){};
    }

    protected RawClass fixValueType(Object value) {
        if (value == null) {
            return null;
        }
        if (value != null && !value.getClass().equals(this.getRawType())) {
            if (Clazz.isPrimitive(value.getClass()) && Clazz.isPrimitive(this.getRawType())) {
                return (RawClass)value;
            }
            byte[] jsonBytes = JSonStorage.serializeToJsonByteArray(value);
            return JSonStorage.restoreFromByteArray(jsonBytes, this.getTypeRef());
        }
        return (RawClass)value;
    }

    protected RawClass applyCustomValueGetter(RawClass value) {
        if (this.customValueGetter != null) {
            return this.customValueGetter.getValue(this, value);
        }
        return value;
    }

    public synchronized ConfigEventSender<RawClass> getEventSender() {
        if (this.eventSender == null) {
            this.eventSender = new ConfigEventSender();
        }
        return this.eventSender;
    }

    public Method getGetMethod() {
        return this.getMethod;
    }

    public String getKey() {
        return this.key;
    }

    public Class<RawClass> getRawClass() {
        Class<?> ret = this.getMethod != null ? this.getMethod.getReturnType() : this.setMethod.getParameterTypes()[0];
        return ret;
    }

    public Type getRawType() {
        if (this.getMethod != null) {
            return this.getMethod.getGenericReturnType();
        }
        return this.setMethod.getGenericParameterTypes()[0];
    }

    public Method getSetMethod() {
        return this.setMethod;
    }

    public StorageHandler<?> getStorageHandler() {
        return this.storageHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractTypeDefinition getAbstractType() {
        Type ret = this.getRawType();
        if (ret instanceof Class) {
            Class clazz = (Class)ret;
            if (Clazz.isBoolean(ret)) {
                return AbstractTypeDefinition.BOOLEAN;
            }
            if (Clazz.isByte(ret)) {
                return AbstractTypeDefinition.BYTE;
            }
            if (Clazz.isCharacter(ret)) {
                return AbstractTypeDefinition.CHAR;
            }
            if (Clazz.isDouble(ret)) {
                return AbstractTypeDefinition.DOUBLE;
            }
            if (Clazz.isEnum(ret)) {
                return AbstractTypeDefinition.ENUM;
            }
            if (Clazz.isFloat(ret)) {
                return AbstractTypeDefinition.FLOAT;
            }
            if (Clazz.isInteger(ret)) {
                return AbstractTypeDefinition.INT;
            }
            if (Clazz.isLong(ret)) {
                return AbstractTypeDefinition.LONG;
            }
            if (Clazz.isShort(ret)) {
                return AbstractTypeDefinition.SHORT;
            }
            if (Clazz.isString(ret)) {
                if (this.getAnnotation(HexColorString.class) == null) return AbstractTypeDefinition.STRING;
                return AbstractTypeDefinition.HEX_COLOR;
            }
            if (!clazz.isArray()) return AbstractTypeDefinition.OBJECT;
            Class<?> aType = ((Class)ret).getComponentType();
            if (Clazz.isBoolean(aType)) {
                return AbstractTypeDefinition.BOOLEAN_LIST;
            }
            if (Clazz.isByte(aType)) {
                return AbstractTypeDefinition.BYTE_LIST;
            }
            if (Clazz.isCharacter(aType)) {
                return AbstractTypeDefinition.CHAR_LIST;
            }
            if (Clazz.isDouble(aType)) {
                return AbstractTypeDefinition.DOUBLE_LIST;
            }
            if (Clazz.isEnum(aType)) {
                return AbstractTypeDefinition.ENUM_LIST;
            }
            if (Clazz.isFloat(aType)) {
                return AbstractTypeDefinition.FLOAT_LIST;
            }
            if (Clazz.isInteger(aType)) {
                return AbstractTypeDefinition.INT_LIST;
            }
            if (Clazz.isLong(aType)) {
                return AbstractTypeDefinition.LONG_LIST;
            }
            if (Clazz.isShort(aType)) {
                return AbstractTypeDefinition.SHORT_LIST;
            }
            if (!Clazz.isString(aType)) return AbstractTypeDefinition.OBJECT_LIST;
            if (this.getAnnotation(HexColorString.class) == null) return AbstractTypeDefinition.STRING_LIST;
            return AbstractTypeDefinition.HEX_COLOR_LIST;
        }
        if (!(ret instanceof ParameterizedType)) return AbstractTypeDefinition.UNKNOWN;
        Type raw = ((ParameterizedType)ret).getRawType();
        Type[] acutal = ((ParameterizedType)ret).getActualTypeArguments();
        if (!(raw instanceof Class)) return AbstractTypeDefinition.UNKNOWN;
        Class rawClazz = (Class)raw;
        if (!List.class.isAssignableFrom(rawClazz)) return AbstractTypeDefinition.OBJECT;
        if (Clazz.isBoolean(acutal[0])) {
            return AbstractTypeDefinition.BOOLEAN_LIST;
        }
        if (Clazz.isByte(acutal[0])) {
            return AbstractTypeDefinition.BYTE_LIST;
        }
        if (Clazz.isCharacter(acutal[0])) {
            return AbstractTypeDefinition.CHAR_LIST;
        }
        if (Clazz.isDouble(acutal[0])) {
            return AbstractTypeDefinition.DOUBLE_LIST;
        }
        if (Clazz.isEnum(acutal[0])) {
            return AbstractTypeDefinition.ENUM_LIST;
        }
        if (Clazz.isFloat(acutal[0])) {
            return AbstractTypeDefinition.FLOAT_LIST;
        }
        if (Clazz.isInteger(acutal[0])) {
            return AbstractTypeDefinition.INT_LIST;
        }
        if (Clazz.isLong(acutal[0])) {
            return AbstractTypeDefinition.LONG_LIST;
        }
        if (Clazz.isShort(acutal[0])) {
            return AbstractTypeDefinition.SHORT_LIST;
        }
        if (!Clazz.isString(acutal[0])) return AbstractTypeDefinition.OBJECT_LIST;
        if (this.getAnnotation(HexColorString.class) == null) return AbstractTypeDefinition.STRING_LIST;
        return AbstractTypeDefinition.HEX_COLOR_LIST;
    }

    public String getTypeString() {
        Type ret = this.getRawType();
        if (ret instanceof Class) {
            return ((Class)ret).getName();
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawClass getValue() {
        KeyHandler keyHandler = this;
        synchronized (keyHandler) {
            RawClass value = this.getValueStorage();
            if (value == null && this.isDefaultOnNull()) {
                value = this.getDefaultValue();
            }
            value = this.applyCustomValueGetter(value);
            return value;
        }
    }

    protected RawClass getValueStorage() {
        Object rawValue = this.getRawValueStorage();
        return (RawClass)rawValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getRawValueStorage() {
        Storage storage = this.getStorageHandler().getPrimitiveStorage(this);
        if (storage == null) {
            return this.getDefaultValue();
        }
        if (storage.hasProperty(this.getKey())) {
            return storage.get(this.getKey(), this.accessDefaultValue());
        }
        String[] backwardsCompatibilityLookupKeys = this.getBackwardsCompatibilityLookupKeys();
        if (backwardsCompatibilityLookupKeys != null) {
            for (String key : backwardsCompatibilityLookupKeys) {
                if (!storage.hasProperty(key)) continue;
                boolean apv = storage.isAutoPutValues();
                try {
                    if (!apv) {
                        storage.setAutoPutValues(true);
                    }
                    RawClass RawClass = storage.get(this.getKey(), storage.get(key, this.accessDefaultValue()));
                    return RawClass;
                }
                finally {
                    if (!apv) {
                        storage.setAutoPutValues(apv);
                    }
                }
            }
        }
        return storage.get(this.getKey(), this.getDefaultValue(), this.isAllowWriteDefaultObjects());
    }

    protected RawClass accessDefaultValue() {
        return this.defaultValue;
    }

    public boolean isAllowWriteDefaultObjects() {
        return this.allowWriteDefaultObjects;
    }

    public void setAllowWriteDefaultObjects(boolean allowWriteDefaultObjects) {
        this.allowWriteDefaultObjects = allowWriteDefaultObjects;
    }

    public synchronized boolean hasEventListener() {
        return this.eventSender != null && this.eventSender.hasListener();
    }

    protected void init() throws Throwable {
        LookUpKeys lookups;
        Annotation anno2;
        PlainStorage plainStorage;
        if (this.getMethod == null) {
            throw new InterfaceParseException("Getter Method is Missing for " + this.setMethod);
        }
        CryptedStorage cryptedStorage = this.getAnnotation(CryptedStorage.class);
        if (cryptedStorage != null) {
            Storage storage = this.storageHandler.getPrimitiveStorage(this);
            if (storage != null && storage.getCryptKey() != null) {
                throw new InterfaceParseException("No reason to mark " + this + " as @CryptedStorage. Parent is already CryptedStorage");
            }
            if (!(this instanceof ListHandler)) {
                throw new InterfaceParseException(this + " Cannot set @CryptedStorage on primitive fields. Use an object, or an extra plain config interface");
            }
            this.validateEncryptionKey(cryptedStorage.key());
        }
        if ((plainStorage = this.getAnnotation(PlainStorage.class)) != null) {
            if (cryptedStorage != null) {
                throw new InterfaceParseException("Cannot Set CryptStorage and PlainStorage Annotation in " + this);
            }
            Storage storage = this.storageHandler.getPrimitiveStorage(this);
            if (storage != null && storage.getCryptKey() == null) {
                throw new InterfaceParseException("No reason to mark " + this + " as @PlainStorage. Parent is already Plain");
            }
            if (!(this instanceof ListHandler)) {
                throw new InterfaceParseException(this + " Cannot set @PlainStorage on primitive fields. Use an object, or an extra plain config interface");
            }
        }
        try {
            anno2 = this.getAnnotation(ValidatorFactory.class);
            if (anno2 != null) {
                this.validatorFactory = anno2.value().newInstance();
            }
        }
        catch (Throwable anno2) {
            // empty catch block
        }
        try {
            anno2 = this.getAnnotation(CustomValueGetter.class);
            if (anno2 != null) {
                this.customValueGetter = anno2.value().newInstance();
            }
        }
        catch (Throwable anno3) {
            // empty catch block
        }
        try {
            this.defaultOnNull = this.getAnnotation(DefaultOnNull.class) != null;
        }
        catch (Throwable anno3) {
            // empty catch block
        }
        this.checkBadAnnotations(this.getAllowedAnnotations());
        this.initDefaults();
        this.initHandler();
        String kk = "CFG:" + this.storageHandler.getConfigInterface().getName() + "." + this.key;
        String sys = System.getProperty(kk);
        if (sys != null) {
            this.setValue(JSonStorage.restoreFromString(sys, new TypeRef<Object>(this.getRawClass()){}, null));
        }
        if ((lookups = this.getAnnotation(LookUpKeys.class)) != null) {
            this.backwardsCompatibilityLookupKeys = lookups.value();
        }
    }

    protected boolean isDelayedWriteAllowed() {
        return true;
    }

    protected void initDefaults() throws Throwable {
        this.defaultValue = null;
    }

    protected abstract void initHandler() throws Throwable;

    public boolean isChildOf(ConfigInterface settings) {
        return settings._getStorageHandler() == this.getStorageHandler();
    }

    protected boolean isGetter(Method m) {
        return m != null && m.equals(this.getMethod);
    }

    protected boolean isPrimitiveType() {
        return JSonStorage.canStorePrimitive(this.getMethod.getReturnType());
    }

    protected boolean isRealPrimitive() {
        return this.getRawClass().isPrimitive();
    }

    protected abstract void putValue(RawClass var1);

    protected void setDefaultValue(RawClass value) {
        this.defaultValue = value;
    }

    protected void setFactoryDefaultValue(RawClass value) {
        this.defaultValue = value;
        this.factoryDefaultValueSet = true;
    }

    protected boolean isFactoryDefaultValueSet() {
        return this.factoryDefaultValueSet;
    }

    protected void resetFactoryDefaultValue() {
        this.factoryDefaultValueSet = false;
    }

    protected void setGetMethod(Method method) {
        this.getMethod = method;
    }

    protected void setSetMethod(Method method) {
        this.setMethod = method;
    }

    protected boolean setValueEqualsGetValue(RawClass newValue) {
        RawClass oldValue = this.getValue();
        return this.equals(newValue, oldValue);
    }

    public void setValueAutoConvert(Object newValue) throws ValidationException {
        Class<RawClass> rawClass = this.getRawClass();
        if (this.isAutoValueConvertSupported(newValue, rawClass)) {
            RawClass convertedNewValue = this.autoConvertValue(newValue, rawClass);
            this.setValue(convertedNewValue);
        } else {
            this.setValue(newValue);
        }
    }

    protected boolean isAutoValueConvertSupported(Object newValue, Class<?> destClass) {
        return Clazz.isPrimitive(destClass);
    }

    protected <T> T autoConvertValue(Object newValue, Class<T> destClass) {
        if (Clazz.isPrimitive(destClass)) {
            Object ret = ReflectionUtils.cast(newValue, destClass);
            return (T)ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(RawClass newValue) throws ValidationException {
        try {
            KeyHandler keyHandler = this;
            synchronized (keyHandler) {
                if (this.setValueEqualsGetValue(newValue)) {
                    return;
                }
                if (this.validatorFactory != null) {
                    this.validatorFactory.validate(this, newValue);
                }
                this.validateValue(newValue);
                this.putValue(newValue);
                this.getStorageHandler().requestSave();
            }
            this.fireEvent(ConfigEvent.Types.VALUE_UPDATED, this, newValue);
        }
        catch (ValidationException e) {
            e.setValue(newValue);
            this.fireEvent(ConfigEvent.Types.VALIDATOR_ERROR, this, e);
            throw e;
        }
        catch (Throwable t) {
            ValidationException e = new ValidationException(t);
            e.setValue(newValue);
            this.fireEvent(ConfigEvent.Types.VALIDATOR_ERROR, this, e);
            throw e;
        }
    }

    protected boolean equals(Object x, Object y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        return false;
    }

    public String toString() {
        RawClass ret = this.getValue();
        return ret == null ? null : ret.toString();
    }

    public void validateEncryptionKey(byte[] key2) {
        if (key2 == null) {
            throw new InterfaceParseException("Key missing in " + this);
        }
        if (key2.length != JSonStorage.KEY.length) {
            throw new InterfaceParseException("Crypt key for " + this + " is invalid. required length: " + JSonStorage.KEY.length);
        }
    }

    protected abstract void validateValue(RawClass var1) throws Throwable;

    public String getReadableName() {
        String getterName = this.getGetMethod().getName();
        if (getterName.startsWith("is")) {
            getterName = getterName.substring(2);
        } else if (getterName.startsWith("get")) {
            getterName = getterName.substring(3);
        }
        getterName = getterName.replaceAll("([a-z])([A-Z])", "$1 $2");
        getterName = getterName.replaceAll("(\\D)(\\d+)", "$1 $2");
        getterName = getterName.replaceAll("(\\d+)(\\D)", "$1 $2");
        getterName = getterName.replaceAll("(\\S)([A-Z][a-z])", "$1 $2");
        getterName = getterName.replaceAll("I P", "IP");
        getterName = getterName.replaceAll("(\\d{3,4}) ?(p|P)", "$1$2");
        getterName = getterName.replaceAll("(^| )(2|4|5|6|8|12) ?(k|K)($| )", "$1$2$3$4");
        getterName = getterName.replaceAll("(?i)(MP) ?(3|4)", "$1$2");
        if (getterName.endsWith(" Enabled")) {
            getterName = getterName.substring(0, getterName.length() - 8);
        }
        return getterName;
    }

    public static enum AbstractTypeDefinition {
        BOOLEAN,
        INT,
        LONG,
        STRING,
        OBJECT,
        OBJECT_LIST,
        STRING_LIST,
        ENUM,
        BYTE,
        CHAR,
        DOUBLE,
        FLOAT,
        SHORT,
        BOOLEAN_LIST,
        BYTE_LIST,
        SHORT_LIST,
        LONG_LIST,
        INT_LIST,
        FLOAT_LIST,
        ENUM_LIST,
        DOUBLE_LIST,
        CHAR_LIST,
        UNKNOWN,
        HEX_COLOR,
        HEX_COLOR_LIST;

    }
}

