/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.swing.models;

import java.util.List;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.ShortKeyHandler;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.storage.config.swing.models.ConfigIntSpinnerModel;
import org.appwork.storage.config.swing.models.KeyHandlerProviderBridge;
import org.appwork.utils.swing.EDTRunner;

public class ConfigShortSpinnerModel
extends SpinnerNumberModel
implements ValueProviderListener<Short> {
    private static final long serialVersionUID = 8542048212034642953L;
    private final ValueProvider<Short> provider;

    public ConfigShortSpinnerModel(ShortKeyHandler keyHandler) {
        this(new KeyHandlerProviderBridge<Short>(keyHandler));
    }

    public ConfigShortSpinnerModel(ValueProvider<Short> provider) {
        this.provider = provider;
        provider.register(this, true);
        List<SpinnerValidator> spinn = provider.getAnnotations(SpinnerValidator.class);
        if (spinn != null && spinn.size() > 0) {
            this.setMinimum((Comparable)Long.valueOf(spinn.get(0).min()));
            this.setMaximum((Comparable)Long.valueOf(spinn.get(0).max()));
            this.setStepSize(spinn.get(0).step());
        }
    }

    public void setMinimum(Comparable minimum) {
        super.setMinimum(Short.valueOf(((Number)((Object)minimum)).shortValue()));
    }

    public void setMaximum(Comparable maximum) {
        super.setMaximum(Short.valueOf(((Number)((Object)maximum)).shortValue()));
    }

    @Override
    public void setStepSize(Number stepSize) {
        super.setStepSize(stepSize.shortValue());
    }

    @Override
    public Number getNumber() {
        return this.provider.get();
    }

    @Override
    public Object getNextValue() {
        return this.incrValue((short)1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue((short)-1);
    }

    protected Number incrValue(short i) {
        return ConfigIntSpinnerModel.incrValue(this, Short.class, i);
    }

    @Override
    public Object getValue() {
        return this.provider.get();
    }

    @Override
    public void setValue(Object value) {
        try {
            if (value instanceof Number) {
                this.provider.set(((Number)value).shortValue());
            } else if (value instanceof String && ((String)value).matches("^-?\\d+$")) {
                this.provider.set(Short.valueOf(String.valueOf(value)));
            }
        }
        catch (ValidationException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        }
    }

    @Override
    public void onValueModified(ValueProvider<Short> owner, Short newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigShortSpinnerModel.this.fireStateChanged();
            }
        };
    }

    @Override
    public void onValueValidationError(ValueProvider<Short> owner, Short invalidValue, Exception exception) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigShortSpinnerModel.this.fireStateChanged();
            }
        };
    }
}

