/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.InvalidPathException;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyStringify;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;

public class FlexiJSonArray
extends ArrayList<FlexiJSonNode>
implements FlexiJSonNode {
    private static final long serialVersionUID = 1L;
    private HashSet<FlexiMapperTags> tags;
    private FlexiJSonComments commentsBefore;
    private FlexiJSonComments commentsInside;
    private FlexiJSonComments commentsAfter;
    private FlexiJSonNode parent;

    public FlexiJSonArray(int size) {
        super(size);
    }

    public FlexiJSonArray() {
    }

    @Override
    public void tag(FlexiMapperTags tag) {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        if (tag != null) {
            this.tags.add(tag);
        }
    }

    @Override
    public Set<FlexiMapperTags> getTags() {
        return this.tags;
    }

    @Override
    public int hashCode() {
        return FlexiJSonArray.class.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FlexiJSonArray)) {
            return false;
        }
        FlexiJSonArray other = (FlexiJSonArray)obj;
        if (other.size() != this.size()) {
            return false;
        }
        FlexiJSonStringBuilder stringify = new FlexiJSonStringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (stringify.toJSONString((FlexiJSonNode)other.get(i)).equals(stringify.toJSONString((FlexiJSonNode)this.get(i)))) continue;
            return false;
        }
        return stringify.toJSONString(other).equals(stringify.toJSONString(this));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " - " + new FlexiJSonPrettyStringify().toJSONString(this);
    }

    public String toPrettyString() {
        return new FlexiJSonPrettyStringify().toJSONString(this);
    }

    @Override
    public boolean add(FlexiJSonNode e) {
        e.setParent(this);
        return super.add(e);
    }

    @Override
    public void add(int index, FlexiJSonNode e) {
        e.setParent(this);
        super.add(index, e);
    }

    @Override
    public FlexiJSonNode set(int index, FlexiJSonNode e) {
        e.setParent(this);
        return super.set(index, e);
    }

    @Override
    public boolean addAll(Collection<? extends FlexiJSonNode> c) {
        throw new WTFException("Not supported");
    }

    @Override
    public boolean addAll(int index, Collection<? extends FlexiJSonNode> c) {
        throw new WTFException("Not supported");
    }

    @Override
    public void replaceAll(UnaryOperator<FlexiJSonNode> operator) {
        throw new WTFException("Not supported");
    }

    @Override
    public void addCommentsBefore(FlexiJSonComments comments) {
        if (comments == null) {
            return;
        }
        comments.setParent(this);
        for (FlexiCommentJsonNode comment : comments) {
            comment.setLocation(FlexiCommentJsonNode.AttachLocation.BEFORE_ARRAY);
        }
        if (this.commentsBefore == null) {
            this.commentsBefore = comments;
        } else {
            this.commentsBefore.addAll(comments);
        }
    }

    @Override
    public void addCommentsAfter(FlexiJSonComments comments) {
        if (comments == null) {
            return;
        }
        comments.setParent(this);
        for (FlexiCommentJsonNode comment : comments) {
            comment.setLocation(FlexiCommentJsonNode.AttachLocation.AFTER_ARRAY);
        }
        if (this.commentsAfter == null) {
            this.commentsAfter = comments;
        } else {
            this.commentsAfter.addAll(comments);
        }
    }

    public void addCommentsInside(FlexiJSonComments comments) {
        if (comments == null) {
            return;
        }
        comments.setParent(this);
        for (FlexiCommentJsonNode comment : comments) {
            comment.setLocation(FlexiCommentJsonNode.AttachLocation.INSIDE_ARRAY);
        }
        if (this.commentsInside == null) {
            this.commentsInside = comments;
        } else {
            this.commentsInside.addAll(comments);
        }
    }

    public FlexiJSonComments getCommentsInside() {
        return this.commentsInside;
    }

    public void setCommentsInside(FlexiJSonComments commentsInside) {
        if (commentsInside != null) {
            commentsInside.setParent(this);
            for (FlexiCommentJsonNode comment : commentsInside) {
                comment.setLocation(FlexiCommentJsonNode.AttachLocation.INSIDE_ARRAY);
            }
        }
        this.commentsInside = commentsInside;
    }

    @Override
    public boolean hasComments() {
        if (this.getCommentsInside() != null && this.getCommentsInside().size() > 0) {
            return true;
        }
        if (this.getCommentsAfter() != null && this.getCommentsAfter().size() > 0) {
            return true;
        }
        return this.getCommentsBefore() != null && this.getCommentsBefore().size() > 0;
    }

    @Override
    public FlexiJSonComments getCommentsBefore() {
        return this.commentsBefore;
    }

    @Override
    public void setCommentsBefore(FlexiJSonComments commentsBefore) {
        if (commentsBefore != null) {
            commentsBefore.setParent(this);
            for (FlexiCommentJsonNode comment : commentsBefore) {
                comment.setLocation(FlexiCommentJsonNode.AttachLocation.BEFORE_ARRAY);
            }
        }
        this.commentsBefore = commentsBefore;
    }

    @Override
    public FlexiJSonComments getCommentsAfter() {
        return this.commentsAfter;
    }

    @Override
    public void setCommentsAfter(FlexiJSonComments commentsAfter) {
        if (commentsAfter != null) {
            commentsAfter.setParent(this);
            for (FlexiCommentJsonNode comment : commentsAfter) {
                comment.setLocation(FlexiCommentJsonNode.AttachLocation.AFTER_ARRAY);
            }
        }
        this.commentsAfter = commentsAfter;
    }

    @Override
    public void writeToStream(FlexiJSonStringBuilder stringifier, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        stringifier.appendArray(this, out, layer, path);
    }

    @Override
    public void setParent(FlexiJSonNode parent) {
        this.parent = parent;
    }

    @Override
    public FlexiJSonNode getParent() {
        return this.parent;
    }

    public FlexiJSonNode resolvePath(String path) throws InvalidPathException {
        return this.resolvePath(JSPath.fromPathString(path));
    }

    @Override
    public FlexiJSonNode resolvePath(JSPath splitPath) {
        return FlexiJSonObject.resolvePath(splitPath, this);
    }

    @Override
    public boolean remove(FlexiJSonNode node) {
        FlexiJSonValue.removeCommentsFromNode(node, this);
        if (node instanceof FlexiJSonComments && node == this.getCommentsInside()) {
            this.setCommentsInside(null);
            return true;
        }
        return this.remove((Object)node);
    }
}

