/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.appwork.utils.swing.SwingUtils;

public class ExtTextPane
extends JTextPane
implements DocumentListener,
FocusListener {
    private static final long serialVersionUID = -8609711635557381385L;
    private Color defaultColor;
    private Color helpColor;
    private String helpText;
    protected ImageIcon badgeIcon;

    public ExtTextPane() {
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(this);
        this.defaultColor = this.getForeground();
        this.helpColor = (Color)UIManager.get("TextField.disabledForeground");
        if (this.helpColor == null) {
            this.helpColor = Color.LIGHT_GRAY;
        }
        this.helpText = null;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onChanged();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        if (super.getText().equals(this.helpText)) {
            this.setText("");
            this.setForeground(this.defaultColor);
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.getDocument().getLength() == 0 || super.getText().equals(this.helpText)) {
            this.setText(this.helpText);
            this.setForeground(this.helpColor);
        }
    }

    public Color getHelpColor() {
        return this.helpColor;
    }

    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public String getText() {
        String ret = super.getText();
        if (ret.equals(this.helpText)) {
            ret = "";
        }
        return ret;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onChanged();
    }

    public boolean isHelpTextVisible() {
        return this.helpText != null && this.helpText.equals(super.getText());
    }

    public void onChanged() {
    }

    public void paintBadge(Graphics g) {
        if (this.badgeIcon != null) {
            if (this.getParent().getParent() instanceof JScrollPane) {
                Point rec = SwingUtilities.convertPoint(this, new Point(0, 0), this.getParent().getParent());
                g.translate(-rec.x, -rec.y);
                g.drawImage(this.badgeIcon.getImage(), (int)((double)this.getParent().getParent().getWidth() - (double)this.badgeIcon.getIconWidth() / 1.5), (int)((double)this.getParent().getParent().getHeight() - (double)this.badgeIcon.getIconHeight() / 1.5), null);
                g.translate(rec.x, rec.y);
            } else {
                g.drawImage(this.badgeIcon.getImage(), (int)((double)this.getWidth() - (double)this.badgeIcon.getIconWidth() / 1.5), (int)((double)this.getHeight() - (double)this.badgeIcon.getIconHeight() / 1.5), null);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Shape clp = g.getClip();
        g.setClip(null);
        this.paintBadge(g);
        g.setClip(clp);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onChanged();
    }

    public void setBadgeIcon(ImageIcon icon) {
        this.badgeIcon = icon;
        this.repaint();
    }

    public void setHelpColor(Color helpColor) {
        this.helpColor = helpColor;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
        if (this.getText().length() == 0) {
            this.setText(this.helpText);
            this.setForeground(this.helpColor);
        }
    }

    public void setLabelMode(boolean b) {
        this.setEditable(!b);
        this.setFocusable(!b);
        this.setBorder(b ? null : new JTextArea().getBorder());
        SwingUtils.setOpaque(this, !b);
    }

    @Override
    public void setText(String t) {
        if (!(this.hasFocus() || this.helpText == null || t != null && t.length() != 0)) {
            t = this.helpText;
        }
        super.setText(t);
        if (this.helpText != null) {
            if (this.helpText.equals(t)) {
                this.setForeground(this.helpColor);
            } else {
                this.setForeground(this.defaultColor);
            }
        }
    }
}

