/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableIcon;
import org.appwork.swing.exttable.ExtTableModelEventSender;
import org.appwork.swing.exttable.ExtTableModelEventWrapper;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;

public abstract class ExtTableModel<E>
extends AbstractTableModel {
    public static final String SORT_ORDER_ID_KEY = "SORT_ORDER_ID";
    public static final String SORTCOLUMN_KEY = "SORTCOLUMN";
    private static final long serialVersionUID = 939549808899567618L;
    protected static final int UPDATE_STRUCTURE = 1;
    protected List<ExtColumn<E>> columns = new ArrayList<ExtColumn<E>>();
    private String modelID;
    private ExtTable<E> table = null;
    protected List<E> tableData = new ArrayList();
    protected volatile ExtColumn<E> sortColumn;
    private volatile List<ExtComponentRowHighlighter<E>> extComponentRowHighlighters;
    private Object highlighterLock = new Object();
    private Icon iconAsc;
    private Icon iconDesc;
    private PropertyChangeListener replaceDelayer;
    private volatile boolean replaceDelayerSet = false;
    private volatile List<E> delayedNewTableData = null;
    private boolean debugTableModel = false;
    private AtomicBoolean tableStructureChanging = new AtomicBoolean(false);
    private AtomicBoolean tableSelectionClearing = new AtomicBoolean(false);
    private ExtTableModelEventSender eventSender;
    private boolean autoWidthEnabled = false;
    private int columnModifications = 0;

    public int getColumnModifications() {
        return this.columnModifications;
    }

    public ExtTableModel(String id) {
        this.init(id);
    }

    protected void init(String id) {
        this.extComponentRowHighlighters = new ArrayList<ExtComponentRowHighlighter<E>>();
        this.modelID = id;
        this.iconAsc = this.createSortASCIcon();
        this.iconDesc = this.createSortDESCIcon();
        this.initModel();
        this.replaceDelayer = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("tableCellEditor".equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() == null) {
                    ExtTable ltable = ExtTableModel.this.getTable();
                    if (ltable != null) {
                        ltable.removePropertyChangeListener(this);
                    }
                    ExtTableModel.this._replaceTableData(ExtTableModel.this.delayedNewTableData, false);
                }
            }
        };
    }

    protected Icon createSortDESCIcon() {
        return ExtTableIcon.TABLE_SORT_DESC.get(6);
    }

    protected Icon createSortASCIcon() {
        return ExtTableIcon.TABLE_SORT_ASC.get(6);
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        this.autoColumnWidth();
        super.fireTableChanged(e);
    }

    protected void autoColumnWidth() {
        try {
            if (this.getTable() == null) {
                return;
            }
            if (!this.isAutoWidthEnabled()) {
                return;
            }
            HashMap<ExtColumn<E>, Integer> map = new HashMap<ExtColumn<E>, Integer>();
            List<E> elements = this.getElements();
            for (int i = 0; i < elements.size(); ++i) {
                E e = elements.get(i);
                for (ExtColumn<E> column : this.getColumns()) {
                    int wi;
                    Dimension c;
                    if (!column.isAutoWidthEnabled() || !column.isResizable()) continue;
                    Integer width = (Integer)map.get(column);
                    if (width == null) {
                        width = column.getMinWidth();
                        map.put(column, width);
                    }
                    if ((c = column.getCellSizeEstimation(e, i)) == null || (wi = c.width) <= width) continue;
                    map.put(column, wi);
                }
            }
            for (Map.Entry es : map.entrySet()) {
                int adjusted = ((ExtColumn)es.getKey()).adjustWidth((Integer)es.getValue());
                if (adjusted <= 0) {
                    ((ExtColumn)es.getKey()).setForcedWidth(adjusted);
                    continue;
                }
                int max = ((ExtColumn)es.getKey()).getMaxWidth();
                int min = ((ExtColumn)es.getKey()).getMinWidth();
                if (max > 0) {
                    adjusted = Math.min(adjusted, ((ExtColumn)es.getKey()).getMaxWidth());
                }
                if (min > 0) {
                    adjusted = Math.max(adjusted, ((ExtColumn)es.getKey()).getMinWidth());
                }
                ((ExtColumn)es.getKey()).setForcedWidth(adjusted);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void _fireTableStructureChanged(List<E> newtableData, boolean refreshSort) {
        if (this.isDebugTableModel() && SwingUtilities.isEventDispatchThread()) {
            LogV3.log(new WTFException("_fireTableStructureChanged inside EDT! "));
        }
        List<E> tableData = refreshSort ? this.refreshSort(newtableData) : this.refreshUnSort(newtableData);
        this._replaceTableData(tableData, true);
    }

    protected void _replaceTableData(final List<E> newTableData, final boolean checkEditing) {
        if (newTableData == null) {
            return;
        }
        new EDTRunner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void runInEDT() {
                boolean replaceNow;
                if (ExtTableModel.this.tableStructureChanging.getAndSet(false)) {
                    throw new IllegalStateException("_replaceTableData within _replaceTableData is forbidden!");
                }
                ExtTable ltable = ExtTableModel.this.getTable();
                boolean bl = replaceNow = !checkEditing || ltable == null || !ltable.isEditing();
                if (replaceNow) {
                    try {
                        if (ltable != null) {
                            if (ExtTableModel.this.replaceDelayerSet) {
                                ExtTableModel.this.replaceDelayerSet = false;
                                ExtTableModel.this.delayedNewTableData = null;
                                ltable.removePropertyChangeListener(ExtTableModel.this.replaceDelayer);
                            }
                            ListSelectionModel s = ltable.getSelectionModel();
                            boolean adjusting = s.getValueIsAdjusting();
                            int leadIndex = -1;
                            int anchorIndex = -1;
                            Object leadObject = null;
                            Object anchorObject = null;
                            boolean hadSelectedObjects = ExtTableModel.this.hasSelectedObjects();
                            BitSet selectedRowsBitSet = new BitSet();
                            try {
                                int[] rows;
                                List selectedObjects;
                                if (newTableData.size() > 0) {
                                    selectedObjects = ExtTableModel.this.getSelectedObjects(-1, selectedRowsBitSet);
                                    leadIndex = s.getLeadSelectionIndex();
                                    anchorIndex = s.getAnchorSelectionIndex();
                                    leadObject = adjusting && leadIndex >= 0 ? (Object)ExtTableModel.this.getObjectbyRow(leadIndex) : null;
                                    Object e = anchorObject = adjusting && anchorIndex >= 0 ? (Object)ExtTableModel.this.getObjectbyRow(anchorIndex) : null;
                                    if (adjusting && ExtTableModel.this.isDebugTableModel()) {
                                        System.out.println("before:leadIndex=" + leadIndex + "->" + leadObject + "|anchorIndex=" + anchorIndex + "->" + anchorObject);
                                    }
                                } else {
                                    selectedObjects = null;
                                }
                                List oldTableData = ExtTableModel.this.getTableData();
                                ExtTableModel.this.tableStructureChanging.set(true);
                                ExtTableModel.this.setTableData(newTableData);
                                try {
                                    ExtTableModel.this.tableSelectionClearing.set(true);
                                    ExtTableModel.this.fireTableStructureChanged();
                                }
                                finally {
                                    ExtTableModel.this.tableSelectionClearing.set(false);
                                }
                                if (!ExtTableModel.this.postSetTableData(newTableData) || ExtTableModel.this.getRowCount() <= 0 || selectedObjects == null || selectedObjects.size() <= 0) return;
                                int[] ret = ExtTableModel.this.setSelectedObjects(selectedObjects);
                                if (ret[0] == -1 && (rows = ExtTableModel.this.guessSelectedRows(oldTableData, leadIndex, anchorIndex, selectedRowsBitSet)) != null && rows.length > 0) {
                                    ret = ExtTableModel.this.setSelectedRows(rows);
                                }
                                if (!adjusting || ret[0] == -1 && ret[0] == ret[1]) return;
                                leadIndex = leadObject != null ? ExtTableModel.this.getRowforObject(leadObject) : -1;
                                anchorIndex = anchorObject != null ? ExtTableModel.this.getRowforObject(anchorObject) : -1;
                                if (ExtTableModel.this.isDebugTableModel()) {
                                    System.out.println("after:leadIndex=" + leadIndex + "->" + leadObject + "|anchorIndex=" + anchorIndex + "->" + anchorObject);
                                }
                                if (leadIndex < 0 || anchorIndex < 0) return;
                                s.setValueIsAdjusting(true);
                                int begin = leadIndex;
                                int end = anchorIndex;
                                if (end < begin) {
                                    begin = anchorIndex;
                                    end = leadIndex;
                                }
                                boolean selectionHole = false;
                                for (int index = begin; index <= end; ++index) {
                                    if (s.isSelectedIndex(index)) continue;
                                    selectionHole = true;
                                    break;
                                }
                                if (ExtTableModel.this.isDebugTableModel()) {
                                    if (!selectionHole) {
                                        System.out.println("No holes in selection: from " + begin + " to " + end);
                                    } else {
                                        System.out.println("Holes in selection: from " + begin + " to " + end);
                                    }
                                }
                                s.setAnchorSelectionIndex(anchorIndex);
                                s.setLeadSelectionIndex(leadIndex);
                                return;
                            }
                            finally {
                                if (hadSelectedObjects && !ExtTableModel.this.hasSelectedObjects()) {
                                    s.setValueIsAdjusting(true);
                                    s.setAnchorSelectionIndex(1);
                                    s.setValueIsAdjusting(false);
                                }
                            }
                        }
                        ExtTableModel.this.tableStructureChanging.set(true);
                        ExtTableModel.this.setTableData(newTableData);
                        try {
                            ExtTableModel.this.tableSelectionClearing.set(true);
                            ExtTableModel.this.fireTableStructureChanged();
                        }
                        finally {
                            ExtTableModel.this.tableSelectionClearing.set(false);
                        }
                        ExtTableModel.this.postSetTableData(newTableData);
                        return;
                    }
                    finally {
                        ExtTableModel.this.tableStructureChanging.set(false);
                    }
                }
                if (ltable == null) return;
                ExtTableModel.this.delayedNewTableData = newTableData;
                if (ExtTableModel.this.replaceDelayerSet) return;
                ExtTableModel.this.replaceDelayerSet = true;
                ltable.addPropertyChangeListener(ExtTableModel.this.replaceDelayer);
            }
        };
    }

    protected int[] guessSelectedRows(List<E> oldTableData, int leadIndex, int anchorIndex, BitSet selectedRowsBitSet) {
        return null;
    }

    public void addAllElements(Collection<E> entries) {
        ArrayList<E> newdata = new ArrayList<E>(this.getTableData());
        for (E n : entries) {
            newdata.add(n);
        }
        this._fireTableStructureChanged(newdata, true);
    }

    public void addAllElements(E ... files) {
        if (files == null || files.length == 0) {
            return;
        }
        ArrayList<E> newdata = new ArrayList<E>(this.getTableData());
        for (E n : files) {
            newdata.add(n);
        }
        this._fireTableStructureChanged(newdata, true);
    }

    public void addColumn(ExtColumn<E> e) {
        e.setModel(this);
        ++this.columnModifications;
        this.columns.add(e);
    }

    public void addColumn(ExtColumn<E> e, int index) {
        e.setModel(this);
        ++this.columnModifications;
        this.columns.add(index, e);
    }

    public void addElement(E at) {
        ArrayList<E> newdata = new ArrayList<E>(this.getTableData());
        newdata.add(at);
        this._fireTableStructureChanged(newdata, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtComponentRowHighlighter(ExtComponentRowHighlighter<E> h) {
        Object object = this.highlighterLock;
        synchronized (object) {
            ArrayList<ExtComponentRowHighlighter<ExtComponentRowHighlighter<ExtComponentRowHighlighter<E>>>> newextComponentRowHighlighters = new ArrayList<ExtComponentRowHighlighter<ExtComponentRowHighlighter<ExtComponentRowHighlighter<E>>>>(this.extComponentRowHighlighters);
            newextComponentRowHighlighters.add(h);
            Collections.sort(newextComponentRowHighlighters, new Comparator<ExtComponentRowHighlighter<E>>(){

                @Override
                public int compare(ExtComponentRowHighlighter<E> o1, ExtComponentRowHighlighter<E> o2) {
                    return CompareUtils.compareInt(o1.getPriority(), o2.getPriority());
                }
            });
            this.extComponentRowHighlighters = newextComponentRowHighlighters;
        }
    }

    public void clear() {
        this._replaceTableData(new ArrayList(), true);
    }

    public void clearSelection() {
        ListSelectionModel selectionModel;
        ExtTable<E> ltable = this.getTable();
        if (ltable != null && (selectionModel = ltable.getSelectionModel()) != null) {
            selectionModel.clearSelection();
        }
    }

    public boolean contains(E at) {
        return this.getTableData().contains(at);
    }

    public int countSelectedObjects() {
        ExtTable<E> ltable = this.getTable();
        if (ltable == null) {
            return 0;
        }
        return ltable.getSelectedRowCount();
    }

    public TableCellEditor getCelleditorByColumn(int modelColumnIndex) {
        return this.getExtColumnByModelIndex(modelColumnIndex);
    }

    public ExtColumn<E> getCellrendererByColumn(int columnIndex) {
        return this.columns.get(Math.max(0, columnIndex));
    }

    public <T extends ExtColumn<E>> T getColumnByClass(Class<T> clazz) {
        try {
            for (ExtColumn<E> column : this.columns) {
                if (!column.getClass().equals(clazz)) continue;
                return (T)column;
            }
        }
        catch (Exception e) {
            LogV3.log(e);
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(Math.max(0, column)).getName();
    }

    public List<ExtColumn<E>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    protected ExtColumn<E> getDefaultSortColumn() {
        for (ExtColumn<Object> extColumn : this.columns) {
            if (!extColumn.isSortable(null)) continue;
            return extColumn;
        }
        return null;
    }

    public NumberFormat getNumberFormat(ExtColumn<E> column) {
        return column.getDefaultNumberFormat();
    }

    public E getElementAt(int i) {
        List<E> ltableData = this.getTableData();
        if (i >= 0 && i < ltableData.size()) {
            return ltableData.get(i);
        }
        return null;
    }

    public List<E> getElements() {
        return new ArrayList<E>(this.getTableData());
    }

    public ExtTableModelEventSender getEventSender() {
        if (this.eventSender == null) {
            this.eventSender = new ExtTableModelEventSender();
            this.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ExtTableModel.this.eventSender.fireEvent(new ExtTableModelEventWrapper(ExtTableModel.this, e));
                }
            });
        }
        return this.eventSender;
    }

    public ExtColumn<E> getExtColumnByModelIndex(int modelColumnIndex) {
        return this.columns.get(Math.max(0, modelColumnIndex));
    }

    public ExtColumn<E> getExtColumnByViewIndex(int viewColumnIndex) {
        return this.getExtColumnByModelIndex(this.getTable().convertColumnIndexToModel(viewColumnIndex));
    }

    public List<ExtComponentRowHighlighter<E>> getExtComponentRowHighlighters() {
        return this.extComponentRowHighlighters;
    }

    public int getExtViewColumnCount() {
        return this.getTable().getColumnCount();
    }

    public String getModelID() {
        return this.modelID;
    }

    public String getNextSortIdentifier(String sortOrderIdentifier) {
        if (sortOrderIdentifier == null || sortOrderIdentifier.equals("DESC")) {
            return "ASC";
        }
        return "DESC";
    }

    public E getObjectbyRow(int index) {
        return this.getElementAt(index);
    }

    @Override
    public int getRowCount() {
        return this.getTableData().size();
    }

    public int getRowforObject(E o) {
        return this.getTableData().indexOf(o);
    }

    public List<E> getSelectedObjects() {
        return this.getSelectedObjects(-1);
    }

    public List<E> getSelectedObjects(int maxItems) {
        return this.getSelectedObjects(maxItems, null);
    }

    public List<E> getSelectedObjects(int maxItems, BitSet selectedRows) {
        ExtTable<E> ltable = this.getTable();
        ArrayList<E> ret = new ArrayList<E>();
        if (ltable == null || this.tableSelectionClearing.get()) {
            return ret;
        }
        ListSelectionModel selectionModel = ltable.getSelectionModel();
        if (selectionModel == null || selectionModel.isSelectionEmpty()) {
            return ret;
        }
        List<E> ltableData = this.getTableData();
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1) {
            return ret;
        }
        if (iMin >= ltableData.size() || iMax >= ltableData.size()) {
            throw new IllegalStateException("SelectionModel and TableData missmatch! IMin:" + iMin + "|IMax:" + iMax + "|TableSize:" + ltableData.size());
        }
        if (maxItems < 0) {
            for (int i = iMin; i <= iMax; ++i) {
                E elem;
                if (!selectionModel.isSelectedIndex(i) || (elem = ltableData.get(i)) == null) continue;
                if (selectedRows != null) {
                    selectedRows.set(i);
                }
                ret.add(elem);
            }
        } else {
            for (int i = iMin; i <= iMax; ++i) {
                E elem;
                if (!selectionModel.isSelectedIndex(i) || (elem = ltableData.get(i)) == null) continue;
                if (selectedRows != null) {
                    selectedRows.set(i);
                }
                ret.add(elem);
                if (ret.size() <= maxItems) {
                    continue;
                }
                break;
            }
        }
        return ret;
    }

    public ExtColumn<E> getSortColumn() {
        return this.sortColumn;
    }

    public Icon getSortIcon(String sortOrderIdentifier) {
        if (sortOrderIdentifier == null || sortOrderIdentifier == "ASC") {
            return this.iconAsc;
        }
        return this.iconDesc;
    }

    protected Storage getStorage() {
        return JSonStorage.getPlainStorage("ExtTable_" + this.getModelID());
    }

    public ExtTable<E> getTable() {
        return this.table;
    }

    public List<E> getTableData() {
        return this.tableData;
    }

    public List<E> getTableObjects() {
        return new ArrayList<E>(this.getTableData());
    }

    public E getValueAt(int rowIndex, int columnIndex) {
        return this.getElementAt(rowIndex);
    }

    public boolean hasSelectedObjects() {
        return this.hasMinimumSelectedObjects(1);
    }

    public boolean hasMinimumSelectedObjects(int num) {
        ExtTable<E> ltable = this.getTable();
        if (ltable == null || this.isTableSelectionClearing()) {
            return false;
        }
        ListSelectionModel selectionModel = ltable.getSelectionModel();
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1 || iMax - iMin + 1 < num) {
            return false;
        }
        int count = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!selectionModel.isSelectedIndex(i) || ++count != num) continue;
            return true;
        }
        return false;
    }

    protected abstract void initColumns();

    protected void initModel() {
        ExtColumn<E> defSortColumn;
        this.initColumns();
        for (ExtColumn<E> c : this.getColumns()) {
            if (!c.isAutoWidthEnabled()) continue;
            this.autoWidthEnabled = true;
            break;
        }
        String columnId = (defSortColumn = this.getDefaultSortColumn()) == null ? null : defSortColumn.getID();
        String columnSortMode = null;
        if (this.isSortStateSaverEnabled()) {
            columnId = this.getStorage().get(SORTCOLUMN_KEY, columnId);
            columnSortMode = this.getStorage().get(SORT_ORDER_ID_KEY, null);
            if (columnSortMode != null) {
                if (columnSortMode.equals("ASC")) {
                    columnSortMode = "ASC";
                } else if (columnSortMode.equals("DESC")) {
                    columnSortMode = "DESC";
                }
            }
        }
        if (columnId != null) {
            for (ExtColumn<E> col : this.columns) {
                if (!col.getID().equals(columnId)) continue;
                col.setSortOrderIdentifier(columnSortMode);
                this.sortColumn = col;
                break;
            }
        }
    }

    public boolean isAutoWidthEnabled() {
        return this.autoWidthEnabled;
    }

    public void setAutoWidthEnabled(boolean autoWidthEnabled) {
        this.autoWidthEnabled = autoWidthEnabled;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).isCellEditable(rowIndex, columnIndex);
    }

    public boolean isDebugTableModel() {
        return this.debugTableModel;
    }

    public boolean isHidable(int column) {
        ExtColumn<E> col = this.getExtColumnByModelIndex(column);
        try {
            return col.isHidable();
        }
        catch (Exception e) {
            LogV3.log(e);
            return true;
        }
    }

    protected boolean isSortStateSaverEnabled() {
        return true;
    }

    public boolean isTableSelectionClearing() {
        return this.tableSelectionClearing.get();
    }

    public boolean isTableStructureChanging() {
        return this.tableStructureChanging.get();
    }

    public boolean isColumnVisible(int column) {
        ExtColumn<E> col = this.getExtColumnByModelIndex(column);
        return this.isColumnVisible(col);
    }

    public boolean isColumnVisible(ExtColumn<E> col) {
        try {
            if (col == null) {
                return false;
            }
            return col.isVisible(this.getTable().getColumnStore("VISABLE_COL_", col.getID(), col.isDefaultVisible()));
        }
        catch (Exception e) {
            LogV3.log(e);
            return true;
        }
    }

    public boolean move(List<E> transferData, int dropRow) {
        try {
            ArrayList<E> newdata = new ArrayList<E>(this.getTableData().size());
            ArrayList<E> before = new ArrayList<E>(this.getTableData().subList(0, dropRow));
            ArrayList<E> after = new ArrayList<E>(this.getTableData().subList(dropRow, this.getTableData().size()));
            before.removeAll(transferData);
            after.removeAll(transferData);
            newdata.addAll(before);
            newdata.addAll(transferData);
            newdata.addAll(after);
            this._fireTableStructureChanged(newdata, true);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    protected boolean postSetTableData(List<E> newtableData) {
        return true;
    }

    public void refreshSort() {
        this._fireTableStructureChanged(this.getTableObjects(), true);
    }

    public List<E> refreshSort(List<E> data) {
        if (this.isDebugTableModel() && SwingUtilities.isEventDispatchThread()) {
            LogV3.log(new WTFException("refreshSort inside EDT! "));
        }
        boolean sameTable = false;
        if (data == this.getTableData()) {
            sameTable = true;
        }
        List<E> ret = this.sort(data, this.sortColumn);
        if (this.isDebugTableModel() && this.getTableData() == ret && sameTable) {
            LogV3.log(new WTFException("WARNING: sorting on live backend!"));
        }
        return ret;
    }

    public List<E> refreshUnSort(List<E> data) {
        return data;
    }

    public void removeAll(List<E> selectedObjects) {
        ArrayList<E> tmp = new ArrayList<E>(this.getTableData());
        tmp.removeAll(selectedObjects);
        this._fireTableStructureChanged(tmp, true);
    }

    public E searchNextObject(int startRow, String ret, boolean caseSensitive, boolean regex) {
        int i;
        Pattern p;
        if (!regex) {
            String[] pats = ret.split("\\*");
            StringBuilder pattern = new StringBuilder();
            for (String pp : pats) {
                if (pattern.length() > 0) {
                    pattern.append(".*?");
                }
                pattern.append(Pattern.quote(pp));
            }
            p = Pattern.compile(".*?" + pattern.toString() + ".*?", !caseSensitive ? 2 : 32);
        } else {
            p = Pattern.compile(".*?" + ret + ".*?", !caseSensitive ? 2 : 32);
        }
        List<E> ltableData = this.getTableData();
        for (i = startRow; i < ltableData.size(); ++i) {
            for (int c = 0; c < this.columns.size(); ++c) {
                if (!this.columns.get(c).matchSearch(ltableData.get(i), p)) continue;
                return ltableData.get(i);
            }
        }
        for (i = 0; i < startRow; ++i) {
            for (int c = 0; c < this.columns.size(); ++c) {
                if (!this.columns.get(c).matchSearch(ltableData.get(i), p)) continue;
                return ltableData.get(i);
            }
        }
        return null;
    }

    public void setColumnVisible(ExtColumn<E> column, boolean visible) {
        if (column == null) {
            return;
        }
        if (this.isColumnVisible(column) != visible) {
            try {
                this.getTable().getStorage().put(this.getTable().getColumnStoreKey("VISABLE_COL_", column.getID()), visible);
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            this.getTable().updateColumns();
        }
    }

    public void setColumnVisible(int modelColumnIndex, boolean visible) {
        this.setColumnVisible(this.getExtColumnByModelIndex(modelColumnIndex), visible);
    }

    public void setDebugTableModel(boolean debugTableModel) {
        this.debugTableModel = debugTableModel;
    }

    public void setSelectedObject(E latest) {
        if (latest == null) {
            this.setSelectedObjects(null);
        } else {
            ArrayList<E> objects = new ArrayList<E>();
            objects.add(latest);
            this.setSelectedObjects(objects);
        }
    }

    public int[] setSelectedObjects(final Collection<E> selections) {
        return (int[])new EDTHelper<int[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] edtRun() {
                ExtTable ltable = ExtTableModel.this.getTable();
                if (ltable == null) {
                    return new int[]{-1, -1};
                }
                ListSelectionModel s = ltable.getSelectionModel();
                boolean isValueAdjusting = s.getValueIsAdjusting();
                s.setValueIsAdjusting(true);
                try {
                    if (ExtTableModel.this.hasSelectedObjects()) {
                        ExtTableModel.this.clearSelection();
                    }
                    List ltableData = ExtTableModel.this.getTableData();
                    if (selections == null || selections.size() == 0 || ltableData.size() == 0) {
                        int[] nArray = new int[]{-1, -1};
                        return nArray;
                    }
                    int tableDataSize = ltableData.size();
                    int selectionSize = selections.size();
                    int[] selectedRows = new int[selectionSize];
                    int selectedRowsCounter = 0;
                    int lastOptimizedIndex = 0;
                    ArrayList unoptimizedSelection = new ArrayList();
                    int[] maxUnoptimizedIndices = new int[selectionSize];
                    int unoptimizedIndex = 0;
                    block5: for (Object obj : selections) {
                        for (int tableIndex = lastOptimizedIndex; tableIndex < tableDataSize; ++tableIndex) {
                            if (obj != ltableData.get(tableIndex)) continue;
                            lastOptimizedIndex = tableIndex;
                            selectedRows[selectedRowsCounter++] = tableIndex;
                            continue block5;
                        }
                        unoptimizedSelection.add(obj);
                        maxUnoptimizedIndices[unoptimizedIndex++] = lastOptimizedIndex;
                    }
                    int unoptimizedSize = unoptimizedSelection.size();
                    block7: for (int findIndex = 0; findIndex < unoptimizedSize; ++findIndex) {
                        Object obj = unoptimizedSelection.get(findIndex);
                        int max = maxUnoptimizedIndices[findIndex];
                        for (int tableIndex = 0; tableIndex < max; ++tableIndex) {
                            if (obj != ltableData.get(tableIndex)) continue;
                            selectedRows[selectedRowsCounter++] = tableIndex;
                            continue block7;
                        }
                    }
                    if (selectedRowsCounter == 0) {
                        int[] findIndex = new int[]{-1, -1};
                        return findIndex;
                    }
                    selectedRows = Arrays.copyOf(selectedRows, selectedRowsCounter);
                    Arrays.sort(selectedRows);
                    int index0 = -1;
                    int index1 = -1;
                    for (int selectedRowIndex = 0; selectedRowIndex < selectedRowsCounter; ++selectedRowIndex) {
                        int row = selectedRows[selectedRowIndex];
                        if (index0 < 0) {
                            index0 = row;
                            continue;
                        }
                        if (index1 < 0) {
                            if (row == index0 + 1) {
                                index1 = row;
                                continue;
                            }
                            ltable.addRowSelectionInterval(index0, index0);
                            index0 = row;
                            continue;
                        }
                        if (row == index1 + 1) {
                            index1 = row;
                            continue;
                        }
                        ltable.addRowSelectionInterval(index0, index1);
                        index0 = row;
                        index1 = -1;
                    }
                    if (index0 >= 0) {
                        if (index1 < 0) {
                            ltable.addRowSelectionInterval(index0, index0);
                        } else {
                            ltable.addRowSelectionInterval(index0, index1);
                        }
                    }
                    int[] nArray = new int[]{selectedRows[0], selectedRows[selectedRowsCounter - 1]};
                    return nArray;
                }
                finally {
                    s.setValueIsAdjusting(isValueAdjusting);
                }
            }
        }.getReturnValue();
    }

    public int[] setSelectedRows(final int[] rows) {
        return (int[])new EDTHelper<int[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] edtRun() {
                ExtTable ltable = ExtTableModel.this.getTable();
                ListSelectionModel s = ltable.getSelectionModel();
                boolean isValueAdjusting = s.getValueIsAdjusting();
                s.setValueIsAdjusting(true);
                try {
                    if (ExtTableModel.this.hasSelectedObjects()) {
                        ExtTableModel.this.clearSelection();
                    }
                    if (rows == null || rows.length == 0 || ExtTableModel.this.getTableData().size() == 0) {
                        int[] nArray = new int[]{-1, -1};
                        return nArray;
                    }
                    int[] selectedRows = (int[])rows.clone();
                    Arrays.sort(selectedRows);
                    int index0 = -1;
                    int index1 = -1;
                    int rowIndex = 0;
                    for (rowIndex = 0; rowIndex < selectedRows.length; ++rowIndex) {
                        int row = selectedRows[rowIndex];
                        if (index0 < 0) {
                            index0 = row;
                            continue;
                        }
                        if (index1 < 0) {
                            if (row == index0 + 1) {
                                index1 = row;
                                continue;
                            }
                            ltable.addRowSelectionInterval(index0, index0);
                            index0 = row;
                            continue;
                        }
                        if (row == index1 + 1) {
                            index1 = row;
                            continue;
                        }
                        ltable.addRowSelectionInterval(index0, index1);
                        index0 = row;
                        index1 = -1;
                    }
                    if (index0 >= 0) {
                        if (index1 < 0) {
                            ltable.addRowSelectionInterval(index0, index0);
                        } else {
                            ltable.addRowSelectionInterval(index0, index1);
                        }
                    }
                    int[] nArray = new int[]{selectedRows[0], selectedRows[selectedRows.length - 1]};
                    return nArray;
                }
                finally {
                    s.setValueIsAdjusting(isValueAdjusting);
                }
            }
        }.getReturnValue();
    }

    public void setSortColumn(ExtColumn<E> e) {
        this.sortColumn = e;
    }

    protected void setTable(ExtTable<E> table) {
        this.table = table;
        if (this.isUpdateTableColumnsOnTableResize()) {
            table.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    for (ExtColumn c : ExtTableModel.this.getColumns()) {
                        c.onTableResized();
                    }
                    ExtTableModel.this.autoColumnWidth();
                }
            });
        }
    }

    protected boolean isUpdateTableColumnsOnTableResize() {
        return false;
    }

    protected void setTableData(List<E> data) {
        this.tableData = data;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.columns.get(columnIndex).setValueAt(value, rowIndex, columnIndex);
    }

    public List<E> sort(List<E> data, ExtColumn<E> column) {
        this.sortColumn = column;
        if (column != null) {
            String id = column.getSortOrderIdentifier();
            try {
                this.getStorage().put(SORT_ORDER_ID_KEY, id);
                this.getStorage().put(SORTCOLUMN_KEY, column.getID());
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            try {
                Collections.sort(data, column.getRowSorter());
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        } else {
            try {
                this.getStorage().put(SORT_ORDER_ID_KEY, (String)null);
                this.getStorage().put(SORTCOLUMN_KEY, (String)null);
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        return data;
    }

    protected int findFirstSelectedRow(ListSelectionModel s) {
        int min = s.getMinSelectionIndex();
        return min;
    }
}

