/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import javax.swing.Icon;
import javax.swing.JComponent;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.swing.renderer.RenderLabel;

public abstract class ExtIconColumn<E>
extends ExtColumn<E> {
    private RenderLabel renderer = new RenderLabel(){
        private static final long serialVersionUID = 3886046725960279287L;

        @Override
        public boolean isVisible() {
            return false;
        }
    };
    private static final long serialVersionUID = -5751315870107507714L;

    public ExtIconColumn(String name) {
        this(name, null);
    }

    public ExtIconColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.initIcons();
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                int h2;
                Icon ic1 = ExtIconColumn.this.getIcon(o1);
                Icon ic2 = ExtIconColumn.this.getIcon(o2);
                int h1 = ic1 == null ? 0 : ic1.hashCode();
                int n = h2 = ic2 == null ? 0 : ic2.hashCode();
                if (h1 == h2) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return h1 > h2 ? -1 : 1;
                }
                return h2 > h1 ? -1 : 1;
            }
        });
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.renderer.setIcon(this.getIcon(value));
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public int getDefaultWidth() {
        return 30;
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return null;
    }

    protected abstract Icon getIcon(E var1);

    @Override
    public int getMaxWidth() {
        return this.getDefaultWidth();
    }

    @Override
    public int getMinWidth() {
        return this.getDefaultWidth();
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    @Override
    protected String getTooltipText(E obj) {
        return null;
    }

    protected void initIcons() {
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public void resetEditor() {
    }

    @Override
    public void resetRenderer() {
        this.renderer.setOpaque(false);
        this.renderer.setHorizontalAlignment(0);
        this.renderer.setBorder(ExtColumn.DEFAULT_BORDER);
    }

    @Override
    public void setValue(Object value, E object) {
    }
}

