/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.appwork.updatesys.client.AccessCallback;
import org.appwork.updatesys.client.DefaultFileAccessHandler;
import org.appwork.updatesys.client.FileAccessType;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.locale.UpdTrans;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.Files17;
import org.appwork.utils.extioexceptions.CouldNotCreateDirectoryExtIOException;
import org.appwork.utils.extioexceptions.CouldNotCreateHardlinkExtIOException;
import org.appwork.utils.extioexceptions.CouldNotDeleteFileExtIOException;
import org.appwork.utils.extioexceptions.CouldNotRenameDirectory;
import org.appwork.utils.extioexceptions.CouldNotRenameFile;
import org.appwork.utils.extioexceptions.FileNotFoundExtIOException;
import org.appwork.utils.os.CrossSystem;

public class DefaultFileAccessNIOHandler
extends DefaultFileAccessHandler {
    public DefaultFileAccessNIOHandler(UpdateClient updateClient) {
        super(updateClient);
    }

    public DefaultFileAccessNIOHandler(UpdateClient updateClient, AccessCallback callback) {
        super(updateClient, callback);
    }

    @Override
    protected void mkDirsInternal(File file) throws ExtIOException {
        try {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            if (file.isFile()) {
                throw new CouldNotCreateDirectoryExtIOException(UpdTrans.I().getErrorCannotCreateFoldersFileExists(), e, file);
            }
            throw new CouldNotCreateDirectoryExtIOException(UpdTrans.I().getErrorCannotCreateFolders(), e, file);
        }
    }

    @Override
    protected void moveImpl(File src, File dest, boolean deleteDest) throws ExtIOException, InterruptedException {
        block12: {
            if (!src.exists()) {
                throw new FileNotFoundExtIOException(UpdTrans.I().getErrorCannotMoveNonExistingFile(src, dest), null, src);
            }
            boolean isDir = src.isDirectory();
            this.mkdirs(dest.getParentFile());
            Path srcPath = this.toPath(src);
            Path destPath = this.toPath(dest);
            try {
                try {
                    this.moveImplInternal(deleteDest, srcPath, destPath);
                }
                catch (AccessDeniedException e) {
                    if (CrossSystem.isWindows()) {
                        this.getUpdateClient().getLogger().info("Apply workaround for java.nio.file.Files.move(" + srcPath.toString() + "," + destPath.toString() + ")");
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ie) {
                            throw Exceptions.addSuppressed(ie, e);
                        }
                        if (src.exists()) {
                            this.moveImplInternal(deleteDest, srcPath, destPath);
                        }
                        break block12;
                    }
                    throw e;
                }
            }
            catch (ClosedByInterruptException e) {
                throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
            }
            catch (IOException e) {
                if (isDir) {
                    throw new CouldNotRenameDirectory(UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dest), (Throwable)e, dest, src);
                }
                throw new CouldNotRenameFile(UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dest), (Throwable)e, dest, src);
            }
            catch (RuntimeException e) {
                throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
            }
        }
    }

    protected void moveImplInternal(boolean deleteDest, Path srcPath, Path destPath) throws IOException, FileAlreadyExistsException, InterruptedException {
        block9: {
            if (deleteDest) {
                int i = 0;
                while (true) {
                    ++i;
                    try {
                        if (Files.exists(destPath, new LinkOption[0]) && Files.isSameFile(srcPath, destPath)) {
                            Files.delete(srcPath);
                            return;
                        }
                        Files.move(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING);
                        break block9;
                    }
                    catch (FileAlreadyExistsException e) {
                        if (i == 5) {
                            throw e;
                        }
                        try {
                            Thread.sleep(i * 100);
                        }
                        catch (InterruptedException ie) {
                            throw Exceptions.addSuppressed(ie, e);
                        }
                    }
                }
            }
            if (Files.exists(destPath, new LinkOption[0]) && Files.isSameFile(srcPath, destPath)) {
                throw new FileAlreadyExistsException(destPath.toString());
            }
            Files.move(srcPath, destPath, new CopyOption[0]);
        }
    }

    @Override
    protected boolean deleteFileIfExistsImpl(File file) throws ExtIOException, InterruptedException {
        try {
            return Files17.deleteIfExists(this.toPath(file));
        }
        catch (ClosedByInterruptException e) {
            throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
        }
        catch (IOException e) {
            if (!file.delete() && file.exists()) {
                throw new CouldNotDeleteFileExtIOException(UpdTrans.I().getErrorCouldNotDeleteFILE(file), e, file);
            }
            return true;
        }
        catch (RuntimeException e) {
            throw new CouldNotDeleteFileExtIOException(UpdTrans.I().getErrorCouldNotDeleteFILE(file), e, file);
        }
    }

    @Override
    public File guessRoot(File file) throws ExtIOException {
        try {
            Path root = Files17.guessRoot(this.toPath(file));
            if (root != null) {
                return root.toFile();
            }
        }
        catch (IOException e) {
            this.getLogger().log(e);
        }
        return super.guessRoot(file);
    }

    @Override
    public long getUsableSpace(File file) throws ExtIOException {
        try {
            Long freeDiskSpace = Files17.getUsableSpace(this.toPath(file));
            if (freeDiskSpace != null) {
                return freeDiskSpace;
            }
        }
        catch (IOException e) {
            this.getLogger().log(e);
        }
        return super.getUsableSpace(file);
    }

    protected Path toPath(File file) throws ExtIOException {
        try {
            return file.toPath();
        }
        catch (InvalidPathException e) {
            throw new ExtIOException(e, ExtIOException.IOExceptionType.LOCAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createHardlink(File src, File dest) throws ExtIOException, InterruptedException {
        this.request(src, FileAccessType.READ);
        try {
            this.request(dest, FileAccessType.WRITE);
            try {
                Path srcPath = this.toPath(src);
                Path destPath = this.toPath(dest);
                this.mkdirs(dest.getParentFile());
                try {
                    Files.createLink(destPath, srcPath);
                }
                catch (ClosedByInterruptException e) {
                    throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
                }
                catch (IOException e) {
                    throw new CouldNotCreateHardlinkExtIOException(null, (Throwable)e, src, dest);
                }
                catch (UnsupportedOperationException e) {
                    throw new CouldNotCreateHardlinkExtIOException(null, (Throwable)e, src, dest);
                }
                catch (RuntimeException e) {
                    throw new CouldNotCreateHardlinkExtIOException(null, (Throwable)e, src, dest);
                }
            }
            catch (Throwable throwable) {
                this.release(dest, FileAccessType.WRITE);
                throw throwable;
            }
            this.release(dest, FileAccessType.WRITE);
        }
        catch (Throwable throwable) {
            this.release(src, FileAccessType.READ);
            throw throwable;
        }
        this.release(src, FileAccessType.READ);
    }
}

