/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.service;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.JSonStorage;
import org.appwork.updatesys.service.RuntimeInfo;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.logging2.LogInterface;

public class ServiceInstallation {
    public static final String FOLDER_NAME_FORMATED = "v\\.(\\d{8}_\\d{6}_\\d+)(_\\d+)?";
    public static final String FOLDERNAME_OLD = "v\\.(\\d+)(_\\d+)?";
    private static final int READ_TIMEOUT_SERVICE = 60000;
    private LogInterface logger;
    private long versionFromName = 0L;
    public final int port;
    public final String accessToken;
    public final File directory;
    private RuntimeInfo runtimeInfo;

    public void setLogger(LogInterface logger) {
        if (logger != null) {
            this.logger = logger;
        }
    }

    public ServiceInstallation(int port2, String accessToken2, File installDir) {
        this.port = port2;
        this.accessToken = accessToken2;
        this.directory = installDir;
        if (this.directory.getName().matches(FOLDERNAME_OLD)) {
            try {
                Matcher matcher = Pattern.compile(FOLDERNAME_OLD).matcher(installDir.getName());
                if (matcher.find()) {
                    String str = matcher.group(1);
                    this.versionFromName = Long.parseLong(str);
                }
            }
            catch (RuntimeException e) {
                this.getLogger().log(e);
            }
        } else if (this.directory.getName().matches(FOLDER_NAME_FORMATED)) {
            try {
                Matcher matcher = Pattern.compile(FOLDER_NAME_FORMATED).matcher(installDir.getName());
                if (matcher.find()) {
                    String str = matcher.group(1);
                    this.versionFromName = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS", Locale.GERMANY).parse(str).getTime();
                }
            }
            catch (ParseException e) {
                this.getLogger().log(e);
            }
            catch (RuntimeException e) {
                this.getLogger().log(e);
            }
        }
    }

    public LogInterface getLogger() {
        LogInterface logger = this.logger;
        if (logger != null) {
            return logger;
        }
        return LogV3.I().getDefaultLogger();
    }

    public File getDirectory() {
        return this.directory;
    }

    public long getVersionFromName() {
        return this.versionFromName;
    }

    public String toString() {
        return " PORT:" + this.port + " DIR: " + this.directory;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceInstallation)) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public long getVersion() {
        return this.runtimeInfo == null ? -1L : this.runtimeInfo.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVersion() {
        this.runtimeInfo = null;
        URLConnection connection = null;
        try {
            this.getLogger().info("Call http://127.0.0.1:" + this.port + "/info?accessToken=" + URLEncode.encodeRFC2396(this.accessToken));
            connection = new URL("http://127.0.0.1:" + this.port + "/info?accessToken=" + URLEncode.encodeRFC2396(this.accessToken)).openConnection(Proxy.NO_PROXY);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(60000);
            try {
                this.runtimeInfo = JSonStorage.restoreFromString(IO.readInputStreamToString(connection.getInputStream()), RuntimeInfo.TYPE);
            }
            finally {
                if (connection != null) {
                    ((HttpURLConnection)connection).disconnect();
                }
            }
            if (this.runtimeInfo == null || this.runtimeInfo.getVersion() < 0L) {
                throw new Exception("Deprecated CS Version:" + this.getVersion());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLogger().log(e);
        }
        catch (Throwable e2) {
            try {
                this.getLogger().info("Call http://127.0.0.1:" + this.port + "/version?&accessToken=" + URLEncode.encodeRFC2396(this.accessToken));
                connection = new URL("http://127.0.0.1:" + this.port + "/version?accessToken=" + URLEncode.encodeRFC2396(this.accessToken)).openConnection(Proxy.NO_PROXY);
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(60000);
                try {
                    String version = IO.readInputStreamToString(connection.getInputStream());
                    ArrayList<String> deployers = new ArrayList<String>();
                    ArrayList<String> providers = new ArrayList<String>();
                    for (String name : version.split("Key\\(s\\) ")) {
                        String keyname = new Regex(name, "([^\\:]*)").getMatch(0);
                        String[] types = new Regex(name, "- (\\S+) Key").getColumn(0);
                        if (types == null) continue;
                        for (String keyType : types) {
                            if ("Provider".equalsIgnoreCase(keyType)) {
                                providers.add(keyname);
                                continue;
                            }
                            if (!"Deployer".equalsIgnoreCase(keyType)) continue;
                            deployers.add(keyname);
                        }
                    }
                    RuntimeInfo ri = new RuntimeInfo();
                    ri.setDeployerKeys(deployers.toArray(new String[0]));
                    ri.setProviderKeys(providers.toArray(new String[0]));
                    this.getLogger().info(this + " Version Response: " + version);
                    String dateString = new Regex(version, "Build Date: (\\d+\\.\\d+\\.\\d+\\s+\\d+:\\d+:\\d+)").getMatch(0).replaceAll("\\s+", " ");
                    try {
                        ri.setVersion(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss", Locale.GERMANY).parse(dateString).getTime());
                        this.runtimeInfo = ri;
                    }
                    catch (ParseException e1) {
                        this.getLogger().exception("Exception in ServiceInstallation.loadVersion", e1);
                    }
                }
                finally {
                    if (connection != null) {
                        ((HttpURLConnection)connection).disconnect();
                    }
                }
            }
            catch (UnsupportedEncodingException e1) {
                this.getLogger().log(Exceptions.addSuppressed(e1, e2));
            }
            catch (MalformedURLException e1) {
                this.getLogger().log(Exceptions.addSuppressed(e1, e2));
            }
            catch (IOException e1) {
                this.getLogger().log(Exceptions.addSuppressed(e1, e2));
            }
            catch (RuntimeException e1) {
                this.getLogger().log(Exceptions.addSuppressed(e1, e2));
            }
        }
    }

    public RuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }
}

