/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.updatesys.service.ConnectService;
import org.appwork.updatesys.service.ConnectServiceWindowsImpl;
import org.appwork.updatesys.service.DummyConnectService;
import org.appwork.updatesys.service.ServiceInstallation;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.zip.ZipIOReader;

public class ServiceUtils {
    public static final String CONNECT_SERVICE_CLASS = "CONNECT_SERVICE_CLASS";
    private static ConnectService CONNECTSERVICE;

    public static ConnectService getConnectService() {
        return CONNECTSERVICE;
    }

    public static List<ServiceInstallation> getInstallations() {
        try {
            return ServiceUtils.getConnectService().getInstallations();
        }
        catch (Throwable e) {
            return new ArrayList<ServiceInstallation>(0);
        }
    }

    public static ServiceInstallation getRunningServiceInstallation() {
        try {
            return ServiceUtils.getConnectService().getRunningServiceInstallation();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static List<File> getPossibleInstallationDirectories() {
        try {
            return ServiceUtils.getConnectService().getPossibleInstallationDirectories();
        }
        catch (Throwable e) {
            return new ArrayList<File>(0);
        }
    }

    public static ServiceInstallation getInstallation(File folder, boolean validRunningInstallationsOnly) {
        try {
            return ServiceUtils.getConnectService().getInstallation(folder, validRunningInstallationsOnly);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void validateConnectServicePackage(File packagePath) throws CSValidationException {
        try {
            if (packagePath == null || !packagePath.isFile()) {
                throw new CSValidationException(packagePath + " does not exist");
            }
            if (!packagePath.getName().toLowerCase(Locale.ROOT).endsWith(".zip")) {
                throw new CSValidationException("no *.zip extension!");
            }
            File sigFile = new File(packagePath.getAbsolutePath() + ".signature");
            if (!sigFile.exists()) {
                throw new CSValidationException("Signature missing: " + sigFile);
            }
            ZipIOReader read = new ZipIOReader(packagePath);
            try {
                if (read.getZipFile("launch.bat") == null) {
                    throw new CSValidationException("no " + packagePath.getName() + "!launch.bat found!");
                }
                if (read.getZipFile("launch.bat").getSize() <= 0L) {
                    throw new CSValidationException("" + packagePath.getName() + "!launch.bat is empty!");
                }
            }
            finally {
                read.close();
            }
        }
        catch (CSValidationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CSValidationException(e);
        }
    }

    static {
        String cls = System.getProperty(CONNECT_SERVICE_CLASS);
        if (cls != null) {
            try {
                CONNECTSERVICE = (ConnectService)Class.forName(cls).newInstance();
            }
            catch (InstantiationException e) {
                throw new WTFException(e);
            }
            catch (IllegalAccessException e) {
                throw new WTFException(e);
            }
            catch (ClassNotFoundException e) {
                throw new WTFException(e);
            }
        }
        if (CONNECTSERVICE == null) {
            switch (CrossSystem.getOSFamily()) {
                case WINDOWS: {
                    CONNECTSERVICE = new ConnectServiceWindowsImpl();
                    break;
                }
                default: {
                    CONNECTSERVICE = new DummyConnectService();
                }
            }
        }
    }

    public static class CSValidationException
    extends Exception {
        public CSValidationException(Throwable e) {
            super(e);
        }

        public CSValidationException(String string) {
            super(string);
        }
    }
}

