/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.appwork.updatesys.transport.exchange.DiskSpaceChanges;
import org.appwork.updatesys.transport.exchange.DownloadMirror;
import org.appwork.updatesys.transport.exchange.DownloadUrlList;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.ServerResponse;
import org.appwork.updatesys.transport.exchange.interfaces.PackageResponseInterface;
import org.appwork.updatesys.transport.exchange.json.PackageJsonResponse;

public class PackageResponse
extends ServerResponse
implements PackageResponseInterface {
    private final int destRevision;
    private final String packageHash;
    private final long packageSize;
    private final long packageContentSize;
    private final boolean packageEncrypted;
    private final DownloadUrlList packageUrls;
    private String changeLogHash = null;
    private long changeLogSize = -1L;
    private long changeLogContentSize = -1L;
    private DownloadUrlList changeLogURLs = null;
    private String changelogText;

    @Override
    public Map<String, DiskSpaceChanges> getDiskSpaceChanges() {
        return null;
    }

    @Override
    public String getChangeLogText() {
        return this.changelogText;
    }

    public PackageResponse(int destRevision, String hash, long size, long contentSize, boolean encrypted, DownloadUrlList urls) {
        super(ResponseStatus.URL);
        this.destRevision = destRevision;
        this.packageHash = hash;
        this.packageSize = size;
        this.packageContentSize = contentSize;
        this.packageEncrypted = encrypted;
        this.packageUrls = urls;
    }

    public PackageResponse(String[] lines) throws NumberFormatException, MalformedURLException {
        super(ResponseStatus.URL);
        this.destRevision = Integer.parseInt(lines[1]);
        this.packageHash = lines[2];
        this.packageSize = Long.parseLong(lines[3]);
        this.packageContentSize = Long.parseLong(lines[4]);
        int parseIndex = 5;
        if (!"0".equals(lines[parseIndex]) && !"1".equals(lines[parseIndex])) {
            String[] changeLogInfos = lines[parseIndex++].split(";");
            this.setChangeLog(changeLogInfos[0], Long.parseLong(changeLogInfos[1]), Long.parseLong(changeLogInfos[2]), DownloadUrlList.parse(Arrays.copyOfRange(changeLogInfos, 3, changeLogInfos.length)));
        }
        this.packageEncrypted = "1".equals(lines[parseIndex++]);
        this.packageUrls = DownloadUrlList.parse(Arrays.copyOfRange(lines, parseIndex++, lines.length));
    }

    @Override
    public long getChangeLogContentSize() {
        return this.changeLogContentSize;
    }

    @Override
    public String getChangeLogHash() {
        return this.changeLogHash;
    }

    @Override
    public long getChangeLogSize() {
        return this.changeLogSize;
    }

    @Override
    public DownloadUrlList getChangeLogUrls() {
        return this.changeLogURLs;
    }

    @Override
    public long getContentSize() {
        return this.packageContentSize;
    }

    @Override
    public int getDestRevision() {
        return this.destRevision;
    }

    @Override
    public Object[] getFields() {
        if (this.changeLogURLs != null && this.changeLogURLs.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.changeLogHash);
            sb.append(";");
            sb.append(this.changeLogSize);
            sb.append(";");
            sb.append(this.changeLogContentSize);
            for (DownloadMirror changeLogMirror : this.changeLogURLs) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(changeLogMirror.toString());
            }
            return new Object[]{this.destRevision, this.packageHash, this.packageSize, this.packageContentSize, sb.toString(), this.packageEncrypted, this.packageUrls};
        }
        return new Object[]{this.destRevision, this.packageHash, this.packageSize, this.packageContentSize, this.packageEncrypted, this.packageUrls};
    }

    @Override
    public String getHash() {
        return this.packageHash;
    }

    @Override
    public long getSize() {
        return this.packageSize;
    }

    @Override
    public DownloadUrlList getUrls() {
        return this.packageUrls;
    }

    @Override
    public boolean isEncrypted() {
        return this.packageEncrypted;
    }

    public void setChangeLog(String hash, long size, long contentSize, DownloadUrlList urls) {
        if (urls != null && urls.size() > 0) {
            this.changeLogURLs = urls;
            this.changeLogHash = hash;
            this.changeLogSize = size;
            this.changeLogContentSize = contentSize;
        } else {
            this.changeLogURLs = null;
            this.changeLogHash = null;
            this.changeLogSize = -1L;
            this.changeLogContentSize = -1L;
        }
    }

    @Override
    public void setChangeLogText(String txt) {
        this.changelogText = txt;
    }

    @Override
    public List<String> getUpdateFlags() {
        return null;
    }

    @Override
    public String getRevisionName() {
        return null;
    }

    @Override
    public PackageJsonResponse toJsonVariant() {
        return new PackageJsonResponse(this);
    }

    @Override
    public long getDownloadID() {
        return -1L;
    }
}

