/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.utils.ClassUsesDeepEquals;
import org.appwork.utils.ClassUsesDeepHashCode;
import org.appwork.utils.CompareUtilsHashCodeCalculator;
import org.appwork.utils.Equalator;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.reflection.Clazz;

public class CompareUtils {
    @Deprecated
    public static int compare(int x, int y) {
        return CompareUtils.compareInt(x, y);
    }

    @Deprecated
    public static int compare(long x, long y) {
        return CompareUtils.compareLong(x, y);
    }

    @Deprecated
    public static int compare(boolean x, boolean y) {
        return CompareUtils.compareBoolean(x, y);
    }

    @Deprecated
    public static int compare(double x, double y) {
        return CompareUtils.compareDouble(x, y);
    }

    @Deprecated
    public static int compare(float x, float y) {
        return CompareUtils.compareFloat(x, y);
    }

    public static int compareBoolean(boolean x, boolean y) {
        return x == y ? 0 : (x ? 1 : -1);
    }

    public static int compareInt(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareLong(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareDouble(double x, double y) {
        return Double.compare(x, y);
    }

    public static int compareFloat(float x, float y) {
        return Float.compare(x, y);
    }

    @Deprecated
    public static int compare(Comparable x, Comparable y) {
        return CompareUtils.compareComparable(x, y);
    }

    public static <T> int compareComparable(Comparable<T> x, Comparable<T> y) {
        if (x == y) {
            return 0;
        }
        if (x == null) {
            return -1;
        }
        if (y == null) {
            return 1;
        }
        if (x instanceof Number && y instanceof Number) {
            return CompareUtils.compareNumber((Number)((Object)x), (Number)((Object)y));
        }
        return x.compareTo(y);
    }

    @Deprecated
    public static boolean equals(byte[] hash, byte[] hash2) {
        return Arrays.equals(hash, hash2);
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            return CompareUtils.equalsNumber((Number)a, (Number)b);
        }
        return a.equals(b);
    }

    public static boolean equals(Map<?, ?> a, Map<?, ?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry<?, ?> es : a.entrySet()) {
            if (CompareUtils.equals(es.getValue(), b.get(es.getKey()))) continue;
            return false;
        }
        return false;
    }

    public static boolean equals(Set<?> a, Set<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equalsDeep(Object objectX, Object objectY, Equalator equalator) {
        return CompareUtils.equalsDeep(objectX, objectY, equalator, new HashSet<Couple>());
    }

    public static boolean equalsDeep(Object objectX, Object objectY) {
        return CompareUtils.equalsDeep(objectX, objectY, null, new HashSet<Couple>());
    }

    public static boolean equalsDeep(Object objectX, Object objectY, Equalator customEuualator, HashSet<Couple> dupeCheck) {
        if (objectX == objectY) {
            return true;
        }
        if (objectX == null || objectY == null) {
            return false;
        }
        if (objectX instanceof Number && objectY instanceof Number) {
            return CompareUtils.equalsNumber((Number)objectX, (Number)objectY);
        }
        if (!dupeCheck.add(new Couple(objectX, objectY))) {
            return true;
        }
        if (customEuualator != null) {
            Boolean ret = customEuualator.equals(objectX, objectY);
            if (ret == Boolean.TRUE) {
                return true;
            }
            if (ret == Boolean.FALSE) {
                return false;
            }
        }
        if (!(objectX instanceof ClassUsesDeepEquals) && objectX.equals(objectY)) {
            return true;
        }
        if (ReflectionUtils.isListOrArray(objectX) && ReflectionUtils.isListOrArray(objectY)) {
            Iterator listX = ReflectionUtils.wrapUnmodifiableList(objectX, Object.class);
            List<Object> listY = ReflectionUtils.wrapUnmodifiableList(objectY, Object.class);
            if (listX.size() != listY.size()) {
                return false;
            }
            ListIterator<Object> e1 = listX.listIterator();
            ListIterator<Object> e2 = listY.listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Object o1 = e1.next();
                Object o2 = e2.next();
                if (o1 != null ? CompareUtils.equalsDeep(o1, o2, customEuualator, dupeCheck) : o2 == null) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }
        if (objectX instanceof Set && objectY instanceof Set) {
            if (((Set)objectX).size() != ((Set)objectY).size()) {
                return false;
            }
            block10: for (Map.Entry x : (Set)objectX) {
                for (Object y : (Set)objectY) {
                    if (!CompareUtils.equalsDeep(x, y, customEuualator, dupeCheck)) continue;
                    continue block10;
                }
                return false;
            }
            return true;
        }
        if (objectX instanceof Map && objectY instanceof Map) {
            if (((Map)objectX).size() != ((Map)objectY).size()) {
                return false;
            }
            for (Map.Entry es : ((Map)objectX).entrySet()) {
                Object other = ((Map)objectY).get(es.getKey());
                if (other == null && !((Map)objectY).containsKey(es.getKey())) {
                    return false;
                }
                if (CompareUtils.equalsDeep(es.getValue(), other, customEuualator, dupeCheck)) continue;
                return false;
            }
            return true;
        }
        if (objectX.getClass() == objectY.getClass()) {
            if (Clazz.isPrimitive(objectX.getClass()) || Clazz.isEnum(objectX.getClass()) || Clazz.isString(objectX.getClass())) {
                return false;
            }
            try {
                Method hasEquals;
                if (!(objectX instanceof ClassUsesDeepEquals) && (hasEquals = objectX.getClass().getMethod("equals", Object.class)).getDeclaringClass() != Object.class) {
                    return false;
                }
            }
            catch (NoSuchMethodException e1) {
                throw new WTFException(e1);
            }
            catch (SecurityException e1) {
                throw new WTFException(e1);
            }
            try {
                ClassCache cc = ClassCache.getClassCache(objectX.getClass());
                for (Getter c : cc.getGetter()) {
                    if (CompareUtils.equalsDeep(c.getValue(objectX), c.getValue(objectY), customEuualator, dupeCheck)) continue;
                    return false;
                }
                return true;
            }
            catch (SecurityException e) {
                throw new WTFException(e);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                throw new WTFException(e);
            }
            catch (IllegalAccessException e) {
                throw new WTFException(e);
            }
            catch (InvocationTargetException e) {
                throw new WTFException(e);
            }
        }
        return objectX.equals(objectY);
    }

    public static int compareNumber(Number a, Number b) {
        Class<?> ac = a.getClass();
        Class<?> bc = b.getClass();
        if (ac == Double.class || bc == Double.class) {
            return CompareUtils.compareDouble(a.doubleValue(), b.doubleValue());
        }
        if (ac == Float.class || bc == Float.class) {
            return CompareUtils.compareFloat(a.floatValue(), b.floatValue());
        }
        return CompareUtils.compareLong(a.longValue(), b.longValue());
    }

    public static boolean equalsNumber(Number a, Number b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return CompareUtils.compareNumber(a, b) == 0;
    }

    public static int hashCodeDeep(Object obj) {
        return CompareUtils.hashCodeDeep(obj, null);
    }

    public static int hashCodeDeep(Object obj, CompareUtilsHashCodeCalculator hashCode) {
        if (obj == null) {
            return 0;
        }
        try {
            obj.getClass().getDeclaredMethod("hashCode", new Class[0]);
            if (!(obj instanceof ClassUsesDeepHashCode)) {
                return obj.hashCode();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (obj instanceof Collection) {
            int ret = 0;
            int i = 0;
            for (Object s : (Collection)obj) {
                ++i;
                if (hashCode != null && hashCode.hasCustomHashCode(s, false)) {
                    ret = hashCode.calcValueHashCode(ret, s);
                    continue;
                }
                ret += i * CompareUtils.hashCodeDeep(s, hashCode);
            }
            return ret;
        }
        if (ReflectionUtils.isListOrArray(obj)) {
            int ret = 0;
            List<Object> listX = ReflectionUtils.wrapUnmodifiableList(obj, Object.class);
            ListIterator<Object> it = listX.listIterator();
            while (it.hasNext()) {
                Object value = it.next();
                if (hashCode != null && hashCode.hasCustomHashCode(value, false)) {
                    ret = hashCode.calcValueHashCode(ret, value);
                    continue;
                }
                ret += it.nextIndex() * CompareUtils.hashCodeDeep(value, hashCode);
            }
            return ret;
        }
        if (obj instanceof Map) {
            int ret = 0;
            for (Map.Entry es : ((Map)obj).entrySet()) {
                Object key = es.getKey();
                ret = hashCode != null && hashCode.hasCustomHashCode(key, true) ? hashCode.calcKeyHashCode(ret, key) : (ret += CompareUtils.hashCodeDeep(key, hashCode));
                Object value = es.getValue();
                if (hashCode != null && hashCode.hasCustomHashCode(value, false)) {
                    ret = hashCode.calcValueHashCode(ret, value);
                    continue;
                }
                ret += CompareUtils.hashCodeDeep(value, hashCode);
            }
            return ret;
        }
        if (hashCode != null && hashCode.hasCustomHashCode(obj, false)) {
            return hashCode.calcValueHashCode(0, obj);
        }
        if (Clazz.isPrimitive(obj.getClass()) || Clazz.isEnum(obj.getClass()) || Clazz.isString(obj.getClass())) {
            return obj.hashCode();
        }
        try {
            ClassCache cc = ClassCache.getClassCache(obj.getClass());
            int ret = 0;
            for (Getter c : cc.getGetter()) {
                String key = c.key;
                ret = hashCode != null && hashCode.hasCustomHashCode(key, true) ? hashCode.calcKeyHashCode(ret, key) : (ret += key.hashCode());
                Object value = c.getValue(obj);
                if (hashCode != null && hashCode.hasCustomHashCode(value, false)) {
                    ret = hashCode.calcValueHashCode(ret, value);
                    continue;
                }
                ret += CompareUtils.hashCodeDeep(value, hashCode);
            }
            return ret;
        }
        catch (SecurityException e) {
            throw new WTFException(e);
        }
        catch (NoSuchMethodException e) {
            throw new WTFException(e);
        }
        catch (IllegalArgumentException e) {
            throw new WTFException(e);
        }
        catch (IllegalAccessException e) {
            throw new WTFException(e);
        }
        catch (InvocationTargetException e) {
            throw new WTFException(e);
        }
    }

    public static Integer tryToCompare(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return CompareUtils.compareNumber((Number)a, (Number)b);
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            try {
                return CompareUtils.compareComparable((Comparable)a, (Comparable)b);
            }
            catch (RuntimeException e) {
                LogV3.exception(CompareUtils.class, e);
            }
        }
        return null;
    }

    private static class Couple {
        private int hashCode = -1;
        private final Object a;
        private final Object b;

        public Couple(Object objectX, Object objectY) {
            this.a = objectX;
            this.b = objectY;
        }

        public int hashCode() {
            int ret = this.hashCode;
            if (ret == -1) {
                ret = 0;
                if (this.a != null) {
                    ret += this.a.hashCode();
                }
                if (this.b != null) {
                    ret += this.b.hashCode();
                }
                this.hashCode = ret;
            }
            return ret;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Couple)) {
                return false;
            }
            return CompareUtils.equals(this.a, ((Couple)obj).a) && CompareUtils.equals(this.b, ((Couple)obj).b);
        }
    }
}

