/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.InterruptedIntentionalException;
import org.appwork.utils.NonInterruptibleRunnable;

public class NonInterruptibleThread
extends Thread {
    protected final AtomicReference<Thread> callingThread = new AtomicReference<Object>(null);
    private static final ThreadPoolExecutor POOL = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 15L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            NonInterruptibleThread ret = new NonInterruptibleThread(r);
            ret.setDaemon(true);
            return ret;
        }
    });

    public Thread getCallingThread() {
        return this.callingThread.get();
    }

    protected NonInterruptibleThread(Runnable r) {
        super(r, "NonInterruptibleThread_" + System.currentTimeMillis());
    }

    private static final StackTraceElement getCaller(Throwable throwable) {
        if (throwable != null && throwable.getStackTrace() != null && throwable.getStackTrace().length > 0) {
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            if (stackTrace.length > 1) {
                return stackTrace[1];
            }
            return stackTrace[0];
        }
        return null;
    }

    public static <T, E extends Exception> T execute(Throwable caller, final NonInterruptibleRunnable<T, E> run) throws E {
        if (Thread.currentThread() instanceof NonInterruptibleThread) {
            try {
                return run.run();
            }
            catch (InterruptedException e) {
                if (!Exceptions.containsInstanceOf(e, InterruptedIntentionalException.class)) {
                    LogV3.defaultLogger().exception("InterruptException in NonInterruptable Thread. This must not happen!", e);
                }
                throw new IllegalStateException(e);
            }
        }
        final StackTraceElement callerMethod = DebugMode.TRUE_IN_IDE_ELSE_FALSE ? NonInterruptibleThread.getCaller(caller) : null;
        final Thread callingThread = Thread.currentThread();
        Future fut = POOL.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    if (callerMethod != null) {
                        Thread.currentThread().setName("NonInterruptibleThread:" + callingThread.getName() + "|" + callingThread.getId() + "=" + callerMethod.getClassName() + "(" + callerMethod.getMethodName() + ":" + callerMethod.getLineNumber() + ")");
                    } else {
                        Thread.currentThread().setName("NonInterruptibleThread:" + callingThread.getName() + "|" + callingThread.getId() + "=Active");
                    }
                    ((NonInterruptibleThread)Thread.currentThread()).callingThread.set(callingThread);
                    Object t = run.run();
                    return t;
                }
                catch (InterruptedException e) {
                    LogV3.defaultLogger().exception("InterruptException in NonInterruptable Thread. This must not happen!", e);
                    throw new IllegalStateException(e);
                }
                finally {
                    Thread.currentThread().setName("NonInterruptibleThread:Idle");
                    if (!((NonInterruptibleThread)Thread.currentThread()).callingThread.compareAndSet(callingThread, null)) {
                        LogV3.log(new IllegalStateException());
                    }
                }
            }
        });
        boolean interruptedFlag = false;
        while (true) {
            try {
                Object t = fut.get();
                return t;
            }
            catch (InterruptedException e) {
                interruptedFlag = true;
                continue;
            }
            catch (ExecutionException e) {
                if (Exceptions.containsInstanceOf(e, InterruptedException.class, ClosedByInterruptException.class)) {
                    if (!Exceptions.containsInstanceOf(e, InterruptedIntentionalException.class)) {
                        LogV3.defaultLogger().exception("InterruptException in NonInterruptable Thread. This must not happen!", e);
                    }
                    throw new IllegalStateException(e);
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw Exceptions.addSuppressed((RuntimeException)e.getCause(), caller);
                }
                throw Exceptions.addSuppressed((Exception)e.getCause(), caller);
            }
            break;
        }
        finally {
            if (interruptedFlag) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void interrupt() {
    }

    public static void execute(final Runnable runnable) {
        Exception caller = new Exception();
        NonInterruptibleThread.execute(caller, new NonInterruptibleRunnable<Void, RuntimeException>(){

            @Override
            public Void run() throws RuntimeException {
                runnable.run();
                return null;
            }
        });
    }

    public static Thread currentOrCallerThread() {
        Thread thread = Thread.currentThread();
        while (thread instanceof NonInterruptibleThread) {
            Thread callingThread = ((NonInterruptibleThread)thread).getCallingThread();
            if (callingThread instanceof NonInterruptibleThread) {
                thread = callingThread;
                continue;
            }
            return callingThread;
        }
        return thread;
    }
}

