/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.concurrent.atomic.AtomicReference;
import org.appwork.utils.NullObject;

public class NullsafeAtomicReference<V> {
    private static final NullObject NULL = new NullObject();
    private static final Object EMPTY = new Object();
    private final AtomicReference<Object> reference = new AtomicReference<Object>(EMPTY);

    public NullsafeAtomicReference() {
    }

    public NullsafeAtomicReference(V initialValue) {
        this.set(initialValue);
    }

    public final boolean compareAndSet(V expect, V update) {
        Object nullSafeUpdate = update;
        if (NULL.equals(nullSafeUpdate)) {
            nullSafeUpdate = NULL;
        }
        if (NULL.equals(expect)) {
            return this.reference.compareAndSet(NULL, nullSafeUpdate) || this.reference.compareAndSet(EMPTY, nullSafeUpdate);
        }
        return this.reference.compareAndSet(expect, nullSafeUpdate);
    }

    public final V get() {
        Object get = this.reference.get();
        if (NULL.equals(get) || EMPTY == get) {
            return null;
        }
        return (V)get;
    }

    public V getAndClear() {
        Object get = this.reference.getAndSet(EMPTY);
        if (NULL.equals(get) || EMPTY == get) {
            return null;
        }
        return (V)get;
    }

    public final V getAndSet(V newValue) {
        Object get;
        Object set = newValue;
        if (NULL.equals(set)) {
            set = NULL;
        }
        if (NULL.equals(get = this.reference.getAndSet(set)) || EMPTY == get) {
            return null;
        }
        return (V)get;
    }

    public boolean isValueSet() {
        return this.reference.get() != EMPTY;
    }

    public final void set(V newValue) {
        if (NULL.equals(newValue)) {
            this.reference.set(NULL);
        } else {
            this.reference.set(newValue);
        }
    }
}

