/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.StringUtils;

public class Regex {
    private Matcher matcher;

    @Deprecated
    public static String escape(String pattern) {
        return Pattern.quote(pattern);
    }

    public static String[] getLines(String arg) {
        if (arg == null) {
            return new String[0];
        }
        String[] temp = arg.split("(\r\n|\r|\n)");
        int tempLength = temp.length;
        String[] output = new String[tempLength];
        for (int i = 0; i < tempLength; ++i) {
            output[i] = temp[i].trim();
        }
        return output;
    }

    @Deprecated
    public static boolean matches(Object str, Pattern pat) {
        return new Regex(str, pat).matches();
    }

    @Deprecated
    public static boolean matches(Object page, String string) {
        return new Regex(page, string).matches();
    }

    public static String replace(String text, String regex, String replacement) {
        return Pattern.compile(regex, 40).matcher(text).replaceAll(replacement);
    }

    public Regex(Matcher matcher) {
        this.matcher = matcher;
    }

    public Regex(Object data, Pattern pattern) {
        this(data instanceof CharSequence ? (CharSequence)data : StringUtils.valueOfOrNull(data), pattern);
    }

    public Regex(Object data, String pattern) {
        this(data instanceof CharSequence ? (CharSequence)data : StringUtils.valueOfOrNull(data), pattern);
    }

    public Regex(Object data, String pattern, int flags) {
        this(data instanceof CharSequence ? (CharSequence)data : StringUtils.valueOfOrNull(data), pattern, flags);
    }

    public Regex(String data, Pattern pattern) {
        this((CharSequence)data, pattern);
    }

    public Regex(CharSequence data, Pattern pattern) {
        if (data != null && pattern != null) {
            this.matcher = pattern.matcher(data);
        }
    }

    public Regex(String data, String pattern) {
        this((CharSequence)data, pattern);
    }

    public Regex(CharSequence data, String pattern) {
        if (data != null && pattern != null) {
            this.matcher = Pattern.compile(pattern, 34).matcher(data);
        }
    }

    public Regex(CharSequence data, String pattern, int flags) {
        if (data != null && pattern != null) {
            this.matcher = Pattern.compile(pattern, flags).matcher(data);
        }
    }

    public Regex(String data, String pattern, int flags) {
        this((CharSequence)data, pattern, flags);
    }

    public int count() {
        Matcher matcher = this.matcher;
        if (matcher == null) {
            return 0;
        }
        matcher.reset();
        int c = 0;
        while (matcher.find()) {
            ++c;
        }
        return c;
    }

    public String[] getColumn(int x) {
        Matcher matcher = this.matcher;
        if (matcher == null) {
            return null;
        }
        ++x;
        matcher.reset();
        ArrayList<String> ar = new ArrayList<String>();
        while (matcher.find()) {
            String tmp = matcher.group(x);
            ar.add(tmp);
        }
        return ar.toArray(new String[ar.size()]);
    }

    public Pattern getPattern() {
        Matcher matcher = this.matcher;
        return matcher != null ? matcher.pattern() : null;
    }

    public String getMatch(int group) {
        Matcher matcher = this.matcher;
        if (matcher != null) {
            matcher.reset();
            if (matcher.find()) {
                String ret = matcher.group(group + 1);
                return ret;
            }
        }
        return null;
    }

    public String getMatch(int entry, int group) {
        Matcher matcher = this.matcher;
        if (matcher != null) {
            matcher.reset();
            ++entry;
            int groupCount = 0;
            while (matcher.find()) {
                if (groupCount == group) {
                    String ret = matcher.group(entry);
                    return ret;
                }
                ++groupCount;
            }
        }
        return null;
    }

    public Matcher getMatcher() {
        Matcher matcher = this.matcher;
        if (matcher != null) {
            matcher.reset();
        }
        return matcher;
    }

    public String[][] getMatches() {
        Matcher matcher = this.matcher;
        if (matcher == null) {
            return null;
        }
        matcher.reset();
        ArrayList<String[]> ar = new ArrayList<String[]>();
        while (matcher.find()) {
            String[] group;
            int c = matcher.groupCount();
            int d = 1;
            if (c == 0) {
                group = new String[c + 1];
                d = 0;
            } else {
                group = new String[c];
            }
            for (int i = d; i <= c; ++i) {
                String tmp;
                group[i - d] = tmp = matcher.group(i);
            }
            ar.add(group);
        }
        return ar.size() == 0 ? new String[][]{} : (String[][])ar.toArray((T[])new String[0][]);
    }

    public String[] getRow(int y) {
        Matcher matcher = this.matcher;
        if (matcher != null) {
            matcher.reset();
            int groupCount = 0;
            while (matcher.find()) {
                if (groupCount == y) {
                    int c = matcher.groupCount();
                    String[] group = new String[c];
                    for (int i = 1; i <= c; ++i) {
                        String tmp;
                        group[i - 1] = tmp = matcher.group(i);
                    }
                    return group;
                }
                ++groupCount;
            }
        }
        return null;
    }

    public boolean patternFind() {
        Matcher matcher = this.matcher;
        if (matcher == null) {
            return false;
        }
        matcher.reset();
        return matcher.find();
    }

    @Deprecated
    public boolean matches() {
        return this.patternFind();
    }

    public boolean patternMatches() {
        Matcher matcher = this.matcher;
        if (matcher == null) {
            return false;
        }
        matcher.reset();
        return matcher.matches();
    }

    @Deprecated
    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        String[][] matches = this.getMatches();
        int matchesLength = matches.length;
        for (int i = 0; i < matchesLength; ++i) {
            String[] match = matches[i];
            int matchLength = match.length;
            for (int j = 0; j < matchLength; ++j) {
                ret.append("match[");
                ret.append(i);
                ret.append("][");
                ret.append(j);
                ret.append("] = ");
                ret.append(match[j]);
                ret.append(System.getProperty("line.separator"));
            }
        }
        Matcher matcher = this.matcher;
        if (matcher != null) {
            matcher.reset();
        }
        return ret.toString();
    }
}

