/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.awfc;

public class AWFCEntry {
    private final byte[] hash;
    private final String path;
    private final boolean isFile;
    private final long size;

    public AWFCEntry(String path, long size, byte[] hash) {
        if (path.endsWith("/")) {
            this.path = path.substring(0, path.length() - 1);
            this.isFile = false;
            this.size = 0L;
            this.hash = null;
        } else {
            if (size < 0L) {
                throw new IllegalArgumentException("Size must be >=0");
            }
            this.size = size;
            this.isFile = true;
            this.path = path;
            this.hash = hash;
        }
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public String toString() {
        return "AWFCEntry [path=" + this.path + ", isFile=" + this.isFile + ", size=" + this.size + "]";
    }
}

