/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.appwork.exceptions.NotSupportedException;
import org.appwork.utils.DebugMode;
import org.appwork.utils.images.AbstractIconPipe;
import org.appwork.utils.images.AlignHorizontal;
import org.appwork.utils.images.AlignVertical;
import org.appwork.utils.images.ModificationType;

public class CroppedIcon
extends AbstractIconPipe {
    private int width;
    private int height;
    private AlignHorizontal alignHorizontal;
    private AlignVertical alignVertical;
    private static final Set<ModificationType> MODIFICATIONS = Collections.unmodifiableSet(new HashSet<ModificationType>(Arrays.asList(ModificationType.SIZE)));

    public CroppedIcon(Icon icon) {
        this(icon, Math.max(icon.getIconHeight(), icon.getIconWidth()));
    }

    public CroppedIcon(Icon icon, int widthAndHeight) {
        this(icon, widthAndHeight, widthAndHeight, null, null);
    }

    public CroppedIcon(Icon icon, int width, int height, AlignHorizontal horizonal, AlignVertical vertical) {
        super(icon);
        this.crop(width, height);
        this.align(horizonal, vertical);
    }

    public CroppedIcon crop(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y, List<Icon> parents) {
        int xOffset = 0;
        int yOffset = 0;
        if (this.alignHorizontal != null) {
            switch (this.alignHorizontal) {
                case CENTER: {
                    yOffset = (this.width - this.delegate.getIconWidth()) / 2;
                    break;
                }
                case LEFT: {
                    xOffset = 0;
                    break;
                }
                case RIGHT: {
                    xOffset = this.width - this.delegate.getIconWidth();
                    break;
                }
                default: {
                    DebugMode.debugger();
                    throw new NotSupportedException();
                }
            }
        }
        if (this.alignVertical != null) {
            switch (this.alignVertical) {
                case CENTER: {
                    yOffset = (this.height - this.delegate.getIconHeight()) / 2;
                    break;
                }
                case TOP: {
                    yOffset = 0;
                    break;
                }
                case BOTTOM: {
                    yOffset = this.height - this.delegate.getIconHeight();
                    break;
                }
                default: {
                    DebugMode.debugger();
                    throw new NotSupportedException();
                }
            }
        }
        this.paintDelegate(c, g, x + xOffset, y + yOffset, parents);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public Icon align(AlignHorizontal horizonal, AlignVertical vertical) {
        if (horizonal == null) {
            horizonal = AlignHorizontal.CENTER;
        }
        if (vertical == null) {
            vertical = AlignVertical.CENTER;
        }
        this.alignHorizontal = horizonal;
        this.alignVertical = vertical;
        return this;
    }

    @Override
    public Set<ModificationType> getModifications() {
        return MODIFICATIONS;
    }
}

