/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images.svg;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.images.ScalableIcon;
import org.appwork.utils.images.svg.SVGFactory;
import org.appwork.utils.images.svg.WeisjJSVG;

public class WeisjJSVGFactory
implements SVGFactory {
    private static Boolean SUPPORTED = null;

    @Override
    public boolean isSupported() {
        try {
            if (SUPPORTED == null) {
                SUPPORTED = JVMVersion.isMinimum(JVMVersion.JAVA_1_8) && Class.forName("com.github.weisj.jsvg.parser.SVGLoader") != null;
            }
            return SUPPORTED;
        }
        catch (ClassNotFoundException e) {
            SUPPORTED = false;
            return false;
        }
    }

    @Override
    public Image getImageFromSVG(URI uri, int w, int h) throws IOException {
        return this.getImageFromSVG(uri, w, h, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Image getImageFromSVG(URI uri, int w, int h, Color color) throws IOException {
        try {
            InputStream is = this.openInputStream(uri);
            try {
                if (is == null) throw new IOException("Not found:" + uri);
                Image image = this.getImageFromSVG(is, uri, w, h, color);
                return image;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException("URL:" + uri, e);
        }
    }

    protected WeisjJSVG newInstance() {
        return new WeisjJSVG(this);
    }

    @Override
    public Image getImageFromSVG(InputStream inputStream, URI base, int w, int h, Color color) throws IOException {
        return this.newInstance().getImageFromSVG(inputStream, base, w, h);
    }

    @Override
    public ScalableIcon getIconFromSVG(InputStream stream, URI base, int width, int height, Color color) throws IOException {
        return this.newInstance().getIconFromSVG(stream, base, width, height);
    }

    @Override
    public InputStream openInputStream(URI uri) throws IOException {
        return uri.toURL().openStream();
    }
}

