/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;

public class ErrRedirect
extends Thread {
    private final File file;
    private FileOutputStream outStr = null;
    private PrintStream printStream = null;

    public ErrRedirect() {
        this.setDaemon(true);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(new Date().getTime());
        this.file = Application.getResource("logs/error_cerr_" + cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5) + "-" + System.currentTimeMillis() + ".log");
        try {
            this.file.getParentFile().mkdirs();
            this.file.deleteOnExit();
            if (!this.file.isFile()) {
                this.file.createNewFile();
            }
            this.outStr = new FileOutputStream(this.file, true);
            this.printStream = new PrintStream(this.outStr);
            System.setErr(this.printStream);
            this.start();
        }
        catch (IOException e) {
            LogV3.log(e);
        }
    }

    public void close() throws IOException {
        try {
            this.printStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.outStr.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.printStream = null;
        this.outStr = null;
    }

    public void flush() throws IOException {
        if (this.printStream == null) {
            return;
        }
        this.printStream.flush();
        this.outStr.flush();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void run() {
        while (this.printStream != null) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                if (this.printStream == null) break;
                this.printStream.flush();
            }
            catch (Throwable e) {
                LogV3.log(e);
                break;
            }
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

