/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class InterruptibleInputStream
extends FilterInputStream {
    public InterruptibleInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        this.checkInterrupted();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkInterrupted();
        return super.read(b, off, len);
    }

    protected void checkInterrupted() throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }
}

