/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.appwork.loggingv3.LogV3;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.KeyValueStringEntry;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.net.ChunkedInputStream;
import org.appwork.utils.net.CountingInputStream;
import org.appwork.utils.net.EmptyInputStream;
import org.appwork.utils.net.LimitedInputStream;
import org.appwork.utils.net.PublicSuffixList;
import org.appwork.utils.net.SocketFactory;
import org.appwork.utils.net.StreamValidEOF;
import org.appwork.utils.net.httpconnection.CountingBase64InputStream;
import org.appwork.utils.net.httpconnection.CountingGZIPInputStream;
import org.appwork.utils.net.httpconnection.CountingInflaterInputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionProfilerInterface;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPHeaderMap;
import org.appwork.utils.net.httpconnection.HTTPOutputStream;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.JavaSSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.KeepAliveSSLSocketStream;
import org.appwork.utils.net.httpconnection.KeepAliveSocketStream;
import org.appwork.utils.net.httpconnection.KeepAliveSocketStreamException;
import org.appwork.utils.net.httpconnection.NetworkInterfaceException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamInterface;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptionsModifier;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.parser.UrlQuery;

public class HTTPConnectionImpl
implements HTTPConnection {
    public static final String UNKNOWN_HTTP_RESPONSE = "unknown HTTP response";
    private static SSLSocketStreamFactory defaultSSLSocketStreamFactory = null;
    protected HTTPHeaderMap<String> requestProperties = null;
    protected volatile long[] ranges;
    protected String customcharset = null;
    protected volatile SocketStreamInterface connectionSocket = null;
    protected final URL httpURL;
    protected final HTTPProxy proxy;
    protected String httpPath;
    protected HTTPConnection.RequestMethod httpMethod = HTTPConnection.RequestMethod.GET;
    protected HTTPHeaderMap<List<String>> headers = null;
    protected int httpResponseCode = -1;
    protected String httpResponseMessage = "";
    protected volatile int readTimeout = 30000;
    protected volatile int requestedConnectTimeout = 30000;
    protected HTTPConnectionUtils.IPVERSION ipVersion = null;
    protected volatile long connectTime = -1L;
    protected volatile long requestTime = -1L;
    protected HTTPOutputStream outputStream = null;
    protected InputStream inputStream = null;
    protected InputStream convertedInputStream = null;
    protected volatile boolean inputStreamConnected = false;
    protected String httpHeader = null;
    protected String invalidHttpHeader = null;
    protected boolean contentDecoded = true;
    protected long postTodoLength = -1L;
    private int[] allowedResponseCodes = new int[0];
    protected final CopyOnWriteArrayList<String> connectExceptions = new CopyOnWriteArrayList();
    protected volatile KEEPALIVE keepAlive = KEEPALIVE.DISABLED;
    protected volatile InetAddress[] remoteIPs = null;
    protected boolean sslTrustALL = true;
    protected InetAddress lastConnection = null;
    protected int lastConnectionPort = -1;
    protected String hostName;
    private boolean legacyConnectFlag = true;
    private static final PublicSuffixList PSL = PublicSuffixList.getInstance();
    protected static final HashMap<String, LinkedList<KeepAliveSocketStream>> KEEPALIVEPOOL = new HashMap();
    protected static final Object LOCK = new Object();
    protected static final DelayedRunnable KEEPALIVECLEANUPTIMER = new DelayedRunnable(10000L, 30000L){

        @Override
        public void delayedrun() {
            HTTPConnectionImpl.cleanupKeepAlivePools();
        }
    };
    protected static HashMap<String, SSLSocketStreamOptions> SSL_SOCKETSTREAM_OPTIONS = new HashMap();
    protected static WeakHashMap<SSLSocketStreamOptionsModifier, Object> SSL_SOCKETSTREAM_OPTIONS_MODIFIER = new WeakHashMap();
    protected HTTPConnectionProfilerInterface profiler;

    public static void setDefaultSSLSocketStreamFactory(SSLSocketStreamFactory defaultSSLSocketStreamFactory) {
        HTTPConnectionImpl.defaultSSLSocketStreamFactory = defaultSSLSocketStreamFactory;
    }

    public static SSLSocketStreamFactory getDefaultSSLSocketStreamFactory() {
        SSLSocketStreamFactory ret = defaultSSLSocketStreamFactory;
        if (ret != null) {
            return ret;
        }
        return JavaSSLSocketStreamFactory.getInstance();
    }

    protected SocketStreamInterface getConnectionSocket() {
        return this.connectionSocket;
    }

    @Override
    public HTTPProxy getProxy() {
        return this.proxy;
    }

    public HTTPConnectionUtils.IPVERSION getIPVersion() {
        return this.ipVersion;
    }

    public void setIPVersion(HTTPConnectionUtils.IPVERSION ipVersion) {
        this.ipVersion = ipVersion;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.requestedConnectTimeout;
    }

    public KEEPALIVE getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(KEEPALIVE keepAlive) {
        this.keepAlive = keepAlive == null ? KEEPALIVE.DISABLED : keepAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void cleanupKeepAlivePools() {
        Object object = LOCK;
        synchronized (object) {
            try {
                Iterator<Map.Entry<String, LinkedList<KeepAliveSocketStream>>> hostIterator = KEEPALIVEPOOL.entrySet().iterator();
                while (hostIterator.hasNext()) {
                    Map.Entry<String, LinkedList<KeepAliveSocketStream>> next = hostIterator.next();
                    LinkedList<KeepAliveSocketStream> keepAliveSockets = next.getValue();
                    if (keepAliveSockets != null) {
                        Iterator keepAliveIterator = keepAliveSockets.iterator();
                        while (keepAliveIterator.hasNext()) {
                            KeepAliveSocketStream socketStream = (KeepAliveSocketStream)keepAliveIterator.next();
                            Socket socket = socketStream.getSocket();
                            if (socket.isClosed() || socketStream.isTimedOut()) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                keepAliveIterator.remove();
                                continue;
                            }
                            try {
                                if (socket.getChannel() == null) continue;
                                SocketChannel channel = socket.getChannel();
                                channel.configureBlocking(false);
                                ByteBuffer check = ByteBuffer.wrap(new byte[1]);
                                int read = channel.read(check);
                                if (read == -1) {
                                    throw new AsynchronousCloseException();
                                }
                                if (read != 0) {
                                    throw new IOException("Unexpected data received");
                                }
                                channel.configureBlocking(true);
                            }
                            catch (IOException e) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                keepAliveIterator.remove();
                            }
                        }
                    }
                    if (keepAliveSockets != null && keepAliveSockets.size() != 0) continue;
                    hostIterator.remove();
                }
            }
            finally {
                if (KEEPALIVEPOOL.size() > 0) {
                    KEEPALIVECLEANUPTIMER.resetAndStart();
                }
            }
        }
    }

    public HTTPConnectionImpl(URL url) {
        this(url, null);
    }

    public HTTPConnectionImpl(URL url, HTTPProxy p) {
        this.httpURL = url;
        this.proxy = this.isProxySupported(p);
        this.requestProperties = new HTTPHeaderMap();
        this.headers = new HTTPHeaderMap();
        this.httpPath = this.getRequestPath(url, false);
    }

    protected HTTPProxy isProxySupported(HTTPProxy proxy) {
        if (proxy != null) {
            switch (proxy.getType()) {
                case DIRECT: 
                case NONE: {
                    return proxy;
                }
            }
            throw new IllegalArgumentException("proxy must be of type direct/none:" + proxy);
        }
        return null;
    }

    protected String getRequestPath(URL url, boolean includeAll) {
        String httpPath = new Regex(url.toString(), "https?://.*?(/.+)").getMatch(0);
        String ret = httpPath == null ? "/" : httpPath;
        if (includeAll) {
            StringBuilder sb = new StringBuilder();
            sb.append(url.getProtocol());
            sb.append("://");
            sb.append(this.resolveHostname(url.getHost()));
            if (url.getPort() != -1) {
                sb.append(":").append(url.getPort());
            }
            sb.append(ret);
            return sb.toString();
        }
        return ret;
    }

    protected long getDefaultKeepAliveMaxRequests(String server) {
        if (StringUtils.containsIgnoreCase(server, "nginx")) {
            return 100L;
        }
        if (StringUtils.containsIgnoreCase(server, "apache")) {
            return 100L;
        }
        return 100L;
    }

    protected long getMaxKeepAliveSockets() {
        if (CrossSystem.OperatingSystem.WINDOWS_XP.equals((Object)CrossSystem.getOS())) {
            return 1L;
        }
        return 5L;
    }

    protected long getDefaultKeepAliveTimeout(String server) {
        if (StringUtils.containsIgnoreCase(server, "nginx")) {
            return 75000L;
        }
        if (StringUtils.containsIgnoreCase(server, "apache")) {
            return 5000L;
        }
        return 60000L;
    }

    protected boolean isKeepAliveOK() {
        int code = this.getResponseCode();
        return this.isOK() || code == 404 || code == 403 || code == 416;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean putKeepAliveSocket(SocketStreamInterface socketStream) throws IOException {
        InputStream rawInputStream;
        Socket socket;
        if (socketStream != null && (socket = socketStream.getSocket()) != null && this.isKeepAlivedEnabled() && this.isKeepAliveOK() && socket.isConnected() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown() && (rawInputStream = this.getRawInputStream()) != null && rawInputStream instanceof StreamValidEOF && ((StreamValidEOF)((Object)rawInputStream)).isValidEOF() && (!this.isRequiresOutputStream() || this.outputStream.transferedBytes() == this.postTodoLength)) {
            socket.setKeepAlive(true);
            Object object = LOCK;
            synchronized (object) {
                KeepAliveSocketStream keepAliveSocketStream;
                if (socketStream instanceof KeepAliveSocketStream) {
                    keepAliveSocketStream = (KeepAliveSocketStream)socketStream;
                } else {
                    String connectionResponse = this.getHeaderField("Keep-Alive");
                    String server = this.getHeaderField("Server");
                    String maxKeepAliveTimeoutString = new Regex(connectionResponse, "timeout\\s*=\\s*(\\d+)").getMatch(0);
                    String maxKeepAliveRequestsString = new Regex(connectionResponse, "max\\s*=\\s*(\\d+)").getMatch(0);
                    long maxKeepAliveTimeout = maxKeepAliveTimeoutString != null ? Long.parseLong(maxKeepAliveTimeoutString) * 1000L : this.getDefaultKeepAliveTimeout(server);
                    long maxKeepAliveRequests = maxKeepAliveRequestsString != null ? Long.parseLong(maxKeepAliveRequestsString) : this.getDefaultKeepAliveMaxRequests(server);
                    InetAddress localIP = this.proxy != null && this.proxy.isDirect() ? socket.getLocalAddress() : null;
                    InetAddress[] remoteIPs = this.remoteIPs != null ? this.remoteIPs : new InetAddress[]{((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress()};
                    keepAliveSocketStream = StringUtils.equalsIgnoreCase("https", this.httpURL.getProtocol()) ? new KeepAliveSSLSocketStream(this.getProxy(), this.getHostname(), (SSLSocketStreamInterface)socketStream, maxKeepAliveTimeout, maxKeepAliveRequests, localIP, remoteIPs) : new KeepAliveSocketStream(this.getProxy(), this.getHostname(), socketStream, maxKeepAliveTimeout, maxKeepAliveRequests, localIP, remoteIPs);
                }
                keepAliveSocketStream.increaseRequests();
                if (keepAliveSocketStream.getRequestsLeft() > 0L) {
                    LinkedList<KeepAliveSocketStream> keepAlivePool;
                    String domain = null;
                    if (PSL != null) {
                        domain = PSL.getDomain(keepAliveSocketStream.getHost());
                    }
                    if (StringUtils.isEmpty(domain)) {
                        domain = "FALLBACK";
                    }
                    if ((keepAlivePool = KEEPALIVEPOOL.get(domain)) == null) {
                        keepAlivePool = new LinkedList();
                        KEEPALIVEPOOL.put(domain, keepAlivePool);
                    }
                    keepAlivePool.add(keepAliveSocketStream);
                    keepAliveSocketStream.keepAlive();
                    long maxKeepAlive = this.getMaxKeepAliveSockets();
                    if ((long)keepAlivePool.size() > maxKeepAlive) {
                        Iterator it = keepAlivePool.iterator();
                        while (it.hasNext() && (long)keepAlivePool.size() > maxKeepAlive) {
                            KeepAliveSocketStream next = (KeepAliveSocketStream)it.next();
                            try {
                                next.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            it.remove();
                        }
                    }
                    KEEPALIVECLEANUPTIMER.resetAndStart();
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean checkSocketChannel(Socket socket) {
        if (socket != null) {
            try {
                if (socket.getChannel() != null) {
                    SocketChannel channel = socket.getChannel();
                    channel.configureBlocking(false);
                    ByteBuffer check = ByteBuffer.wrap(new byte[1]);
                    int read = channel.read(check);
                    if (read == -1) {
                        throw new AsynchronousCloseException();
                    }
                    if (read != 0) {
                        throw new IOException("Unexpected data received");
                    }
                    channel.configureBlocking(true);
                }
                return true;
            }
            catch (IOException e) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeepAliveSocketStream getKeepAliveSocket(boolean dnsLookup) throws IOException {
        InetAddress[] localIP = HTTPConnectionImpl.getNetworkInterfaceInetAdress(this.getProxy());
        int port = this.getPort(this.httpURL);
        String host = this.getHostname();
        boolean ssl = StringUtils.equalsIgnoreCase("https", this.httpURL.getProtocol());
        String domain = null;
        if (PSL != null) {
            domain = PSL.getDomain(host);
        }
        if (StringUtils.isEmpty(domain)) {
            domain = "FALLBACK";
        }
        Object object = LOCK;
        synchronized (object) {
            LinkedList<KeepAliveSocketStream> socketPool = KEEPALIVEPOOL.get(domain);
            if (socketPool != null) {
                Iterator<KeepAliveSocketStream> socketPoolIterator = socketPool.descendingIterator();
                while (socketPoolIterator.hasNext()) {
                    KeepAliveSocketStream socketStream = socketPoolIterator.next();
                    Socket socket = socketStream.getSocket();
                    if (socket.isClosed() || socketStream.isTimedOut()) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        socketPoolIterator.remove();
                        continue;
                    }
                    if (socket.getPort() != port || !socketStream.sameBoundIP(localIP)) continue;
                    if (socketStream.isSsl() && ssl && socketStream.sameHost(host)) {
                        socketPoolIterator.remove();
                        if (!this.checkSocketChannel(socket)) continue;
                        return socketStream;
                    }
                    if (socketStream.isSsl() || ssl || !socketStream.sameHost(host) && (!dnsLookup || !socketStream.sameRemoteIPs(this.getRemoteIPs(host, true)))) continue;
                    socketPoolIterator.remove();
                    if (!this.checkSocketChannel(socket)) continue;
                    return socketStream;
                }
                if (socketPool.isEmpty()) {
                    KEEPALIVEPOOL.remove(domain);
                }
            }
        }
        return null;
    }

    protected boolean addHostHeader() {
        for (String key : this.requestProperties.keySet()) {
            if (!"Host".equalsIgnoreCase(key)) continue;
            return false;
        }
        URL url = this.getURL();
        int defaultPort = url.getDefaultPort();
        int usedPort = url.getPort();
        String appendPort = "";
        if (usedPort != -1 && defaultPort != -1 && usedPort != defaultPort) {
            appendPort = ":" + usedPort;
        }
        this.requestProperties.put("Host", this.getHostname() + appendPort);
        return true;
    }

    protected void resetConnection() {
        this.inputStreamConnected = false;
        this.httpResponseCode = -1;
        this.httpResponseMessage = "";
        this.postTodoLength = -1L;
        this.outputStream = null;
        this.inputStream = null;
        this.convertedInputStream = null;
        this.connectTime = -1L;
        this.requestTime = -1L;
        this.headers.clear();
        this.ranges = null;
        this.lastConnection = null;
        this.lastConnectionPort = -1;
    }

    protected InetAddress getBindInetAddress(InetAddress dest, HTTPProxy proxy) throws IOException {
        InetAddress[] ret;
        if (proxy != null && proxy.isDirect() && (ret = HTTPConnectionImpl.getNetworkInterfaceInetAdress(proxy)) != null && ret.length > 0) {
            for (InetAddress ia : ret) {
                if (!(dest instanceof Inet4Address ? ia instanceof Inet4Address : dest instanceof Inet6Address && ia instanceof Inet6Address)) continue;
                return ia;
            }
        }
        return null;
    }

    public static InetAddress[] resolveLiteralIP(String ip) throws IOException {
        if (ip != null) {
            InetAddress[] ret = new InetAddress[1];
            if (ip.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$")) {
                ret[0] = InetAddress.getByName(ip);
                return ret;
            }
            if (ip.matches("^\\[[a-f0-9:]+\\]$")) {
                ret[0] = InetAddress.getByName(ip);
                return ret;
            }
        }
        return null;
    }

    public static InetAddress[] getNetworkInterfaceInetAdress(HTTPProxy proxy) throws IOException {
        if (proxy != null && proxy.isDirect()) {
            InetAddress[] ret;
            String local = proxy.getLocal();
            if (local != null && (ret = HTTPConnectionImpl.resolveLiteralIP(local)) != null && ret.length > 0) {
                return ret;
            }
            String interfaceName = local;
            if (interfaceName != null) {
                boolean subInterface;
                String ifName;
                int index = interfaceName.indexOf(":");
                if (index != -1) {
                    ifName = interfaceName.substring(0, index);
                    subInterface = true;
                } else {
                    ifName = interfaceName;
                    subInterface = false;
                }
                NetworkInterface netif = NetworkInterface.getByName(ifName);
                if (netif == null) {
                    throw new NetworkInterfaceException(NetworkInterfaceException.ERROR.INTERFACE_NOT_FOUND, ifName, proxy);
                }
                if (!netif.isUp()) {
                    throw new NetworkInterfaceException(NetworkInterfaceException.ERROR.INTERFACE_NOT_CONNECTED, ifName, proxy);
                }
                if (subInterface) {
                    HashSet<InetAddress> ret2 = new HashSet<InetAddress>();
                    Enumeration<NetworkInterface> subNetworkInterfaces = netif.getSubInterfaces();
                    while (subNetworkInterfaces.hasMoreElements()) {
                        NetworkInterface subNetworkInterface = subNetworkInterfaces.nextElement();
                        if (subNetworkInterface == null || !interfaceName.equals(subNetworkInterface.getName())) continue;
                        if (!subNetworkInterface.isUp()) {
                            throw new NetworkInterfaceException(NetworkInterfaceException.ERROR.INTERFACE_NOT_CONNECTED, interfaceName, proxy);
                        }
                        Enumeration<InetAddress> inetAddresses = subNetworkInterface.getInetAddresses();
                        while (inetAddresses.hasMoreElements()) {
                            InetAddress inetAddress = inetAddresses.nextElement();
                            if (inetAddress == null) continue;
                            ret2.add(inetAddress);
                        }
                        if (ret2.size() > 0) {
                            return ret2.toArray(new InetAddress[0]);
                        }
                        throw new NetworkInterfaceException(NetworkInterfaceException.ERROR.INTERFACE_NOT_SUPPORTED, interfaceName, proxy);
                    }
                    throw new NetworkInterfaceException(NetworkInterfaceException.ERROR.INTERFACE_NOT_SUPPORTED, interfaceName, proxy);
                }
                HashSet<InetAddress> ret3 = new HashSet<InetAddress>();
                Enumeration<InetAddress> inetAddresses = netif.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress == null) continue;
                    ret3.add(inetAddress);
                }
                if (ret3.size() > 0) {
                    Enumeration<NetworkInterface> subNetworkInterfaces = netif.getSubInterfaces();
                    while (subNetworkInterfaces.hasMoreElements()) {
                        NetworkInterface subNetworkInterface = subNetworkInterfaces.nextElement();
                        if (subNetworkInterface == null) continue;
                        inetAddresses = subNetworkInterface.getInetAddresses();
                        while (inetAddresses.hasMoreElements()) {
                            InetAddress inetAddress = inetAddresses.nextElement();
                            if (inetAddress == null) continue;
                            ret3.remove(inetAddress);
                        }
                    }
                }
                if (ret3.size() > 0) {
                    return ret3.toArray(new InetAddress[0]);
                }
                throw new NetworkInterfaceException(NetworkInterfaceException.ERROR.INTERFACE_NOT_SUPPORTED, interfaceName, proxy);
            }
            throw new ProxyConnectException("Invalid Direct Proxy", proxy);
        }
        return null;
    }

    protected Socket createRawConnectionSocket(InetAddress bindInetAddress) throws IOException {
        Socket socket = SocketFactory.get().create(this, bindInetAddress);
        if (bindInetAddress != null) {
            try {
                socket.bind(new InetSocketAddress(bindInetAddress, 0));
            }
            catch (IOException e) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.connectExceptions.add("Bind: " + bindInetAddress + "|" + this.getExceptionMessage(e));
                throw new NetworkInterfaceException(NetworkInterfaceException.ERROR.INTERFACE_BIND_ERROR, bindInetAddress.toString(), this.getProxy(), e);
            }
        }
        return socket;
    }

    protected SocketStreamInterface createConnectionSocket(InetAddress bindInetAddress) throws IOException {
        SocketStreamInterface connectionSocket = this.getConnectionSocket();
        this.closeConnectionSocket(connectionSocket);
        final Socket socket = this.createRawConnectionSocket(bindInetAddress);
        return new SocketStreamInterface(){

            @Override
            public Socket getSocket() {
                return socket;
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return socket.getOutputStream();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return socket.getInputStream();
            }

            @Override
            public void close() throws IOException {
                socket.close();
            }
        };
    }

    private void closeConnectionSocket(SocketStreamInterface connectionSocket) throws IOException {
        if (connectionSocket != null && this.connectionSocket == connectionSocket) {
            this.connectionSocket = null;
            connectionSocket.close();
        }
    }

    protected String resolveHostname(String hostName) {
        String resolvHost = !hostName.matches("^[a-zA-Z0-9\\-\\.]+$") && Application.getJavaVersion() >= Application.JAVA16 ? IDN.toASCII(hostName.trim()) : hostName.trim();
        return resolvHost.toLowerCase(Locale.ENGLISH);
    }

    protected void setHostname(String hostName) {
        this.hostName = hostName;
    }

    protected boolean isHostnameResolved() {
        return this.hostName != null;
    }

    protected InetAddress[] resolvHostIP(String host) throws IOException {
        return HTTPConnectionUtils.resolvHostIP(host, this.getIPVersion());
    }

    protected InetAddress[] getRemoteIPs(String hostName, boolean resolve) throws IOException {
        if (this.remoteIPs == null && resolve) {
            this.remoteIPs = this.resolvHostIP(hostName);
        }
        if (resolve && (this.remoteIPs == null || this.remoteIPs.length == 0)) {
            throw new UnknownHostException("Could not resolve(" + (Object)((Object)this.getIPVersion()) + "):" + hostName);
        }
        return this.remoteIPs;
    }

    protected void setRemoteIPs(InetAddress[] remoteIPs) {
        this.remoteIPs = remoteIPs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSSLSocketStreamOptionsModifier(SSLSocketStreamOptionsModifier sslSocketStreamModifier) {
        if (sslSocketStreamModifier != null) {
            WeakHashMap<SSLSocketStreamOptionsModifier, Object> weakHashMap = SSL_SOCKETSTREAM_OPTIONS_MODIFIER;
            synchronized (weakHashMap) {
                SSL_SOCKETSTREAM_OPTIONS_MODIFIER.put(sslSocketStreamModifier, Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeSSLSocketStreamOptionsModifier(SSLSocketStreamOptionsModifier sslSocketStreamModifier) {
        if (sslSocketStreamModifier != null) {
            WeakHashMap<SSLSocketStreamOptionsModifier, Object> weakHashMap = SSL_SOCKETSTREAM_OPTIONS_MODIFIER;
            synchronized (weakHashMap) {
                return Boolean.TRUE.equals(SSL_SOCKETSTREAM_OPTIONS_MODIFIER.remove(sslSocketStreamModifier));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLSocketStreamOptions getSSLSocketStreamOptions(String host, int port, boolean trustAllFlag) {
        String id = this.getSSLSocketStreamOptionsID(host, port, trustAllFlag);
        HashMap<String, SSLSocketStreamOptions> hashMap = SSL_SOCKETSTREAM_OPTIONS;
        synchronized (hashMap) {
            SSLSocketStreamOptions options = SSL_SOCKETSTREAM_OPTIONS.get(id);
            if (options == null || !options.isValid()) {
                options = this.getNewSSLSocketStreamOptionsInstance(host, port, trustAllFlag);
                SSL_SOCKETSTREAM_OPTIONS.put(id, options);
            }
            return this.getSSLSocketStreamOptions(options);
        }
    }

    protected SSLSocketStreamOptions getSSLSocketStreamOptions(SSLSocketStreamOptions options) {
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSSLSocketStreamOptions(SSLSocketStreamOptions options) {
        if (options != null) {
            HashMap<String, SSLSocketStreamOptions> hashMap = SSL_SOCKETSTREAM_OPTIONS;
            synchronized (hashMap) {
                SSL_SOCKETSTREAM_OPTIONS.put(options.getId(), options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLSocketStreamOptions processSSLSocketStreamOptionsModifier(SSLSocketStreamOptions sslSocketStreamOptions) {
        ArrayList<SSLSocketStreamOptionsModifier> modifiers;
        WeakHashMap<SSLSocketStreamOptionsModifier, Object> weakHashMap = SSL_SOCKETSTREAM_OPTIONS_MODIFIER;
        synchronized (weakHashMap) {
            modifiers = new ArrayList<SSLSocketStreamOptionsModifier>(SSL_SOCKETSTREAM_OPTIONS_MODIFIER.keySet());
        }
        for (SSLSocketStreamOptionsModifier modifier : modifiers) {
            SSLSocketStreamOptions ret = modifier.modify(sslSocketStreamOptions, this);
            if (ret == null) continue;
            sslSocketStreamOptions = ret;
        }
        return sslSocketStreamOptions;
    }

    protected String getSSLSocketStreamOptionsID(String host, int port, boolean trustAllFlag) {
        return host + ":" + port + ":" + trustAllFlag;
    }

    protected SSLSocketStreamOptions getNewSSLSocketStreamOptionsInstance(String host, int port, boolean trustAllFlag) {
        String id = this.getSSLSocketStreamOptionsID(host, port, trustAllFlag);
        SSLSocketStreamOptions ret = new SSLSocketStreamOptions(id, trustAllFlag);
        return this.processSSLSocketStreamOptionsModifier(ret);
    }

    protected int getPort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            return url.getDefaultPort();
        }
        return port;
    }

    @Override
    public HTTPConnectionProfilerInterface getProfiler() {
        return this.profiler;
    }

    @Override
    public void setProfiler(HTTPConnectionProfilerInterface profiler) {
        this.profiler = profiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connect() throws IOException {
        HTTPConnectionProfilerInterface profiler = this.getProfiler();
        if (profiler != null) {
            profiler.onConnect(this);
        }
        SSLSocketStreamOptions sslSocketStreamOptions = null;
        SSLSocketStreamFactory factory = null;
        block18: while (!this.isConnectionSocketValid()) {
            this.resetConnection();
            if (!this.isHostnameResolved()) {
                this.setHostname(this.resolveHostname(this.httpURL.getHost()));
            }
            if (!KEEPALIVE.DISABLED.equals((Object)this.getKeepAlive())) {
                this.connectionSocket = this.getKeepAliveSocket(false);
                if (this.connectionSocket == null) {
                    this.connectionSocket = this.getKeepAliveSocket(true);
                }
            }
            if (this.connectionSocket == null) {
                IOException ee = null;
                ArrayList<InetAddress> remoteIPs = new ArrayList<InetAddress>(Arrays.asList(this.getRemoteIPs(this.getHostname(), true)));
                while (remoteIPs.size() > 0) {
                    InetAddress host = (InetAddress)remoteIPs.remove(0);
                    this.resetConnection();
                    int port = this.getPort(this.httpURL);
                    long startMS = Time.systemIndependentCurrentJVMTimeMillis();
                    HTTPProxy lProxy = this.getProxy();
                    InetAddress bindInetAddress = null;
                    if (lProxy != null) {
                        if (lProxy.isDirect()) {
                            bindInetAddress = this.getBindInetAddress(host, lProxy);
                        } else if (!lProxy.isNone()) {
                            throw new ProxyConnectException("Invalid Direct Proxy", lProxy);
                        }
                    }
                    InetSocketAddress connectedInetSocketAddress = new InetSocketAddress(host, port);
                    try {
                        int requestedConnectTimeout = this.getConnectTimeout();
                        if (requestedConnectTimeout == 0) {
                            startMS = Time.systemIndependentCurrentJVMTimeMillis();
                            this.connectionSocket = this.createConnectionSocket(bindInetAddress);
                            this.connectionSocket.getSocket().connect(connectedInetSocketAddress, requestedConnectTimeout);
                            this.setReadTimeout(this.getReadTimeout());
                        } else {
                            int remainingConnectTimeout = requestedConnectTimeout;
                            while (true) {
                                startMS = Time.systemIndependentCurrentJVMTimeMillis();
                                this.connectionSocket = this.createConnectionSocket(bindInetAddress);
                                long beforeConnectMS = Time.systemIndependentCurrentJVMTimeMillis();
                                try {
                                    this.connectionSocket.getSocket().connect(connectedInetSocketAddress, remainingConnectTimeout);
                                    this.setReadTimeout(this.getReadTimeout());
                                }
                                catch (IOException e) {
                                    this.closeConnectionSocket(this.connectionSocket);
                                    if (connectedInetSocketAddress.getAddress() instanceof Inet6Address && Exceptions.containsInstanceOf(e, SocketException.class, ConnectException.class, SocketTimeoutException.class)) {
                                        if (StringUtils.containsIgnoreCase(e.getMessage(), "Network is unreachable")) {
                                            remoteIPs = new ArrayList<InetAddress>(Arrays.asList(HTTPConnectionUtils.sortAndFilter(remoteIPs.toArray(new InetAddress[0]), HTTPConnectionUtils.IPVERSION.IPV4_ONLY)));
                                            throw new TryNextConnectException((Throwable)e);
                                        }
                                        if (StringUtils.containsIgnoreCase(e.getMessage(), "timed out")) {
                                            remoteIPs = new ArrayList<InetAddress>(Arrays.asList(HTTPConnectionUtils.sortAndFilter(remoteIPs.toArray(new InetAddress[0]), HTTPConnectionUtils.IPVERSION.IPV4_IPV6)));
                                            throw new TryNextConnectException((Throwable)e);
                                        }
                                    }
                                    if (!Exceptions.containsInstanceOf(e, ConnectException.class, SocketTimeoutException.class) || !StringUtils.containsIgnoreCase(e.getMessage(), "timed out")) throw e;
                                    long timeout = Time.systemIndependentCurrentJVMTimeMillis() - beforeConnectMS;
                                    if (timeout < 1000L) {
                                        int sleep = Math.max(100, (int)(2000L - timeout));
                                        this.connectExceptions.add("Too Fast ConnectTimeout(Normal): " + timeout + "->Wait " + sleep);
                                        try {
                                            Thread.sleep(sleep);
                                            timeout = Time.systemIndependentCurrentJVMTimeMillis() - beforeConnectMS;
                                        }
                                        catch (InterruptedException ie) {
                                            throw Exceptions.addSuppressed(e, ie);
                                        }
                                    }
                                    int lastConnectTimeout = remainingConnectTimeout;
                                    if ((remainingConnectTimeout = (int)Math.max(0L, (long)remainingConnectTimeout - timeout)) == 0) {
                                        throw e;
                                    }
                                    if (Thread.currentThread().isInterrupted()) {
                                        throw e;
                                    }
                                    this.connectExceptions.add("Workaround for ConnectTimeout(Normal): " + lastConnectTimeout + ">" + timeout);
                                    continue;
                                }
                                break;
                            }
                        }
                        if (profiler != null) {
                            profiler.onConnected(this);
                        }
                        if (this.httpURL.getProtocol().startsWith("https")) {
                            String hostName = this.getHostname();
                            if (sslSocketStreamOptions == null) {
                                sslSocketStreamOptions = this.getSSLSocketStreamOptions(hostName, port, this.isSSLTrustALL());
                            }
                            factory = this.getSSLSocketStreamFactory(sslSocketStreamOptions);
                            this.connectionSocket = factory.create(this.connectionSocket, hostName, port, true, sslSocketStreamOptions);
                        }
                        this.connectTime = Time.systemIndependentCurrentJVMTimeMillis() - startMS;
                        ee = null;
                        break;
                    }
                    catch (TryNextConnectException e) {
                        IOException cause = e.getCause() instanceof IOException ? (IOException)e.getCause() : (e.getCause() != null ? new IOException(e.getCause()) : new IOException(e));
                        try {
                            this.connectExceptions.add(connectedInetSocketAddress + "|" + this.getExceptionMessage(cause));
                        }
                        finally {
                            this.disconnect();
                        }
                        if (bindInetAddress != null) {
                            ee = new ProxyConnectException(cause, lProxy);
                            continue;
                        }
                        ee = cause;
                    }
                    catch (IOException e) {
                        String retrySSL;
                        try {
                            String string;
                            if (sslSocketStreamOptions != null) {
                                sslSocketStreamOptions = sslSocketStreamOptions.clone();
                                string = sslSocketStreamOptions.retry(factory, e);
                            } else {
                                string = null;
                            }
                            retrySSL = string;
                            this.setSSLSocketStreamOptions(sslSocketStreamOptions);
                            this.connectExceptions.add(connectedInetSocketAddress + "|" + this.getExceptionMessage(e) + "|retrySSL:" + retrySSL);
                        }
                        finally {
                            this.disconnect();
                        }
                        if (retrySSL != null) continue block18;
                        if (bindInetAddress != null) {
                            ee = new ProxyConnectException(e, lProxy);
                            continue;
                        }
                        ee = e;
                    }
                }
                if (ee != null) {
                    throw ee;
                }
            }
            Socket lastConnectionSocket = this.getConnectionSocket().getSocket();
            try {
                this.lastConnection = lastConnectionSocket.getInetAddress();
                this.lastConnectionPort = lastConnectionSocket.getPort();
                this.sendRequest();
                return;
            }
            catch (IOException e) {
                String retrySSL;
                try {
                    String string;
                    if (sslSocketStreamOptions != null) {
                        sslSocketStreamOptions = sslSocketStreamOptions.clone();
                        string = sslSocketStreamOptions.retry(factory, e);
                    } else {
                        string = null;
                    }
                    retrySSL = string;
                    this.setSSLSocketStreamOptions(sslSocketStreamOptions);
                    this.connectExceptions.add(this.lastConnection + "|" + this.getExceptionMessage(e) + "|retrySSL:" + retrySSL);
                }
                finally {
                    this.disconnect();
                }
                if (retrySSL == null) throw e;
                continue;
            }
            break;
        }
        return;
    }

    protected SSLSocketStreamFactory getSSLSocketStreamFactory(SSLSocketStreamOptions sslSocketStreamOptions) {
        SSLSocketStreamFactory ret;
        SSLSocketStreamFactory sSLSocketStreamFactory = ret = sslSocketStreamOptions != null ? sslSocketStreamOptions.getSSLSocketStreamFactory() : null;
        if (ret != null) {
            return ret;
        }
        return HTTPConnectionImpl.getDefaultSSLSocketStreamFactory();
    }

    protected boolean isKeepAlivedEnabled() {
        KEEPALIVE keepAlive = this.getKeepAlive();
        if (!KEEPALIVE.DISABLED.equals((Object)keepAlive)) {
            String connectionRequest = this.getRequestProperty("Connection");
            String connectionResponse = this.getHeaderField("Connection");
            boolean tryKeepAlive = !(this.isRequiresOutputStream() && !KEEPALIVE.EXTERNAL_EXCEPTION.equals((Object)keepAlive) || connectionResponse != null && !StringUtils.containsIgnoreCase(connectionResponse, "Keep-Alive") || connectionRequest != null && StringUtils.containsIgnoreCase(connectionRequest, "close"));
            return tryKeepAlive;
        }
        return false;
    }

    protected String fromBytes(byte[] bytes, int start, int end) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (start < 0) {
            start = 0;
        }
        if (end < 0 || end >= bytes.length) {
            end = bytes.length;
        }
        for (int index = start; index < end; ++index) {
            int c = bytes[index] & 0xFF;
            if (c <= 127) {
                sb.append((char)c);
                continue;
            }
            String hexEncoded = Integer.toString(c, 16).toUpperCase(Locale.ENGLISH);
            if (hexEncoded.length() == 1) {
                sb.append("%0");
            } else {
                sb.append("%");
            }
            sb.append(hexEncoded);
        }
        return sb.toString();
    }

    protected synchronized void connectInputStream() throws IOException {
        SocketStreamInterface connectionSocket = this.getConnectionSocket();
        try {
            String[] headerStrings;
            String temp;
            long done;
            final HTTPConnectionProfilerInterface profiler = this.getProfiler();
            if (this.isRequiresOutputStream() && this.postTodoLength >= 0L && (done = this.outputStream.transferedBytes()) != this.postTodoLength) {
                throw new IllegalStateException("Content-Length " + this.postTodoLength + " does not match send " + done + " bytes");
            }
            if (this.inputStreamConnected) {
                return;
            }
            if (this.isRequiresOutputStream()) {
                this.outputStream.flush();
            }
            if (profiler != null) {
                profiler.onBeforeSocketGetInputStream(this);
            }
            long startTime = Time.systemIndependentCurrentJVMTimeMillis();
            InputStream inputStream = connectionSocket.getInputStream();
            if (profiler != null) {
                profiler.onAfterSocketGetInputStream(this);
            }
            this.inputStreamConnected = true;
            ByteBuffer header = null;
            try {
                header = HTTPConnectionUtils.readheader(new CountingInputStream(inputStream){
                    private boolean first;
                    {
                        super(in);
                        this.first = true;
                    }

                    @Override
                    protected void inc(int ret) throws IOException {
                        super.inc(ret);
                        if (this.first) {
                            this.first = false;
                            if (profiler != null) {
                                profiler.onFirstHeaderByteRead(HTTPConnectionImpl.this);
                            }
                        }
                    }
                }, true);
                if (header.limit() == 0) {
                    throw new EOFException("empty HTTP-Response");
                }
            }
            catch (IOException e) {
                if (connectionSocket instanceof KeepAliveSocketStream) {
                    throw new KeepAliveSocketStreamException(e, connectionSocket);
                }
                throw e;
            }
            if (header.hasArray()) {
                this.httpHeader = new String(header.array(), 0, header.limit(), "ISO-8859-1").trim();
            } else {
                byte[] bytes = new byte[header.limit()];
                header.get(bytes);
                this.httpHeader = new String(bytes, "ISO-8859-1").trim();
            }
            if (this.httpHeader.matches("^[a-zA-Z0-9/\\.]+\\s*\\d+.*?")) {
                String code = new Regex(this.httpHeader, "[a-zA-Z0-9/\\.]+\\s*(\\d+)").getMatch(0);
                if (code != null) {
                    this.httpResponseCode = Integer.parseInt(code);
                }
                this.httpResponseMessage = new Regex(this.httpHeader, "[a-zA-Z0-9/\\.]+\\s*\\d+\\s*(.+)").getMatch(0);
                if (this.httpResponseMessage == null) {
                    this.httpResponseMessage = "";
                }
            } else {
                if (connectionSocket instanceof KeepAliveSocketStream) {
                    throw new KeepAliveSocketStreamException(new IOException(UNKNOWN_HTTP_RESPONSE), connectionSocket);
                }
                this.invalidHttpHeader = this.httpHeader;
                this.httpHeader = UNKNOWN_HTTP_RESPONSE;
                this.httpResponseCode = 999;
                this.httpResponseMessage = UNKNOWN_HTTP_RESPONSE;
                if (header.limit() > 0) {
                    PushbackInputStream pushBackInputStream;
                    if (header.hasArray()) {
                        pushBackInputStream = new PushbackInputStream(inputStream, header.limit());
                        pushBackInputStream.unread(header.array(), 0, header.limit());
                    } else {
                        byte[] bytes = new byte[header.limit()];
                        header.get(bytes);
                        pushBackInputStream = new PushbackInputStream(inputStream, bytes.length);
                        pushBackInputStream.unread(bytes);
                    }
                    this.inputStream = pushBackInputStream;
                } else {
                    this.inputStream = inputStream;
                }
                return;
            }
            try {
                header = HTTPConnectionUtils.readheader(inputStream, false);
            }
            catch (IOException e) {
                if (connectionSocket instanceof KeepAliveSocketStream) {
                    throw new KeepAliveSocketStreamException(e, connectionSocket);
                }
                throw e;
            }
            if (profiler != null) {
                profiler.onAllResponseHeadersRead(this);
            }
            if (header.hasArray()) {
                temp = this.fromBytes(header.array(), 0, header.limit());
            } else {
                byte[] bytes = new byte[header.limit()];
                header.get(bytes);
                temp = this.fromBytes(bytes, -1, -1);
            }
            this.requestTime = Time.systemIndependentCurrentJVMTimeMillis() - startTime;
            for (String line : headerStrings = temp.split("(\r\n)|(\n)")) {
                List<String> list;
                String key = null;
                String value = null;
                int index = 0;
                index = line.indexOf(": ");
                if (index > 0) {
                    key = line.substring(0, index);
                    value = line.substring(index + 2);
                } else {
                    index = line.indexOf(":");
                    if (index > 0) {
                        key = line.substring(0, index);
                        value = line.substring(index + 1);
                    } else {
                        key = null;
                        value = line;
                    }
                }
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                if ((list = this.headers.get(key)) == null) {
                    list = new ArrayList<String>();
                    this.headers.put(key, list);
                }
                list.add(value);
            }
            headerStrings = null;
            InputStream wrappedInputStream = this.isKeepAlivedEnabled() ? new FilterInputStream(inputStream){

                @Override
                public void close() throws IOException {
                }
            } : inputStream;
            if (HTTPConnection.RequestMethod.HEAD.equals((Object)this.getRequestMethod())) {
                wrappedInputStream = new LimitedInputStream(wrappedInputStream, 0L);
            } else {
                boolean isChunked = StringUtils.containsIgnoreCase(this.getHeaderField("Transfer-Encoding"), "chunked");
                if (isChunked) {
                    wrappedInputStream = new ChunkedInputStream(wrappedInputStream);
                } else {
                    long contentLength = this.getContentLength();
                    if (contentLength >= 0L) {
                        wrappedInputStream = new LimitedInputStream(wrappedInputStream, contentLength);
                    } else if (HTTPConstants.ResponseCode.SUCCESS_NO_CONTENT.matches(this.getResponseCode())) {
                        wrappedInputStream = new LimitedInputStream(wrappedInputStream, 0L);
                    }
                }
            }
            this.inputStream = wrappedInputStream;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        HTTPConnectionProfilerInterface profiler = this.getProfiler();
        if (profiler != null) {
            profiler.onDisconnect(this);
        }
        SocketStreamInterface connectionSocket = null;
        try {
            connectionSocket = this.getConnectionSocket();
            if (connectionSocket != null && !this.putKeepAliveSocket(connectionSocket)) {
                connectionSocket.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                if (connectionSocket != null) {
                    connectionSocket.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.connectionSocket = null;
        }
        if (connectionSocket != null && profiler != null) {
            profiler.onDisconnected(this);
        }
    }

    @Override
    public void finalizeConnect() throws IOException {
        HTTPConnectionProfilerInterface profiler = this.getProfiler();
        if (profiler != null) {
            profiler.onFinalizeConnection(this);
        }
        this.connect();
        this.connectInputStream();
    }

    protected String getExceptionMessage(Exception e) {
        if (e == null) {
            return null;
        }
        if (e.getMessage() != null) {
            return e.getClass().getName() + "(" + e.getMessage() + ")";
        }
        return e.getClass().getName();
    }

    @Override
    public int[] getAllowedResponseCodes() {
        return this.allowedResponseCodes;
    }

    @Override
    public String getCharset() {
        int charSetIndex;
        if (this.customcharset != null) {
            return this.customcharset;
        }
        String charSet = this.getContentType();
        if (charSet != null && (charSetIndex = this.getContentType().toLowerCase().indexOf("charset=")) > 0 && (charSet = this.getContentType().substring(charSetIndex + 8).trim()).length() > 2) {
            int indexLast;
            if (charSet.startsWith("\"") && (indexLast = (charSet = charSet.substring(1)).lastIndexOf("\"")) > 0) {
                charSet = charSet.substring(0, indexLast);
            }
            return charSet;
        }
        return null;
    }

    @Override
    public long getCompleteContentLength() {
        long[] ranges = this.getRange();
        if (ranges != null) {
            return ranges[2];
        }
        return this.getContentLength();
    }

    @Override
    public long getContentLength() {
        String length = this.getHeaderField("Content-Length");
        if (length != null && length.trim().matches("^\\d+$")) {
            return Long.parseLong(length.trim());
        }
        return -1L;
    }

    @Override
    public String getContentType() {
        String type = this.getHeaderField("Content-Type");
        if (type == null) {
            return "unknown";
        }
        return type;
    }

    @Override
    public String getHeaderField(String string) {
        List<String> ret = this.headers.get(string);
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret.get(0);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headers;
    }

    @Override
    public List<String> getHeaderFields(String string) {
        List<String> ret = this.headers.get(string);
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    protected InputStream getRawInputStream() {
        return this.inputStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isLegacyConnectEnabled() && !this.isConnectionSocketValid()) {
            throw new IllegalStateException("not connected!");
        }
        this.connect();
        this.connectInputStream();
        int code = this.getResponseCode();
        if (this.isOK() || code == 404 || code == 403 || code == 416 || code == 401 || code == 410) {
            if (this.convertedInputStream == null) {
                InputStream rawInputStream = this.getRawInputStream();
                if (this.contentDecoded && !HTTPConnection.RequestMethod.HEAD.equals((Object)this.getRequestMethod())) {
                    if (this.getContentLength() == 0L) {
                        this.convertedInputStream = new EmptyInputStream();
                        this.contentDecoded = false;
                    } else {
                        String encodingTransfer = this.getHeaderField("Content-Transfer-Encoding");
                        if ("base64".equalsIgnoreCase(encodingTransfer)) {
                            rawInputStream = new CountingBase64InputStream(rawInputStream);
                        } else if ("binary".equalsIgnoreCase(encodingTransfer)) {
                            rawInputStream = new CountingInputStream(rawInputStream);
                        }
                        String encoding = this.getHeaderField("Content-Encoding");
                        if (encoding == null || encoding.length() == 0 || "none".equalsIgnoreCase(encoding) || "identity".equalsIgnoreCase(encoding)) {
                            this.convertedInputStream = new CountingInputStream(rawInputStream);
                            this.contentDecoded = false;
                        } else if ("gzip".equalsIgnoreCase(encoding) || "x-gzip".equalsIgnoreCase(encoding)) {
                            CountingInputStream countingInputStream = new CountingInputStream(rawInputStream);
                            try {
                                this.convertedInputStream = new CountingGZIPInputStream(countingInputStream);
                                this.contentDecoded = true;
                            }
                            catch (IOException e) {
                                if (rawInputStream instanceof StreamValidEOF && ((StreamValidEOF)((Object)rawInputStream)).isValidEOF()) {
                                    this.convertedInputStream = countingInputStream;
                                    this.contentDecoded = true;
                                }
                                throw e;
                            }
                        } else if ("deflate".equalsIgnoreCase(encoding) || "x-deflate".equalsIgnoreCase(encoding)) {
                            CountingInputStream countingInputStream = new CountingInputStream(rawInputStream);
                            try {
                                this.convertedInputStream = new CountingInflaterInputStream(countingInputStream);
                                this.contentDecoded = true;
                            }
                            catch (IOException e) {
                                if (rawInputStream instanceof StreamValidEOF && ((StreamValidEOF)((Object)rawInputStream)).isValidEOF()) {
                                    this.convertedInputStream = countingInputStream;
                                    this.contentDecoded = true;
                                }
                                throw e;
                            }
                        } else {
                            this.convertedInputStream = new CountingInputStream(rawInputStream);
                            this.contentDecoded = false;
                        }
                    }
                } else {
                    this.convertedInputStream = new CountingInputStream(rawInputStream);
                    this.contentDecoded = false;
                }
            }
            return this.convertedInputStream;
        }
        throw new HTTPConnection.HTTPResponseCodeException(this);
    }

    @Override
    public HTTPOutputStream getOutputStream() throws IOException {
        if (this.outputStream != null && this.isRequiresOutputStream()) {
            return this.outputStream;
        }
        throw new IOException("OutputStream is not available");
    }

    @Override
    public long[] getRange() {
        if (this.ranges == null) {
            this.ranges = HTTPConnectionUtils.parseContentRange(this);
        }
        return this.ranges;
    }

    protected String getHostname() {
        if (this.isHostnameResolved()) {
            return this.hostName;
        }
        return this.resolveHostname(this.httpURL.getHost());
    }

    protected int getPort() {
        return this.getPort(this.getURL());
    }

    protected String getRequestInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("----------------Request Information-------------\r\n");
        sb.append("URL: ").append(this.getURL()).append("\r\n");
        try {
            UrlQuery query = UrlQuery.parse(this.getURL().getQuery());
            if (query.list().size() > 0) {
                sb.append("URL-Parameter" + (query.list().size() > 1 ? "s" : "") + ":").append("\r\n");
                int max = 0;
                for (KeyValueStringEntry p : query.list()) {
                    if (p.getKey() == null) continue;
                    max = Math.max(((String)p.getKey()).length(), max);
                }
                for (KeyValueStringEntry p : query.list()) {
                    sb.append("   " + StringUtils.fillPost(p.getKey() == null ? "" : (String)p.getKey(), " ", max)).append(" : ").append(URLEncode.decodeURIComponent((String)p.getValue())).append("\r\n");
                }
            }
        }
        catch (Throwable e) {
            LogV3.logger(HTTPConnectionImpl.class).exception("Error during toString", e);
        }
        SocketStreamInterface connectionSocketStream = this.getConnectionSocket();
        Socket connectionSocket = connectionSocketStream != null ? connectionSocketStream.getSocket() : null;
        InetAddress lLastConnection = this.lastConnection;
        if (connectionSocket != null && connectionSocket.isConnected()) {
            if (connectionSocketStream instanceof SSLSocketStreamInterface) {
                SSLSocketStreamInterface sslSocketStream = (SSLSocketStreamInterface)connectionSocketStream;
                SSLSocketStreamOptions options = sslSocketStream.getOptions();
                if (options != null && options.getRetryReasons().size() > 0) {
                    sb.append("SSLCipher: ").append(sslSocketStream.getCipherSuite() + "|" + options.getRetryReasons().toString()).append("\r\n");
                } else {
                    sb.append("SSLCipher: ").append(sslSocketStream.getCipherSuite()).append("\r\n");
                }
            }
            sb.append("ConnectIP: ").append(connectionSocket.getInetAddress()).append(":").append(connectionSocket.getPort()).append("\r\n");
        } else if (lLastConnection != null) {
            sb.append("ConnectIP: ").append(lLastConnection).append(":").append(this.lastConnectionPort).append("\r\n");
        } else {
            sb.append("Host: ").append(this.getHostname()).append("\r\n");
        }
        if (this.proxy != null && this.proxy.isDirect()) {
            if (connectionSocket != null) {
                sb.append("Local: ").append(this.proxy.getLocal()).append(connectionSocket.getLocalAddress().toString()).append("\r\n");
            } else {
                sb.append("Local: ").append(this.proxy.getLocal()).append("\r\n");
            }
        }
        sb.append("Connection-Timeout: ").append(this.getConnectTimeout() + "ms").append("\r\n");
        sb.append("Read-Timeout: ").append(this.getReadTimeout() + "ms").append("\r\n");
        if (this.connectExceptions.size() > 0) {
            sb.append("----------------ConnectionExceptions-------------------------\r\n");
            int index = 0;
            for (String connectException : this.connectExceptions) {
                sb.append(index++).append(":").append(connectException).append("\r\n");
            }
        }
        sb.append("----------------Request-------------------------\r\n");
        if (this.getRawInputStream() != null) {
            sb.append(this.httpMethod.toString()).append(' ').append(this.httpPath).append(" HTTP/1.1\r\n");
            for (Map.Entry<String, String> next : this.getRequestProperties().entrySet()) {
                if (next.getValue() == null) continue;
                sb.append(next.getKey());
                sb.append(": ");
                sb.append(next.getValue());
                sb.append("\r\n");
            }
        } else {
            sb.append("-------------Not Connected Yet!-----------------\r\n");
        }
        return sb.toString();
    }

    @Override
    public HTTPConnection.RequestMethod getRequestMethod() {
        return this.httpMethod;
    }

    @Override
    public Map<String, String> getRequestProperties() {
        return this.requestProperties;
    }

    @Override
    public String getRequestProperty(String string) {
        return this.requestProperties.get(string);
    }

    @Override
    public long getRequestTime() {
        return this.requestTime;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public int getResponseCode() {
        return this.httpResponseCode;
    }

    protected String getResponseInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("----------------Response Information------------\r\n");
        try {
            if (this.getRawInputStream() != null) {
                long lconnectTime = this.getConnectTime();
                if (lconnectTime >= 0L) {
                    sb.append("Connection-Time: ").append(lconnectTime + "ms").append("\r\n");
                } else {
                    sb.append("Connection-Time: keep-Alive\r\n");
                }
                long lrequestTime = this.getRequestTime();
                sb.append("Request-Time: ").append(Math.max(0L, lrequestTime) + "ms").append("\r\n");
                sb.append("----------------Response------------------------\r\n");
                this.connectInputStream();
                sb.append(this.httpHeader).append("\r\n");
                if (this.invalidHttpHeader != null) {
                    sb.append("InvalidHTTPHeader: ").append(this.invalidHttpHeader).append("\r\n");
                }
                for (Map.Entry<String, List<String>> next : this.getHeaderFields().entrySet()) {
                    for (int i = 0; i < next.getValue().size(); ++i) {
                        if (next.getKey() == null) {
                            sb.append(next.getValue().get(i));
                            sb.append("\r\n");
                            continue;
                        }
                        sb.append(next.getKey());
                        sb.append(": ");
                        sb.append(next.getValue().get(i));
                        sb.append("\r\n");
                    }
                }
                sb.append("------------------------------------------------\r\n");
            } else {
                sb.append("-------------Not Connected Yet!------------------\r\n");
            }
        }
        catch (IOException nothing) {
            sb.append("----------No InputStream Available!--------------\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    @Override
    public String getResponseMessage() {
        return this.httpResponseMessage;
    }

    @Override
    public URL getURL() {
        return this.httpURL;
    }

    @Override
    public boolean isConnected() {
        Socket socket;
        SocketStreamInterface connectionSocket = this.getConnectionSocket();
        return connectionSocket != null && (socket = connectionSocket.getSocket()) != null && socket.isConnected();
    }

    protected boolean isConnectionSocketValid() {
        Socket socket;
        SocketStreamInterface connectionSocket = this.getConnectionSocket();
        return connectionSocket != null && (socket = connectionSocket.getSocket()) != null && socket.isConnected() && !socket.isClosed();
    }

    @Override
    public boolean isContentDecoded() {
        if (this.convertedInputStream == null && this.contentDecoded && this.isConnected()) {
            try {
                this.getInputStream();
            }
            catch (IOException e) {
                LogV3.log(e);
            }
        }
        return this.contentDecoded;
    }

    @Override
    public boolean isContentDisposition() {
        return this.getHeaderField("Content-Disposition") != null;
    }

    @Override
    public boolean isOK() {
        int code = this.getResponseCode();
        if (code >= 200 && code < 400) {
            return true;
        }
        return this.isResponseCodeAllowed(code);
    }

    protected boolean isResponseCodeAllowed(int code) {
        for (int c : this.allowedResponseCodes) {
            if (c != code && c != -1) continue;
            return true;
        }
        return false;
    }

    protected void putHostToTop(Map<String, String> oldRequestProperties) {
        HTTPHeaderMap<String> newRet = new HTTPHeaderMap<String>();
        String host = oldRequestProperties.remove("Host");
        if (host != null) {
            newRet.put("Host", host);
        }
        newRet.putAll(oldRequestProperties);
        oldRequestProperties.clear();
        oldRequestProperties.putAll(newRet);
    }

    protected boolean isRequiresOutputStream() {
        return this.httpMethod.requiresOutputStream;
    }

    protected void sendRequest() throws UnsupportedEncodingException, IOException {
        HTTPConnectionProfilerInterface profiler = this.getProfiler();
        if (profiler != null) {
            profiler.onSendRequest(this);
        }
        SocketStreamInterface connectionSocket = this.getConnectionSocket();
        StringBuilder sb = new StringBuilder();
        sb.append(this.httpMethod.name()).append(' ').append(this.httpPath).append(" HTTP/1.1\r\n");
        this.addHostHeader();
        this.putHostToTop(this.requestProperties);
        for (Map.Entry<String, String> next : this.requestProperties.entrySet()) {
            String key = next.getKey();
            String value = next.getValue();
            if (value == null) continue;
            if ("Content-Length".equalsIgnoreCase(key)) {
                this.postTodoLength = Long.parseLong(value.trim());
            }
            sb.append(key).append(": ").append(value).append("\r\n");
        }
        sb.append("\r\n");
        try {
            if (profiler != null) {
                profiler.onBeforeRequestHeadersSent(this, sb);
            }
            OutputStream outputStream = connectionSocket.getOutputStream();
            outputStream.write(sb.toString().getBytes("ISO-8859-1"));
            outputStream.flush();
            if (profiler != null) {
                profiler.onAfterRequestHeadersSent(this);
            }
            if (this.isRequiresOutputStream()) {
                this.outputStream = new HTTPOutputStream(outputStream);
            } else {
                this.connectInputStream();
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public void setAllowedResponseCodes(int[] codes) {
        if (codes == null) {
            throw new IllegalArgumentException("codes==null");
        }
        this.allowedResponseCodes = codes;
    }

    @Override
    public void setCharset(String Charset2) {
        this.customcharset = Charset2;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.requestedConnectTimeout = Math.max(0, connectTimeout);
    }

    @Override
    public void setContentDecoded(boolean b) {
        if (this.convertedInputStream != null) {
            throw new IllegalStateException("InputStream already in use!");
        }
        this.contentDecoded = b;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        try {
            Socket socket;
            this.readTimeout = Math.max(0, readTimeout);
            SocketStreamInterface connectionSocket = this.getConnectionSocket();
            if (connectionSocket != null && (socket = connectionSocket.getSocket()) != null) {
                socket.setSoTimeout(this.readTimeout);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setRequestMethod(HTTPConnection.RequestMethod method) {
        this.httpMethod = method;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRequestInfo());
        sb.append(this.getResponseInfo());
        return sb.toString();
    }

    @Override
    public void setSSLTrustALL(boolean trustALL) {
        this.sslTrustALL = trustALL;
    }

    @Override
    public boolean isSSLTrustALL() {
        return this.sslTrustALL;
    }

    @Override
    public void setLegacyConnectEnabled(boolean enabled) {
        this.legacyConnectFlag = enabled;
    }

    @Override
    public boolean isLegacyConnectEnabled() {
        return this.legacyConnectFlag;
    }

    public static enum KEEPALIVE {
        DISABLED,
        EXTERNAL_EXCEPTION;

    }

    protected static enum SSL_STATE {
        NA,
        PROXY,
        ENDPOINT;

    }

    protected class TryNextConnectException
    extends IOException {
        protected TryNextConnectException(Throwable cause) {
            super(cause);
        }
    }
}

