/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.meteredconnection;

import java.io.IOException;
import java.io.InputStream;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class MeteredInputStream
extends InputStream
implements SpeedMeterInterface {
    private final InputStream in;
    private final SpeedMeterInterface speedmeter;
    private volatile long transfered = 0L;
    public static final int LOWStep = 1024;
    private int checkStep = 1024;
    private long transfered2 = 0L;
    private long time = 0L;
    private long speed = 0L;

    public long getTransfered() {
        return this.transfered;
    }

    @Deprecated
    public MeteredInputStream(InputStream in) {
        this(in, null);
    }

    public MeteredInputStream(InputStream in, SpeedMeterInterface speedmeter) {
        this.in = in;
        this.speedmeter = speedmeter;
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        if (ret != -1) {
            ++this.transfered;
        }
        return ret;
    }

    public int getCheckStepSize() {
        return this.checkStep;
    }

    public void setCheckStepSize(int step) {
        this.checkStep = Math.max(1024, step);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int offset = off;
        int rest = len;
        int readNum = 0;
        SpeedMeterInterface.Resolution resolution = this.getResolution();
        long maxReadTime = resolution.factor / 5L;
        int maxRead = this.checkStep;
        while (rest != 0) {
            boolean limitedStep;
            int toRead = rest;
            if (toRead > maxRead) {
                toRead = maxRead;
                limitedStep = true;
            } else {
                limitedStep = false;
            }
            long timeForCheckStep = this.getTime();
            int read = this.in.read(b, offset, toRead);
            long timeCheck = this.getTime() - timeForCheckStep;
            if (read == -1) {
                if (readNum != 0) break;
                return -1;
            }
            if (timeCheck == 0L) {
                if (limitedStep && read == toRead) {
                    long nextRead = maxRead + 1024;
                    this.checkStep = maxRead = Math.max(1024, (int)Math.min(Integer.MAX_VALUE, nextRead));
                }
            } else if (timeCheck > maxReadTime) {
                long nextCheckStep = (long)read / timeCheck * maxReadTime;
                this.checkStep = maxRead = Math.max(1024, (int)nextCheckStep);
            }
            readNum += read;
            this.transfered += (long)read;
            rest -= read;
            offset += read;
        }
        return readNum;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized long getValue(SpeedMeterInterface.Resolution resolution) {
        long now = this.getTime();
        long trans = this.transfered;
        if (this.time == 0L) {
            this.time = now;
            this.transfered2 = trans;
            return 0L;
        }
        long last = now - this.time;
        if (last < resolution.factor) {
            if (this.speedmeter != null) {
                return this.speedmeter.getValue(resolution);
            }
            return this.speed;
        }
        this.time = now;
        long diff = trans - this.transfered2;
        this.transfered2 = trans;
        if (this.speedmeter != null) {
            this.speedmeter.putBytes(diff, last);
            this.speed = this.speedmeter.getValue(resolution);
            return this.speed;
        }
        SpeedMeterInterface.Resolution internal = this.getResolution();
        this.speed = diff / last * internal.factor;
        return this.speed;
    }

    protected long getTime() {
        return this.getResolution().getTime();
    }

    @Override
    public SpeedMeterInterface.Resolution getResolution() {
        if (this.speedmeter != null) {
            return this.speedmeter.getResolution();
        }
        return SpeedMeterInterface.Resolution.MILLI_SECONDS;
    }

    @Override
    public void putBytes(long bytes, long time) {
    }

    @Override
    public synchronized void resetSpeedmeter() {
        if (this.speedmeter != null) {
            this.speedmeter.resetSpeedmeter();
        }
        this.speed = 0L;
        this.transfered2 = this.transfered;
        this.time = this.getTime();
    }
}

