/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.OutputStream;
import org.appwork.utils.net.throttledconnection.ThrottledOutputStream;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class MeteredThrottledOutputStream
extends ThrottledOutputStream
implements SpeedMeterInterface {
    private final SpeedMeterInterface speedmeter;
    private long time = 0L;
    private long speed = 0L;
    private long transferedCounter3;
    private final Object LOCK = new Object();

    @Deprecated
    public MeteredThrottledOutputStream(OutputStream out) {
        this(out, null);
    }

    public MeteredThrottledOutputStream(OutputStream out, SpeedMeterInterface speedmeter) {
        super(out);
        this.speedmeter = speedmeter;
    }

    protected long getTime() {
        return this.getResolution().getTime();
    }

    @Override
    public SpeedMeterInterface.Resolution getResolution() {
        if (this.speedmeter != null) {
            return this.speedmeter.getResolution();
        }
        return SpeedMeterInterface.Resolution.MILLI_SECONDS;
    }

    @Override
    public synchronized long getValue(SpeedMeterInterface.Resolution resolution) {
        long now = this.getTime();
        long trans = this.transferedCounter;
        if (this.time == 0L) {
            this.transferedCounter3 = trans;
            this.time = now;
            return 0L;
        }
        long last = now - this.time;
        if (last < resolution.factor) {
            if (this.speedmeter != null) {
                return this.speedmeter.getValue(resolution);
            }
            return this.speed;
        }
        long diff = trans - this.transferedCounter3;
        this.transferedCounter3 = trans;
        this.time = now;
        if (this.speedmeter != null) {
            this.speedmeter.putBytes(diff, last);
            this.speed = this.speedmeter.getValue(resolution);
            return this.speed;
        }
        SpeedMeterInterface.Resolution internal = this.getResolution();
        this.speed = diff / last * internal.factor;
        return this.speed;
    }

    @Override
    public void putBytes(long bytes, long time) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSpeedmeter() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.speedmeter != null) {
                this.speedmeter.resetSpeedmeter();
            }
            this.time = this.getTime();
            this.speed = 0L;
            this.transferedCounter3 = this.transferedCounter;
        }
    }
}

