/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.appwork.utils.os.DesktopSupport;
import org.appwork.utils.os.NotSupportedException;

public class DesktopSupportJavaDesktop
implements DesktopSupport {
    private Boolean openFileSupported = null;
    private Boolean browseURLSupported = null;

    @Override
    public void browseURL(URL url) throws IOException, URISyntaxException {
        if (!this.isBrowseURLSupported()) {
            throw new IOException("browseURL not supported");
        }
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(url.toURI());
    }

    @Override
    public long[] killProcessesByExecutablePath(String path, int exitCode) throws InterruptedException, NotSupportedException {
        throw new NotSupportedException("Operating System not supported");
    }

    @Override
    public boolean isBrowseURLSupported() {
        if (this.browseURLSupported != null) {
            return this.browseURLSupported;
        }
        if (!Desktop.isDesktopSupported()) {
            this.browseURLSupported = false;
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            this.browseURLSupported = false;
            return false;
        }
        this.browseURLSupported = true;
        return true;
    }

    @Override
    public boolean isOpenFileSupported() {
        if (this.openFileSupported != null) {
            return this.openFileSupported;
        }
        if (!Desktop.isDesktopSupported()) {
            this.openFileSupported = false;
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.OPEN)) {
            this.openFileSupported = false;
            return false;
        }
        this.openFileSupported = true;
        return true;
    }

    @Override
    public void openFile(File file) throws IOException {
        if (this.isOpenFileSupported()) {
            Desktop desktop = Desktop.getDesktop();
            URI uri = file.getCanonicalFile().toURI();
            desktop.open(new File(uri));
        }
    }

    @Override
    public boolean shutdown(boolean force) throws InterruptedException {
        return false;
    }

    @Override
    public boolean standby() throws InterruptedException {
        return false;
    }

    @Override
    public boolean hibernate() throws InterruptedException {
        return false;
    }

    @Override
    public String getDefaultDownloadDirectory() {
        return null;
    }

    @Override
    public String getProcessExecutablePathByPID(long pid) throws NotSupportedException, InterruptedException {
        throw new NotSupportedException("Operating System not supported");
    }

    @Override
    public String getProcessCommandlineByPID(long pid) throws NotSupportedException, InterruptedException {
        throw new NotSupportedException("Operating System not supported");
    }

    @Override
    public int getPrefixLength(String pathname) {
        if (pathname.length() == 0) {
            return 0;
        }
        return pathname.charAt(0) == '/' ? 1 : 0;
    }

    @Override
    public boolean reboot(boolean force, int waitms) throws InterruptedException {
        return false;
    }
}

