/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.DesktopSupport;
import org.appwork.utils.os.DesktopSupportJavaDesktop;
import org.appwork.utils.os.NotSupportedException;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.processes.ProcessOutput;

public class DesktopSupportLinux
implements DesktopSupport {
    private final DesktopSupportJavaDesktop fallBack = new DesktopSupportJavaDesktop();
    private final String[] linuxFileOpen;
    private final String[] linuxBrowseUrl;
    private final WINDOW_MANAGER windowManager;
    private final boolean waylandDetected;

    public boolean isWayland() {
        return this.waylandDetected;
    }

    private final boolean contains(String string, String value) {
        return string != null && value != null && string.toLowerCase(Locale.ENGLISH).contains(value.toLowerCase(Locale.ENGLISH));
    }

    private static final boolean isEmpty(String ip) {
        return ip == null || ip.length() == 0 || ip.trim().length() == 0;
    }

    protected void log(String message) {
        LogV3.info(message);
    }

    protected void log(Throwable throwable) {
        LogV3.log(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesktopSupportLinux() {
        ArrayList<String> log = new ArrayList<String>();
        try {
            String[] openCommand;
            String sunDesktop = System.getProperty("sun.desktop");
            String XDG_CURRENT_DESKTOP = System.getenv("XDG_CURRENT_DESKTOP");
            String XDG_SESSION_TYPE = System.getenv("XDG_SESSION_TYPE");
            String WAYLAND_DISPLAY = System.getenv("WAYLAND_DISPLAY");
            String GNOME_DESKTOP_SESSION_ID = System.getenv("GNOME_DESKTOP_SESSION_ID");
            String KDE_FULL_SESSION = System.getenv("KDE_FULL_SESSION");
            String KDE_SESSION_VERSION = System.getenv("KDE_SESSION_VERSION");
            String GDMSESSION = System.getenv("GDMSESSION");
            String DESKTOP_SESSION = System.getenv("DESKTOP_SESSION");
            if (this.contains(XDG_CURRENT_DESKTOP, "wayland")) {
                log.add("Wayland detected:XDG_CURRENT_DESKTOP=" + XDG_CURRENT_DESKTOP);
                this.waylandDetected = true;
            } else if (this.contains(GDMSESSION, "wayland")) {
                log.add("Wayland detected:GDMSESSION=" + GDMSESSION);
                this.waylandDetected = true;
            } else if (this.contains(XDG_SESSION_TYPE, "wayland")) {
                log.add("Wayland detected:XDG_SESSION_TYPE=" + XDG_SESSION_TYPE);
                this.waylandDetected = true;
            } else if (this.contains(WAYLAND_DISPLAY, "wayland")) {
                log.add("Wayland detected:WAYLAND_DISPLAY=" + WAYLAND_DISPLAY);
                this.waylandDetected = true;
            } else {
                this.waylandDetected = false;
            }
            if (this.contains(XDG_CURRENT_DESKTOP, "Unity") || this.contains(GDMSESSION, "ubuntu")) {
                if (this.contains(GDMSESSION, "ubuntu-2d")) {
                    log.add("Unity-2D Desktop detected");
                } else {
                    log.add("Unity-3D Desktop detected");
                }
                this.windowManager = WINDOW_MANAGER.UNITY;
                openCommand = new String[]{"gnome-open", "%s"};
            } else if (this.contains(XDG_CURRENT_DESKTOP, "GNOME") || !DesktopSupportLinux.isEmpty(GNOME_DESKTOP_SESSION_ID) && !"this-is-deprecated".equals(GNOME_DESKTOP_SESSION_ID) || this.contains(GDMSESSION, "GNOME") || this.contains(GDMSESSION, "gnome-shell") || this.contains(GDMSESSION, "gnome-classic") || this.contains(GDMSESSION, "gnome-fallback") || this.contains(GDMSESSION, "cinnamon")) {
                log.add("Gnome Desktop detected");
                this.windowManager = WINDOW_MANAGER.GNOME;
                openCommand = new String[]{"gnome-open", "%s"};
            } else if (this.contains(XDG_CURRENT_DESKTOP, "mate") || this.contains(DESKTOP_SESSION, "mate")) {
                log.add("Mate Desktop detected");
                this.windowManager = WINDOW_MANAGER.MATE;
                openCommand = new String[]{"gnome-open", "%s"};
            } else if (this.contains(XDG_CURRENT_DESKTOP, "kde") || this.contains(KDE_FULL_SESSION, "true") || this.contains(DESKTOP_SESSION, "kde-plasma")) {
                if (KDE_SESSION_VERSION != null) {
                    log.add("KDE Version " + KDE_SESSION_VERSION + " detected");
                } else {
                    log.add("KDE detected");
                }
                this.windowManager = WINDOW_MANAGER.KDE;
                String kdeOpenCommand = "kde-open";
                if (KDE_SESSION_VERSION != null) {
                    try {
                        if (Integer.parseInt(KDE_SESSION_VERSION) >= 5) {
                            kdeOpenCommand = "kde-open5";
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                openCommand = new String[]{kdeOpenCommand, "%s"};
            } else if (this.contains(XDG_CURRENT_DESKTOP, "XFCE")) {
                log.add("XFCE detected");
                this.windowManager = WINDOW_MANAGER.XFCE;
                openCommand = new String[]{"xdg-open", "%s"};
            } else {
                log.add("sun.Desktop: " + sunDesktop);
                log.add("XDG_CURRENT_DESKTOP: " + XDG_CURRENT_DESKTOP);
                log.add("XDG_SESSION_TYPE: " + XDG_SESSION_TYPE);
                log.add("KDE_FULL_SESSION: " + KDE_FULL_SESSION);
                log.add("KDE_SESSION_VERSION: " + KDE_SESSION_VERSION);
                log.add("DESKTOP_SESSION: " + DESKTOP_SESSION);
                log.add("GNOME_DESKTOP_SESSION_ID: " + GNOME_DESKTOP_SESSION_ID);
                this.windowManager = WINDOW_MANAGER.UNKNOWN;
                openCommand = null;
            }
            if (GraphicsEnvironment.isHeadless()) {
                this.linuxBrowseUrl = null;
                this.linuxFileOpen = null;
            } else {
                if (!DesktopSupportLinux.isEmpty(XDG_CURRENT_DESKTOP)) {
                    this.linuxFileOpen = new String[]{"xdg-open", "%s"};
                    this.linuxBrowseUrl = new String[]{"xdg-open", "%s"};
                } else {
                    this.linuxFileOpen = openCommand;
                    this.linuxBrowseUrl = openCommand;
                }
                log.add("linuxFileOpen:" + (this.linuxFileOpen == null ? null : Arrays.asList(this.linuxFileOpen)));
                log.add("linuxBrowseUrl:" + (this.linuxBrowseUrl == null ? null : Arrays.asList(this.linuxBrowseUrl)));
            }
        }
        finally {
            this.log(((Object)log).toString());
        }
    }

    @Override
    public void browseURL(URL url) throws IOException, URISyntaxException {
        if (!this.openCustom(this.linuxBrowseUrl, url.toExternalForm())) {
            this.fallBack.browseURL(url);
        }
    }

    public WINDOW_MANAGER getWindowManager() {
        return this.windowManager;
    }

    @Override
    public boolean isBrowseURLSupported() {
        if (this.linuxBrowseUrl != null && this.linuxBrowseUrl.length >= 2) {
            return true;
        }
        return this.fallBack.isBrowseURLSupported();
    }

    public boolean isGnomeDesktop() {
        switch (this.windowManager) {
            case GNOME: 
            case MATE: 
            case UNITY: {
                return true;
            }
        }
        return false;
    }

    public boolean isKDEDesktop() {
        switch (this.windowManager) {
            case KDE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOpenFileSupported() {
        return this.linuxFileOpen != null && this.linuxFileOpen.length >= 2 || this.fallBack.isOpenFileSupported();
    }

    public boolean isXFCEDesktop() {
        switch (this.windowManager) {
            case XFCE: {
                return true;
            }
        }
        return false;
    }

    private boolean openCustom(String[] custom, String what) throws IOException {
        try {
            return CrossSystem.openCustom(custom, what);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void openFile(File file) throws IOException {
        if (!this.openCustom(this.linuxFileOpen, file.getAbsolutePath())) {
            this.fallBack.openFile(file);
        }
    }

    @Override
    public boolean shutdown(boolean force) {
        try {
            this.dbusPowerState("Shutdown");
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        try {
            ProcessBuilderFactory.runCommand("dcop", "--all-sessions", "--all-users", "ksmserver", "ksmserver", "logout", "0", "2", "0");
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        try {
            ProcessBuilderFactory.runCommand("poweroff");
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        try {
            ProcessBuilderFactory.runCommand("sudo", "shutdown", "-P", "now");
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        try {
            ProcessBuilderFactory.runCommand("sudo", "shutdown", "-Ph", "now");
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        return true;
    }

    private void dbusPowerState(String command) {
        try {
            ProcessOutput output = ProcessBuilderFactory.runCommand("dbus-send", "--session", "--dest=org.freedesktop.PowerManagement", "--type=method_call", "--print-reply", "--reply-timeout=2000", "/org/freedesktop/PowerManagement", "org.freedesktop.PowerManagement." + command);
            if (output.getErrOutString().contains("org.freedesktop.DBus.Error.ServiceUnknown")) {
                ProcessBuilderFactory.runCommand("dbus-send", "--system", "--print-reply", "--dest=org.freedesktop.login1", "/org/freedesktop/login1", "org.freedesktop.login1.Manager." + command, "boolean:true");
            }
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
    }

    @Override
    public boolean standby() {
        try {
            this.dbusPowerState("Suspend");
            return true;
        }
        catch (Throwable e) {
            this.log(e);
            this.log("no standby support, use shutdown");
            return false;
        }
    }

    @Override
    public boolean hibernate() {
        try {
            this.dbusPowerState("Hibernate");
            return true;
        }
        catch (Throwable e) {
            this.log(e);
            this.log("no hibernate support, use shutdown");
            return false;
        }
    }

    @Override
    public String getDefaultDownloadDirectory() {
        String XDG_DOWNLOAD_DIR = System.getenv("XDG_DOWNLOAD_DIR");
        if (!DesktopSupportLinux.isEmpty(XDG_DOWNLOAD_DIR)) {
            if (XDG_DOWNLOAD_DIR.startsWith("/") && !XDG_DOWNLOAD_DIR.contains("$")) {
                return XDG_DOWNLOAD_DIR;
            }
            if (XDG_DOWNLOAD_DIR.contains("$")) {
                String HOME = System.getenv("HOME");
                String downloadDirectory = null;
                if (!DesktopSupportLinux.isEmpty(HOME) && XDG_DOWNLOAD_DIR.contains("$HOME")) {
                    downloadDirectory = XDG_DOWNLOAD_DIR.replaceFirst("\\$HOME", HOME);
                }
                if (downloadDirectory != null && !downloadDirectory.contains("$")) {
                    return downloadDirectory;
                }
            }
        }
        return null;
    }

    @Override
    public String getProcessExecutablePathByPID(long pid) throws NotSupportedException {
        throw new NotSupportedException("Operating System not supported");
    }

    @Override
    public String getProcessCommandlineByPID(long pid) throws NotSupportedException {
        throw new NotSupportedException("Operating System not supported");
    }

    @Override
    public long[] killProcessesByExecutablePath(String path, int exitCode) throws InterruptedException, NotSupportedException {
        throw new NotSupportedException("Operating System not supported");
    }

    @Override
    public int getPrefixLength(String pathname) {
        if (pathname.length() == 0) {
            return 0;
        }
        return pathname.charAt(0) == '/' ? 1 : 0;
    }

    @Override
    public boolean reboot(boolean force, int waitms) throws InterruptedException {
        try {
            this.dbusPowerState("Reboot");
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        return true;
    }

    public static enum WINDOW_MANAGER {
        XFCE,
        GNOME,
        MATE,
        UNITY,
        KDE,
        UNKNOWN;

    }
}

