/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.appwork.builddecision.BuildDecisionRequired;
import org.appwork.exceptions.WTFException;
import org.appwork.jna.windows.Iphlpapi;
import org.appwork.jna.windows.MIB_TCPROW2;
import org.appwork.jna.windows.MIB_TCPTABLE2;
import org.appwork.loggingv3.LogV3;
import org.appwork.testframework.AWTestValidateClassReference;
import org.appwork.utils.os.DesktopSupportWindows;

@BuildDecisionRequired(tags={"DesktopSupportWindowsViaJNA.yes", "DesktopSupportWindowsViaJNA.no"}, imports={"org.appwork.utils.os.DesktopSupportWindowsViaJNA", ""}, dependsOn={"JNAHelper.useJNA", ""})
public class DesktopSupportWindowsViaJNA
extends DesktopSupportWindows {
    @AWTestValidateClassReference
    static final String ORG_APPWORK_UTILS_OS_DESKTOP_SUPPORT_WINDOWS_VIA_JNA = "org.appwork.utils.os.DesktopSupportWindowsViaJNA";
    public static final String DESKTOP_SUPPORT_WINDOWS_VIA_JNA_NO = "DesktopSupportWindowsViaJNA.no";
    public static final String DESKTOP_SUPPORT_WINDOWS_VIA_JNA_YES = "DesktopSupportWindowsViaJNA.yes";

    public static byte[] int32toBytes(int hex) {
        byte[] b = new byte[4];
        b[3] = (byte)((hex & 0xFF000000) >> 24);
        b[2] = (byte)((hex & 0xFF0000) >> 16);
        b[1] = (byte)((hex & 0xFF00) >> 8);
        b[0] = (byte)(hex & 0xFF);
        return b;
    }

    public static int switchbytes(WinDef.DWORD value) {
        int b1 = (value.intValue() & 0xFF00) >> 8;
        int b2 = value.intValue() & 0xFF;
        int port = (b2 << 8) + b1;
        return port;
    }

    public static InetAddress getInetAdress(WinDef.DWORD d) {
        int dwLocalAddr = d.intValue();
        try {
            if (dwLocalAddr == 0) {
                return null;
            }
            byte[] bytes = DesktopSupportWindowsViaJNA.int32toBytes(dwLocalAddr);
            InetAddress address = InetAddress.getByAddress(bytes);
            return address;
        }
        catch (UnknownHostException e) {
            LogV3.log(e);
            return null;
        }
    }

    @Override
    public int getPIDForRemoteAddress(SocketAddress adr) throws InterruptedException {
        try {
            Memory mem;
            InetAddress requestingAddress = ((InetSocketAddress)adr).getAddress();
            int port = ((InetSocketAddress)adr).getPort();
            IntByReference psize = new IntByReference(0);
            psize.setValue(0);
            boolean sort = true;
            MIB_TCPTABLE2 table = null;
            if (Iphlpapi.INSTANCE.GetTcpTable2(null, psize, true) == 122) {
                mem = new Memory((long)psize.getValue());
                if (Iphlpapi.INSTANCE.GetTcpTable2(mem, psize, true) != 0) {
                    throw new WTFException("ERROR");
                }
            } else {
                throw new WTFException();
            }
            table = new MIB_TCPTABLE2(mem);
            LogV3.info("Table Size: " + table.table.length + "/" + table.dwNumEntries.intValue());
            for (int i = 0; i < table.dwNumEntries.intValue(); ++i) {
                MIB_TCPROW2 e = table.table[i];
                if (e == null || !requestingAddress.equals(DesktopSupportWindowsViaJNA.getInetAdress(e.dwLocalAddr)) || DesktopSupportWindowsViaJNA.switchbytes(e.dwLocalPort) != port) continue;
                long ret = e.dwOwningPid.longValue();
                LogV3.fine("Get PID By socket(JNA): " + adr + " -> " + ret);
                return (int)ret;
            }
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        LogV3.fine("Get PID By socket(JNA): " + adr + " -> NONE. try fallback.");
        return super.getPIDForRemoteAddress(adr);
    }
}

