/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.appwork.JNAHelper;
import org.appwork.utils.JavaVersion;
import org.appwork.utils.ReflectionUtils;

public class LinuxUtils {
    public static boolean isRoot() {
        try {
            Class<?> unixSystem = Class.forName("com.sun.security.auth.module.UnixSystem");
            Object instance = unixSystem.getConstructor(new Class[0]).newInstance(new Object[0]);
            return ReflectionUtils.invoke(unixSystem, "getUid", instance, Long.TYPE, new Object[0]) == 0L;
        }
        catch (Throwable unixSystem) {
            try {
                File procSelf;
                if (JavaVersion.getVersion().isMinimum(JavaVersion.JVM_1_7) && (procSelf = new File("/proc/self")).isDirectory()) {
                    return (Integer)Files.getAttribute(procSelf.toPath(), "unix:uid", new LinkOption[0]) == 0;
                }
            }
            catch (UnsupportedOperationException procSelf) {
            }
            catch (IllegalArgumentException procSelf) {
            }
            catch (Throwable procSelf) {
                // empty catch block
            }
            try {
                if (JNAHelper.isJNAAvailable()) {
                    Object instance;
                    Class<?> libc = Class.forName("com.sun.jna.platform.unix.LibC");
                    Class<?> libcApi = Class.forName("com.sun.jna.platform.unix.LibCAPI");
                    return ReflectionUtils.invoke(libcApi, "getuid", instance = ReflectionUtils.getFieldValue(libc, "INSTANCE", libc, libc), Integer.TYPE, new Object[0]) == 0;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }
}

