/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.parser;

import java.util.ArrayList;
import java.util.List;
import org.appwork.loggingv3.LogV3;

public class ShellParser {
    private static int min(int space, int q, int dq) {
        if (space == -1) {
            space = Integer.MAX_VALUE;
        }
        if (q == -1) {
            q = Integer.MAX_VALUE;
        }
        if (dq == -1) {
            dq = Integer.MAX_VALUE;
        }
        return Math.min(Math.min(space, q), dq);
    }

    public static List<String> splitCommandString(String command) {
        ArrayList<String> ret = new ArrayList<String>();
        while (true) {
            int ec;
            int escapes;
            int nq;
            int space = command.indexOf(" ");
            int q = command.indexOf("'");
            while (q != -1) {
                int escapes2 = 0;
                int ec2 = 1;
                while (q - ec2 >= 0 && command.charAt(q - ec2++) == '\\') {
                    ++escapes2;
                }
                if (escapes2 % 2 == 0) break;
                q = command.indexOf("'", q + 1);
            }
            int dq = command.indexOf("\"");
            while (dq != -1) {
                int escapes3 = 0;
                int ec3 = 1;
                while (dq - ec3 >= 0 && command.charAt(dq - ec3++) == '\\') {
                    ++escapes3;
                }
                if (escapes3 % 2 == 0) break;
                dq = command.indexOf("\"", dq + 1);
            }
            int min = ShellParser.min(space, q, dq);
            if (min == Integer.MAX_VALUE) {
                if (command.trim().length() > 0) {
                    ret.add(command);
                }
                return ret;
            }
            if (min == space) {
                String p = command.substring(0, min).trim();
                if (p.length() > 0) {
                    ret.add(p);
                }
                command = command.substring(min + 1);
                continue;
            }
            if (min == q) {
                nq = command.indexOf("'", min + 1);
                while (true) {
                    if (nq == -1) {
                        nq = command.length() - 1;
                        LogV3.warning("Malformed commandstring");
                        break;
                    }
                    escapes = 0;
                    ec = 1;
                    while (command.charAt(nq - ec++) == '\\') {
                        ++escapes;
                    }
                    if (escapes % 2 == 0) break;
                    nq = command.indexOf("'", nq + 1);
                }
                ret.add(command.substring(min + 1, nq));
                command = command.substring(Math.min(nq + 2, command.length()));
                continue;
            }
            if (min != dq) continue;
            nq = command.indexOf("\"", min + 1);
            while (true) {
                if (nq == -1) {
                    nq = command.length() - 1;
                    LogV3.warning("Malformed commandstring");
                    break;
                }
                escapes = 0;
                ec = 1;
                while (command.charAt(nq - ec++) == '\\') {
                    ++escapes;
                }
                if (escapes % 2 == 0) break;
                nq = command.indexOf("\"", nq + 1);
            }
            ret.add(command.substring(min + 1, nq));
            command = command.substring(Math.min(nq + 2, command.length()));
        }
    }
}

