/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.windowflasher;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.Timer;
import org.appwork.utils.swing.EDTRunner;

public class WindowFlasher {
    private final JFrame window;
    private final List<Image> flashIcons;
    private List<Image> icons;
    private Timer iconFlashTimer;
    private volatile boolean running = false;

    public WindowFlasher(JFrame frame, List<Image> list) {
        this.window = frame;
        this.flashIcons = list;
        WindowAdapter windowWindowAdapter = new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (WindowFlasher.this.running) {
                    WindowFlasher.this.stop();
                }
            }
        };
        this.window.addWindowFocusListener(windowWindowAdapter);
    }

    public boolean hasFocus() {
        return this.window.isFocused();
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void set(boolean flashy) {
        if (flashy) {
            this.window.setIconImages(this.flashIcons);
        } else {
            this.window.setIconImages(this.icons);
        }
    }

    public synchronized void start() {
        if (!this.hasFocus()) {
            this.running = true;
            if (this.flashIcons != null && this.iconFlashTimer == null) {
                this.icons = this.window.getIconImages();
                this.iconFlashTimer = new Timer(500, new ActionListener(){
                    private boolean flashy = false;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.flashy = !this.flashy;
                        WindowFlasher.this.set(this.flashy);
                    }
                });
                this.iconFlashTimer.setRepeats(true);
                this.iconFlashTimer.start();
            }
        }
    }

    public void stop() {
        this.running = false;
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (WindowFlasher.this.iconFlashTimer != null) {
                    WindowFlasher.this.iconFlashTimer.stop();
                    WindowFlasher.this.iconFlashTimer = null;
                    new EDTRunner(){

                        @Override
                        protected void runInEDT() {
                            WindowFlasher.this.set(false);
                        }
                    };
                }
            }
        };
    }
}

