/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.logging;

import java.util.WeakHashMap;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.linkchecker.LinkCheckerThread;
import jd.controlling.linkcrawler.LinkCrawlerThread;
import jd.http.BrowserSettingsThread;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import org.appwork.utils.event.queue.QueueThread;
import org.appwork.utils.logging2.LogConsoleHandler;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSink;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.LogSourceProvider;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionQueue;

public class LogController
extends LogSourceProvider {
    private static final LogController INSTANCE = new LogController();
    public static LogSource TRASH = new LogSource("Trash"){

        @Override
        public synchronized void log(LogRecord record) {
        }

        @Override
        public String toString() {
            return "Log > /dev/null!";
        }
    };
    private static final WeakHashMap<Thread, LogInterface> MAP = new WeakHashMap();

    public static LogController getInstance() {
        return INSTANCE;
    }

    private LogController() {
        super(System.currentTimeMillis());
        LoggerFactory.I().setDelegate(this);
    }

    public static LogSource CL(Class<?> clazz) {
        LogSource ret = LogController.getRebirthLogger();
        if (ret != null) {
            return ret;
        }
        return LogController.getInstance().getClassLogger(clazz);
    }

    public static LogSource CL() {
        return LogController.CL(true);
    }

    public static LogSource CL(boolean allowRebirthLogger) {
        LogSource ret;
        if (allowRebirthLogger && (ret = LogController.getRebirthLogger()) != null) {
            return ret;
        }
        return LogController.getInstance().getCurrentClassLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogSource getRebirthLogger() {
        LogInterface logger = null;
        Thread currentThread = Thread.currentThread();
        WeakHashMap<Thread, LogInterface> weakHashMap = MAP;
        synchronized (weakHashMap) {
            logger = MAP.get(currentThread);
        }
        if (logger == null) {
            if (currentThread instanceof LinkCrawlerThread) {
                Object owner = ((LinkCrawlerThread)currentThread).getCurrentOwner();
                if (owner != null) {
                    if (owner instanceof PluginForDecrypt) {
                        logger = ((PluginForDecrypt)owner).getLogger();
                    } else if (owner instanceof PluginForHost) {
                        logger = ((PluginForHost)owner).getLogger();
                    } else if (owner instanceof PluginsC) {
                        logger = ((PluginsC)owner).getLogger();
                    }
                }
            } else if (currentThread instanceof SingleDownloadController) {
                logger = ((SingleDownloadController)currentThread).getLogger();
            } else if (currentThread instanceof QueueThread && ((QueueThread)currentThread).getQueue() instanceof ExtractionQueue) {
                ExtractionController currentExtraction = ((ExtractionQueue)((QueueThread)currentThread).getQueue()).getCurrentQueueEntry();
                if (currentExtraction != null) {
                    logger = currentExtraction.getLogger();
                }
            } else if (currentThread instanceof LinkCheckerThread) {
                LinkCheckerThread lc = (LinkCheckerThread)currentThread;
                logger = lc.getLogger();
            } else if (currentThread instanceof BrowserSettingsThread) {
                BrowserSettingsThread bst = (BrowserSettingsThread)currentThread;
                logger = bst.getLogger();
            }
        }
        if (logger != null && logger instanceof LogSource) {
            LogSource ret = (LogSource)logger;
            return ret;
        }
        return null;
    }

    public static LogInterface getRebirthLogger(LogInterface fallbackLogger) {
        if (fallbackLogger == null) {
            throw new IllegalArgumentException("fallbackLogger is null");
        }
        LogSource ret = LogController.getRebirthLogger();
        if (ret == null) {
            return fallbackLogger;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogInterface setRebirthLogger(LogInterface logger) {
        Thread currentThread = Thread.currentThread();
        WeakHashMap<Thread, LogInterface> weakHashMap = MAP;
        synchronized (weakHashMap) {
            if (logger == null) {
                return MAP.remove(currentThread);
            }
            return MAP.put(currentThread, logger);
        }
    }

    @Override
    public LogSource getLogger(String name) {
        LogSource ret = super.getLogger(name);
        ret.setMaxSizeInMemory(524288);
        return ret;
    }

    public static LogSource getFastPluginLogger(String id) {
        if (LogController.getInstance().isInstantFlushDefault()) {
            return LogController.getInstance().getLogger(id);
        }
        LogSource ret = new LogSource(id){
            LogSource log = null;
            final LogConsoleHandler cHandler = LogController.getInstance().getConsoleHandler();

            @Override
            public synchronized LogSink getLogSink() {
                if (this.log == null) {
                    this.log = LogController.getInstance().getLogger(this.getName());
                }
                return this.log.getLogSink();
            }

            @Override
            public synchronized Logger getParent() {
                if (this.log == null) {
                    this.log = LogController.getInstance().getLogger(this.getName());
                }
                return this.log.getParent();
            }

            @Override
            public synchronized void log(LogRecord record) {
                try {
                    if (this.cHandler != null) {
                        this.cHandler.publish(record);
                    }
                }
                finally {
                    super.log(record);
                }
            }

            @Override
            public synchronized void close() {
                try {
                    super.close();
                }
                finally {
                    if (this.log != null) {
                        this.log.close();
                    }
                }
            }

            @Override
            public synchronized void flush() {
                try {
                    super.flush();
                }
                finally {
                    if (this.log != null) {
                        this.log.flush();
                    }
                }
            }
        };
        ret.setMaxSizeInMemory(262144);
        ret.setAllowTimeoutFlush(false);
        return ret;
    }
}

