/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.gui;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.appwork.resources.AWUTheme;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.swing.synthetica.SyntheticaHelper;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.LAFManagerInterface;
import org.jdownloader.logging.LogController;
import org.jdownloader.updatev2.gui.LAFOptions;
import org.jdownloader.updatev2.gui.LookAndFeelType;

public class LAFManager
implements LAFManagerInterface {
    private static final LAFManager INSTANCE = new LAFManager();
    private final LogSource logger = LogController.getInstance().getLogger(LAFManager.class.getName());
    private String laf;

    private LAFManager() {
    }

    public static LAFManager getInstance() {
        return INSTANCE;
    }

    private static void initLinux() {
        try {
            Field awtAppClassName = Toolkit.getDefaultToolkit().getClass().getDeclaredField("awtAppClassName");
            awtAppClassName.setAccessible(true);
            awtAppClassName.set(null, "JDownloader");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        String theme;
        String lafClassname;
        block32: {
            File cfgFile = Application.getResource("cfg/org.jdownloader.settings.GraphicalUserInterfaceSettings.json");
            lafClassname = null;
            if (cfgFile.isFile()) {
                try {
                    this.logger.info("Load " + cfgFile);
                    String c = IO.readFileToString(cfgFile);
                    Iterator settings = JSonStorage.restoreFromString(c, TypeRef.HASHMAP);
                    if (settings == null || !StringUtils.isEmpty(lafClassname = StringUtils.valueOfOrNull(((HashMap)((Object)settings)).get("customlookandfeelclass")))) break block32;
                    String string = StringUtils.valueOfOrNull(((HashMap)((Object)settings)).get("lookandfeeltheme"));
                    try {
                        if (string == null) {
                            lafClassname = LookAndFeelType.DEFAULT.getClazz();
                            break block32;
                        }
                        lafClassname = LookAndFeelType.valueOf(string).getClazz();
                    }
                    catch (Throwable e) {
                        this.logger.log(e);
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
        }
        try {
            this.laf = lafClassname;
            if (StringUtils.isEmpty(this.laf)) {
                this.laf = LookAndFeelType.DEFAULT.getClazz();
            }
            this.logger.info("Init LAF: " + this.laf);
            if (CrossSystem.isLinux() && !Application.isHeadless()) {
                LAFManager.initLinux();
            }
            ArrayList<File> jars = new ArrayList<File>();
            if (LookAndFeelType.JD_PLAIN.getClazz().equals(this.laf)) {
                jars.add(Application.getResource("libs/laf/synthetica.jar"));
                jars.add(Application.getResource("libs/laf/syntheticaJDCustom.jar"));
                jars.add(Application.getResource("libs/laf/syntheticaJDPlain.jar"));
                jars.add(Application.getResource("libs/laf/syntheticaPlain.jar"));
                for (File file : jars) {
                    if (file.isFile()) continue;
                    throw new Exception("Incomplete synthetica found, missing:" + file);
                }
            } else if (LookAndFeelType.DEFAULT.getClazz().equals(this.laf)) {
                jars.add(Application.getResource("libs/laf/synthetica.jar"));
                jars.add(Application.getResource("libs/laf/syntheticaJDCustom.jar"));
                jars.add(Application.getResource("libs/laf/syntheticaSimple2D.jar"));
                for (File file : jars) {
                    if (file.isFile()) continue;
                    throw new Exception("Incomplete synthetica found, missing:" + file);
                }
            } else {
                File[] lafFiles = Application.getResource("libs/laf/").listFiles();
                if (lafFiles != null) {
                    for (File file : lafFiles) {
                        if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                        jars.add(file);
                    }
                }
            }
            for (final File file : jars) {
                this.logger.info("Add to classpath: " + file);
                String rel = Files.getRelativePath(Application.getTemp().getParentFile(), file);
                File tmp = new File(Application.getTempResource("synthlibs"), rel + ".ts" + file.lastModified());
                if (!tmp.exists()) {
                    try {
                        if (tmp.getParentFile().exists()) {
                            for (File f : tmp.getParentFile().listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File pathname) {
                                    return pathname.getName().startsWith(file.getName() + ".ts");
                                }
                            })) {
                                f.delete();
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.logger.log(exception);
                    }
                    tmp.getParentFile().mkdirs();
                    IO.copyFile(file, tmp);
                }
                Application.addUrlToClassPath(tmp.toURI().toURL(), LAFManager.class.getClassLoader());
            }
            LAFOptions.init(this.laf);
            new SyntheticaHelper(LAFOptions.getInstance().getCfg()).load(this.laf);
            theme = LAFOptions.getInstance().getCfg().getIconSetID();
            AWUTheme.getInstance().setTheme(theme);
        }
        catch (Throwable e) {
            this.logger.log(e);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                LAFOptions.init(UIManager.getSystemLookAndFeelClassName());
                theme = LAFOptions.getInstance().getCfg().getIconSetID();
                AWUTheme.getInstance().setTheme(theme);
            }
            catch (ClassNotFoundException e1) {
                this.logger.log(e1);
            }
            catch (InstantiationException e1) {
                this.logger.log(e1);
            }
            catch (IllegalAccessException e1) {
                this.logger.log(e1);
            }
            catch (UnsupportedLookAndFeelException e1) {
                this.logger.log(e1);
            }
        }
        finally {
            this.logger.flush();
        }
    }
}

