/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.sevenzipjbinding.ArchiveFormat;
import org.jdownloader.extensions.extraction.ArchiveController;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ArchiveSettings;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.content.ContentView;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.split.SplitType;

public class Archive {
    private boolean protect = false;
    private List<ArchiveFile> archives;
    private int exitCode = -1;
    private final ArchiveType archiveType;
    private final SplitType splitType;
    private final List<ArchiveFile> crcError;
    private final List<ArchiveFile> missingFiles;
    private final List<File> extractedFiles;
    private final List<File> skippedFiles;
    private final ArchiveFactory factory;
    private String name;
    private ContentView contents;
    private boolean passwordRequiredToOpen;
    private volatile String archiveID = null;
    private volatile WeakReference<ExtractionController> extractionController = null;
    private volatile ArchiveFormat cachedArchiveFormat = null;

    public static String getBestArchiveID(List<? extends ArchiveFile> archiveFiles, String suggestedArchiveID) {
        HashMap<String, ArchiveFile.ArchiveID> scores = new HashMap<String, ArchiveFile.ArchiveID>();
        for (ArchiveFile archiveFile : archiveFiles) {
            String archiveID;
            if (archiveFile == null || (archiveID = archiveFile.getArchiveID()) == null) continue;
            ArchiveFile.ArchiveID score = (ArchiveFile.ArchiveID)scores.get(archiveID);
            if (score == null) {
                score = new ArchiveFile.ArchiveID(archiveID);
                score.increaseScore();
                scores.put(archiveID, score);
            }
            score.increaseScore();
        }
        if (suggestedArchiveID != null) {
            ArchiveFile.ArchiveID score = (ArchiveFile.ArchiveID)scores.get(suggestedArchiveID);
            if (score == null) {
                if (scores.size() == 0) {
                    return suggestedArchiveID;
                }
                score = new ArchiveFile.ArchiveID(suggestedArchiveID);
                scores.put(suggestedArchiveID, score);
            }
            score.increaseScore();
        }
        if (scores.size() == 0) {
            return null;
        }
        if (scores.size() == 1) {
            return ((ArchiveFile.ArchiveID)scores.values().iterator().next()).getArchiveID();
        }
        ArchiveFile.ArchiveID ret = null;
        for (ArchiveFile.ArchiveID score : scores.values()) {
            if (ret != null && ret.getScore() >= score.getScore()) continue;
            ret = score;
        }
        return ret.getArchiveID();
    }

    public String getFinalPassword() {
        return this.getSettings().getFinalPassword();
    }

    public void setFinalPassword(String password) {
        this.getSettings().setFinalPassword(password);
    }

    public SplitType getSplitType() {
        return this.splitType;
    }

    public ArchiveFile getBestArchiveFileMatch(String fileName) {
        if (this.getArchiveType() != null) {
            return this.getArchiveType().getBestArchiveFileMatch(this, fileName);
        }
        if (this.getSplitType() != null) {
            return this.getSplitType().getBestArchiveFileMatch(this, fileName);
        }
        return null;
    }

    public String getArchiveID() {
        return this.archiveID;
    }

    public void setArchiveID(String archiveID) {
        this.archiveID = archiveID;
    }

    public ArchiveFactory getFactory() {
        return this.factory;
    }

    public Archive(ArchiveFactory link, ArchiveType archiveType) {
        this.factory = link;
        this.archives = new CopyOnWriteArrayList<ArchiveFile>();
        this.crcError = new CopyOnWriteArrayList<ArchiveFile>();
        this.missingFiles = new CopyOnWriteArrayList<ArchiveFile>();
        this.extractedFiles = new CopyOnWriteArrayList<File>();
        this.skippedFiles = new CopyOnWriteArrayList<File>();
        this.contents = new ContentView();
        this.archiveType = archiveType;
        this.splitType = null;
    }

    public Archive(ArchiveFactory link, SplitType splitType) {
        this.factory = link;
        this.archives = new CopyOnWriteArrayList<ArchiveFile>();
        this.crcError = new CopyOnWriteArrayList<ArchiveFile>();
        this.missingFiles = new CopyOnWriteArrayList<ArchiveFile>();
        this.extractedFiles = new CopyOnWriteArrayList<File>();
        this.skippedFiles = new CopyOnWriteArrayList<File>();
        this.contents = new ContentView();
        this.splitType = splitType;
        this.archiveType = null;
    }

    public Archive getParentArchive() {
        return null;
    }

    public Archive getRootArchive() {
        if (this.getParentArchive() != null) {
            return this.getParentArchive().getRootArchive();
        }
        return this;
    }

    public ArchiveFile getLastArchiveFile() {
        if (this.archiveType != null) {
            return ArchiveType.getLastArchiveFile(this);
        }
        if (this.splitType != null) {
            return SplitType.getLastArchiveFile(this);
        }
        return null;
    }

    public ArchiveFormat getArchiveFormat() throws IOException {
        ArchiveType archiveType = this.getArchiveType();
        if (archiveType != null) {
            if (this.cachedArchiveFormat == null) {
                this.cachedArchiveFormat = archiveType.getArchiveFormat(this);
            }
            return this.cachedArchiveFormat;
        }
        return null;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public void setProtected(boolean b) {
        this.protect = b;
    }

    public boolean isPasswordRequiredToOpen() {
        return this.passwordRequiredToOpen;
    }

    public void setPasswordRequiredToOpen(boolean b) {
        this.passwordRequiredToOpen = b;
    }

    public String toString() {
        try {
            return "Archive:" + this.getName();
        }
        catch (Throwable e) {
            return e.getMessage();
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public List<ArchiveFile> getArchiveFiles() {
        return this.archives;
    }

    public void setArchiveFiles(List<ArchiveFile> collection) {
        this.archives = new CopyOnWriteArrayList<ArchiveFile>(collection);
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public void addCrcError(ArchiveFile crc) {
        this.crcError.add(crc);
    }

    public void addMissingFile(ArchiveFile missing) {
        this.missingFiles.add(missing);
    }

    public List<ArchiveFile> getMissingFiles() {
        return this.missingFiles;
    }

    public List<ArchiveFile> getCrcError() {
        return this.crcError;
    }

    public void addExtractedFiles(File file) {
        this.extractedFiles.add(file);
    }

    public List<File> getExtractedFiles() {
        return this.extractedFiles;
    }

    public List<File> getSkippedFiles() {
        return this.skippedFiles;
    }

    public void addSkippedFiles(File file) {
        this.skippedFiles.add(file);
    }

    public boolean contains(Object contains) {
        if (contains == null) {
            return false;
        }
        for (ArchiveFile file : this.getArchiveFiles()) {
            if (!file.contains(contains)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String archiveName) {
        this.name = archiveName;
    }

    public File getFolder() {
        return this.getFactory().getFolder();
    }

    public ContentView getContentView() {
        return this.contents;
    }

    public void setContentView(ContentView view) {
        this.contents = view;
    }

    public ArchiveSettings getSettings() {
        return ArchiveController.getInstance().getArchiveSettings(this.getArchiveID(), this, this.getFactory());
    }

    public ArchiveFile getArchiveFileByPath(String filename) {
        if (filename == null) {
            return null;
        }
        for (ArchiveFile af : this.getArchiveFiles()) {
            if (!filename.equals(af.getFilePath())) continue;
            return af;
        }
        return null;
    }

    protected void setExtractionController(ExtractionController extractionController) {
        this.extractionController = new WeakReference<ExtractionController>(extractionController);
    }

    public ExtractionController getExtractionController() {
        WeakReference<ExtractionController> extractionController = this.extractionController;
        if (extractionController != null) {
            return (ExtractionController)((Object)extractionController.get());
        }
        return null;
    }

    protected void onStartExtracting() {
        this.crcError.clear();
        this.extractedFiles.clear();
        this.skippedFiles.clear();
        this.exitCode = -1;
        this.contents = new ContentView();
    }

    protected void onCleanUp() {
    }

    public void setPasswords(List<String> list) {
        this.getSettings().setPasswords(list);
        this.notifyChanges("PASSWORD");
    }

    private void notifyChanges(Object identifier) {
        for (ArchiveFile af : this.getArchiveFiles()) {
            af.notifyChanges(identifier);
        }
    }

    public void setAutoExtract(BooleanStatus booleanStatus) {
        if (this.getSettings().getAutoExtract() != booleanStatus) {
            this.getSettings().setAutoExtract(booleanStatus);
            this.notifyChanges("AUTO_EXTRACT");
        }
    }
}

