/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.util.ArrayList;
import java.util.List;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.DummyArchiveFile;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.split.SplitType;

public class DummyArchive {
    private final String name;
    private int missingCount = 0;
    private int incompleteCount = 0;
    private final ArchiveType archiveType;
    private final SplitType splitType;
    private final List<DummyArchiveFile> list;

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public SplitType getSplitType() {
        return this.splitType;
    }

    public String getType() {
        if (this.archiveType != null) {
            return this.archiveType.name();
        }
        if (this.splitType != null) {
            return this.splitType.name();
        }
        return null;
    }

    public int getIncompleteCount() {
        return this.incompleteCount;
    }

    public int getMissingCount() {
        return this.missingCount;
    }

    public List<DummyArchiveFile> getList() {
        return this.list;
    }

    public DummyArchive(Archive archive, ArchiveType archiveType) {
        this.name = archive.getName();
        this.archiveType = archiveType;
        this.splitType = null;
        this.list = new ArrayList<DummyArchiveFile>();
    }

    public DummyArchive(Archive archive, SplitType splitType) {
        this.name = archive.getName();
        this.splitType = splitType;
        this.archiveType = null;
        this.list = new ArrayList<DummyArchiveFile>();
    }

    public void add(DummyArchiveFile e) {
        this.list.add(e);
        if (e.isMissing()) {
            ++this.missingCount;
        } else if (Boolean.TRUE.equals(e.isIncomplete())) {
            ++this.incompleteCount;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Archive:");
        sb.append(this.getName());
        sb.append("\r\n");
        sb.append("Type:");
        sb.append(this.getType());
        for (DummyArchiveFile dummyArchiveFile : this.getList()) {
            sb.append("\r\n");
            if (dummyArchiveFile.isMissing()) {
                sb.append("Missing:");
            } else {
                sb.append("Existing:");
            }
            sb.append(dummyArchiveFile.toString());
        }
        sb.append("\r\n");
        sb.append("Complete:");
        sb.append(this.isComplete());
        return sb.toString();
    }

    public boolean isComplete() {
        return this.missingCount == 0 && this.incompleteCount == 0 && this.list.size() > 0;
    }

    public int getSize() {
        return this.list.size();
    }

    public String getName() {
        return this.name;
    }
}

